/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding.intf;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.binding.intf.DefaultMethodHandler;
import ch.kk7.confij.binding.intf.InterfaceProxyBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;

public class IntfaceInvocationHandler
implements InvocationHandler,
Serializable {
    private String className;
    private Map<Method, Object> methodToValues;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return this.invokeObjectClass(proxy, method, args);
        }
        if (InterfaceProxyBuilder.ConfijHandled.class.equals(method.getDeclaringClass())) {
            return this.invokeConfijHandled(proxy, method, args);
        }
        if (this.methodToValues.containsKey(method)) {
            return this.methodToValues.get(method);
        }
        if (method.isDefault()) {
            return this.invokeDefault(proxy, method, args);
        }
        throw new ConfijBindingException("cannot call method '{}' as it was not initialized. initialized are: {}", method, this.methodToValues.keySet());
    }

    protected Object invokeObjectClass(Object proxy, Method method, Object[] args) throws Throwable {
        if ("toString".equals(method.getName())) {
            return this.intfToString();
        }
        if ("equals".equals(method.getName())) {
            return this.intfEquals(proxy, args[0]);
        }
        if ("hashCode".equals(method.getName())) {
            return this.methodToValues.hashCode();
        }
        return method.invoke((Object)this, args);
    }

    protected Object invokeConfijHandled(Object proxy, Method method, Object[] args) throws Throwable {
        return this.methodToValues;
    }

    @Override
    protected Object invokeDefault(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return DefaultMethodHandler.invokeDefaultMethod(proxy, method, args);
        }
        catch (DefaultMethodHandler.DefaultMethodException e) {
            throw e.getThrowable();
        }
    }

    protected String intfToString() {
        return this.className + "{" + this.methodToValues.entrySet().stream().map(e -> ((Method)e.getKey()).getName() + "=" + e.getValue()).collect(Collectors.joining(", ")) + "}";
    }

    protected boolean intfEquals(Object proxy, Object o) {
        if (proxy == o) {
            return true;
        }
        if (!(o instanceof InterfaceProxyBuilder.ConfijHandled)) {
            return false;
        }
        InterfaceProxyBuilder.ConfijHandled that = (InterfaceProxyBuilder.ConfijHandled)o;
        return Objects.equals(this.methodToValues, that.methodToValue());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.className);
        out.writeInt(this.methodToValues.size());
        for (Map.Entry<Method, Object> entry : this.methodToValues.entrySet()) {
            IntfaceInvocationHandler.writeMethodObject(entry.getKey(), out);
            out.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        int size = in.readInt();
        this.methodToValues = new TreeMap<Method, Object>(InterfaceProxyBuilder.methodNameComparator);
        for (int i = 0; i < size; ++i) {
            Method method = IntfaceInvocationHandler.readMethodObject(in);
            Object value = in.readObject();
            this.methodToValues.put(method, value);
        }
    }

    private static void writeMethodObject(Method method, ObjectOutputStream out) throws IOException {
        out.writeObject(method.getDeclaringClass());
        out.writeObject(method.getName());
        out.writeObject(method.getParameterTypes());
    }

    private static Method readMethodObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class clazz = (Class)in.readObject();
        String name = (String)in.readObject();
        Class[] parameterTypes = (Class[])in.readObject();
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("failed to deserialize method " + clazz + "#" + name + "(" + Arrays.asList(parameterTypes) + ")");
        }
    }

    @Generated
    public IntfaceInvocationHandler(String className, Map<Method, Object> methodToValues) {
        this.className = className;
        this.methodToValues = methodToValues;
    }

    @Generated
    public String toString() {
        return "IntfaceInvocationHandler(className=" + this.className + ", methodToValues=" + this.methodToValues + ")";
    }
}

