/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.pipeline.reload;

import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.pipeline.ConfijPipeline;
import ch.kk7.confij.pipeline.reload.ConfijReloadStrategy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public class PeriodicReloadStrategy
implements ConfijReloadStrategy {
    @Generated
    private final Object $lock = new Object[0];
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(PeriodicReloadStrategy.class);
    private final Duration reloadEvery;
    private final Duration initialDelay;
    private final ScheduledExecutorService executor;
    private boolean isInitialized = false;

    public PeriodicReloadStrategy() {
        this(Duration.ofSeconds(30L));
    }

    public PeriodicReloadStrategy(Duration reloadEvery) {
        this(reloadEvery, Duration.ofSeconds(60L));
    }

    public PeriodicReloadStrategy(Duration reloadEvery, Duration initialDelay) {
        this.reloadEvery = PeriodicReloadStrategy.assertPositive(reloadEvery);
        this.initialDelay = PeriodicReloadStrategy.assertPositive(initialDelay);
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    private static Duration assertPositive(Duration duration) {
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("duration must be strictly positive: " + duration);
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(@NonNull ConfijPipeline<?> pipeline) {
        Object object = this.$lock;
        synchronized (object) {
            if (pipeline == null) {
                throw new NullPointerException("pipeline is marked non-null but is null");
            }
            if (this.isInitialized) {
                throw new IllegalStateException("already initialized");
            }
            this.isInitialized = true;
            this.executor.scheduleWithFixedDelay(() -> {
                Thread.currentThread().setName("ConfijReload");
                Instant start = Instant.now();
                LOGGER.debug("starting to reload ConfiJ configuration...", new Object[0]);
                try {
                    pipeline.build();
                    Duration dt = Duration.between(start, Instant.now());
                    LOGGER.debug("successfully reloaded configuration within {}ms", dt);
                }
                catch (Exception e) {
                    LOGGER.info("configuration reloading failed, will retry in {}ms", this.reloadEvery.toMillis(), e);
                }
            }, this.initialDelay.toMillis(), this.reloadEvery.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Generated
    public String toString() {
        return "PeriodicReloadStrategy(reloadEvery=" + this.reloadEvery + ", initialDelay=" + this.initialDelay + ", executor=" + this.executor + ", isInitialized=" + this.isInitialized + ")";
    }
}

