/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.binding;

import ch.kk7.confij.binding.BindingContext;
import ch.kk7.confij.binding.BindingType;
import ch.kk7.confij.binding.ConfigBinding;
import ch.kk7.confij.binding.ConfigBindingFactory;
import ch.kk7.confij.binding.ConfijDefinitionException;
import ch.kk7.confij.binding.array.ArrayBindingFactory;
import ch.kk7.confij.binding.collection.CollectionBindingFactory;
import ch.kk7.confij.binding.intf.InterfaceBindingFactory;
import ch.kk7.confij.binding.leaf.ForcedLeafBindingFactory;
import ch.kk7.confij.binding.leaf.LeafBindingFactory;
import ch.kk7.confij.binding.map.MapBindingFactory;
import ch.kk7.confij.logging.ConfijLogger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class ConfigBinder {
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(ConfigBinder.class);
    private List<ConfigBindingFactory<?>> bindingFactories = new ArrayList();

    public ConfigBinder() {
        this.bindingFactories.add(new ForcedLeafBindingFactory());
        this.bindingFactories.add(new LeafBindingFactory());
        this.bindingFactories.add(new ArrayBindingFactory());
        this.bindingFactories.add(new CollectionBindingFactory());
        this.bindingFactories.add(new MapBindingFactory());
        this.bindingFactories.add(new InterfaceBindingFactory());
    }

    public ConfigBinding<?> toRootConfigBinding(Type forType, BindingContext bindingContext) {
        return this.toConfigBinding(BindingType.newBindingType(forType, bindingContext));
    }

    public ConfigBinding<?> toConfigBinding(BindingType bindingType) {
        return this.bindingFactories.stream().map(configDescriptionFactory -> configDescriptionFactory.maybeCreate(bindingType, this)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> {
            LOGGER.info("Type {} could not be handled by any of the configured bindingFactories: {}", bindingType, this.bindingFactories);
            return new ConfijDefinitionException("Unable to bind to type '{}'. This type cannot be handled by any of the binding-factories. Either replace this type definition or add a custom {} to {}. Most commonly you want to bind a leaf-type (and not a container for properties), where it is most simple to register a ValueMapping in the ConfijBuilder or add a custom @ValueMapping annotation to this type.", bindingType.getResolvedType(), ConfigBindingFactory.class.getName(), ConfigBinder.class);
        });
    }

    @Generated
    public String toString() {
        return "ConfigBinder(bindingFactories=" + this.getBindingFactories() + ")";
    }

    @Generated
    public List<ConfigBindingFactory<?>> getBindingFactories() {
        return this.bindingFactories;
    }
}

