/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.any.ConfijAnyResource;
import ch.kk7.confij.source.resource.ConfijResource;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.template.ValueResolver;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class FileResource
implements ConfijResource {
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(FileResource.class);
    private static Pattern globPattern = Pattern.compile("(^|.*[^\\\\])([*?]|\\[.+]|\\{.+}).*");
    @NonNull
    private final String fileTemplate;
    @NonNull
    private final String charsetTemplate;
    private final int maxFileMatches;
    private final int maxFilesTraversed;

    public FileResource(String fileTemplate) {
        this(fileTemplate, ConfijResource.Defaults.CHARSET_NAME, 50, 10000);
    }

    public static FileResource ofFile(String file) {
        return new FileResource(file);
    }

    public static FileResource ofFile(File file) {
        return FileResource.ofFile(file.toString());
    }

    public static FileResource ofPath(Path file) {
        return FileResource.ofFile(file.toFile());
    }

    protected static PathAndMatcher extractGlob(String path) {
        String[] parts = path.split("/", -1);
        int globAt = -1;
        int maxDepth = -1;
        for (int i = 0; i < parts.length; ++i) {
            if (globAt == -1 && globPattern.matcher(parts[i]).matches()) {
                globAt = i;
                maxDepth = 0;
            }
            if (globAt == -1) continue;
            if (parts[i].contains("**")) {
                maxDepth = Integer.MAX_VALUE;
                break;
            }
            ++maxDepth;
        }
        if (globAt == -1) {
            return new PathAndMatcher(Paths.get(path, new String[0]), null, path, -1);
        }
        String beforeGlob = Stream.of(parts).limit(globAt).collect(Collectors.joining("/"));
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + path);
        return new PathAndMatcher(Paths.get(beforeGlob, new String[0]), pathMatcher, path, maxDepth);
    }

    protected List<Path> getFilesMatching(final @NonNull PathAndMatcher query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        final ArrayList<Path> matchingFiles = new ArrayList<Path>();
        final int[] fileCounter = new int[]{0};
        Files.walkFileTree(query.getBasePath(), EnumSet.noneOf(FileVisitOption.class), query.getMaxDepth(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (query.getPathMatcher().matches(file)) {
                    if (matchingFiles.size() >= FileResource.this.maxFileMatches) {
                        throw new ConfijSourceFetchingException("found too many files (>={}) matching glob expression. your expression '{}' seems too lax. if this was intentional, try to increase '{}'", FileResource.this.maxFileMatches, query.getOriginalPath(), "maxFileMatches");
                    }
                    fileCounter[0] = fileCounter[0] + 1;
                    if (fileCounter[0] >= FileResource.this.maxFilesTraversed) {
                        throw new ConfijSourceFetchingException("traversed too many files (>={}) in query of a maching glob expression. your expression '{}' seems too expensive. if this was intentional, try to increase '{}'", fileCounter[0], query.getOriginalPath(), "maxFilesTraversed");
                    }
                    matchingFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        LOGGER.debug("traversed {} files to find {} files matching glob '{}'", fileCounter[0], matchingFiles.size(), query.getOriginalPath());
        matchingFiles.sort(Comparator.comparingInt(Path::getNameCount).thenComparing(Comparator.naturalOrder()));
        return matchingFiles;
    }

    @Override
    public Stream<ConfijResource.ResourceContent> read(ValueResolver.StringResolver resolver) {
        String fileStr = Util.getSchemeSpecificPart(resolver.resolve(this.fileTemplate));
        String charsetStr = resolver.resolve(this.charsetTemplate);
        Charset charset = Charset.forName(charsetStr);
        PathAndMatcher query = FileResource.extractGlob(fileStr);
        List<Path> matchingFiles = query.getPathMatcher() == null ? Collections.singletonList(query.getBasePath()) : this.getFilesMatching(query);
        return matchingFiles.stream().map(file -> new ConfijResource.ResourceContent(this.fileToStr((Path)file, charset), file.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String fileToStr(Path path, Charset charset) {
        try (FileInputStream fis = new FileInputStream(path.toFile());){
            Scanner s = new Scanner((InputStream)fis, charset.name()).useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        catch (FileNotFoundException e) {
            throw new ConfijSourceException("failed to read from file '{}' because it doesn't exist", path.toAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new ConfijSourceException("failed to read from file '{}'", path.toAbsolutePath(), e);
        }
    }

    @NonNull
    @Generated
    public String getFileTemplate() {
        return this.fileTemplate;
    }

    @NonNull
    @Generated
    public String getCharsetTemplate() {
        return this.charsetTemplate;
    }

    @Generated
    public int getMaxFileMatches() {
        return this.maxFileMatches;
    }

    @Generated
    public int getMaxFilesTraversed() {
        return this.maxFilesTraversed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileResource)) {
            return false;
        }
        FileResource other = (FileResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxFileMatches() != other.getMaxFileMatches()) {
            return false;
        }
        if (this.getMaxFilesTraversed() != other.getMaxFilesTraversed()) {
            return false;
        }
        String this$fileTemplate = this.getFileTemplate();
        String other$fileTemplate = other.getFileTemplate();
        if (this$fileTemplate == null ? other$fileTemplate != null : !this$fileTemplate.equals(other$fileTemplate)) {
            return false;
        }
        String this$charsetTemplate = this.getCharsetTemplate();
        String other$charsetTemplate = other.getCharsetTemplate();
        return !(this$charsetTemplate == null ? other$charsetTemplate != null : !this$charsetTemplate.equals(other$charsetTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxFileMatches();
        result = result * 59 + this.getMaxFilesTraversed();
        String $fileTemplate = this.getFileTemplate();
        result = result * 59 + ($fileTemplate == null ? 43 : $fileTemplate.hashCode());
        String $charsetTemplate = this.getCharsetTemplate();
        result = result * 59 + ($charsetTemplate == null ? 43 : $charsetTemplate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileResource(fileTemplate=" + this.getFileTemplate() + ", charsetTemplate=" + this.getCharsetTemplate() + ", maxFileMatches=" + this.getMaxFileMatches() + ", maxFilesTraversed=" + this.getMaxFilesTraversed() + ")";
    }

    @Generated
    public FileResource withFileTemplate(@NonNull String fileTemplate) {
        if (fileTemplate == null) {
            throw new NullPointerException("fileTemplate is marked non-null but is null");
        }
        return this.fileTemplate == fileTemplate ? this : new FileResource(fileTemplate, this.charsetTemplate, this.maxFileMatches, this.maxFilesTraversed);
    }

    @Generated
    public FileResource withCharsetTemplate(@NonNull String charsetTemplate) {
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        return this.charsetTemplate == charsetTemplate ? this : new FileResource(this.fileTemplate, charsetTemplate, this.maxFileMatches, this.maxFilesTraversed);
    }

    @Generated
    public FileResource withMaxFileMatches(int maxFileMatches) {
        return this.maxFileMatches == maxFileMatches ? this : new FileResource(this.fileTemplate, this.charsetTemplate, maxFileMatches, this.maxFilesTraversed);
    }

    @Generated
    public FileResource withMaxFilesTraversed(int maxFilesTraversed) {
        return this.maxFilesTraversed == maxFilesTraversed ? this : new FileResource(this.fileTemplate, this.charsetTemplate, this.maxFileMatches, maxFilesTraversed);
    }

    @Generated
    public FileResource(@NonNull String fileTemplate, @NonNull String charsetTemplate, int maxFileMatches, int maxFilesTraversed) {
        if (fileTemplate == null) {
            throw new NullPointerException("fileTemplate is marked non-null but is null");
        }
        if (charsetTemplate == null) {
            throw new NullPointerException("charsetTemplate is marked non-null but is null");
        }
        this.fileTemplate = fileTemplate;
        this.charsetTemplate = charsetTemplate;
        this.maxFileMatches = maxFileMatches;
        this.maxFilesTraversed = maxFilesTraversed;
    }

    @Generated
    public static final class Fields {
        public static final String fileTemplate = "fileTemplate";
        public static final String charsetTemplate = "charsetTemplate";
        public static final String maxFileMatches = "maxFileMatches";
        public static final String maxFilesTraversed = "maxFilesTraversed";

        @Generated
        private Fields() {
        }
    }

    @AutoService(value={ConfijAnyResource.class})
    public static class AnyFileResource
    implements ConfijAnyResource {
        public static final String SCHEME = "file";

        public Optional<FileResource> maybeHandle(String pathTemplate) {
            if (Util.getScheme(pathTemplate).orElse(SCHEME).equals(SCHEME)) {
                return Optional.of(FileResource.ofFile(pathTemplate));
            }
            return Optional.empty();
        }

        @Generated
        public String toString() {
            return "FileResource.AnyFileResource()";
        }
    }

    protected static class PathAndMatcher {
        private final Path basePath;
        private final PathMatcher pathMatcher;
        private final String originalPath;
        private final int maxDepth;

        @Generated
        public PathAndMatcher(Path basePath, PathMatcher pathMatcher, String originalPath, int maxDepth) {
            this.basePath = basePath;
            this.pathMatcher = pathMatcher;
            this.originalPath = originalPath;
            this.maxDepth = maxDepth;
        }

        @Generated
        public Path getBasePath() {
            return this.basePath;
        }

        @Generated
        public PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        @Generated
        public String getOriginalPath() {
            return this.originalPath;
        }

        @Generated
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathAndMatcher)) {
                return false;
            }
            PathAndMatcher other = (PathAndMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxDepth() != other.getMaxDepth()) {
                return false;
            }
            Path this$basePath = this.getBasePath();
            Path other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !((Object)this$basePath).equals(other$basePath)) {
                return false;
            }
            PathMatcher this$pathMatcher = this.getPathMatcher();
            PathMatcher other$pathMatcher = other.getPathMatcher();
            if (this$pathMatcher == null ? other$pathMatcher != null : !this$pathMatcher.equals(other$pathMatcher)) {
                return false;
            }
            String this$originalPath = this.getOriginalPath();
            String other$originalPath = other.getOriginalPath();
            return !(this$originalPath == null ? other$originalPath != null : !this$originalPath.equals(other$originalPath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PathAndMatcher;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxDepth();
            Path $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : ((Object)$basePath).hashCode());
            PathMatcher $pathMatcher = this.getPathMatcher();
            result = result * 59 + ($pathMatcher == null ? 43 : $pathMatcher.hashCode());
            String $originalPath = this.getOriginalPath();
            result = result * 59 + ($originalPath == null ? 43 : $originalPath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FileResource.PathAndMatcher(basePath=" + this.getBasePath() + ", pathMatcher=" + this.getPathMatcher() + ", originalPath=" + this.getOriginalPath() + ", maxDepth=" + this.getMaxDepth() + ")";
        }
    }
}

