/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.any;

import ch.kk7.confij.common.ServiceLoaderUtil;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.any.ConfijAnySource;
import ch.kk7.confij.tree.ConfijNode;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class AnySourceImpl
implements ConfijSource {
    private static List<ConfijAnySource> sourceBuilders = ServiceLoaderUtil.requireInstancesOf(ConfijAnySource.class);
    @NonNull
    private final String pathTemplate;

    @Override
    public void override(ConfijNode rootNode) {
        String path = rootNode.resolve(this.pathTemplate);
        ConfijSource confijSource = sourceBuilders.stream().map(sourceBulder -> sourceBulder.fromURI(path)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> {
            String addon = this.pathTemplate.equals(path) ? "" : " (resolved from '" + this.pathTemplate + "')";
            return new ConfijSourceException("The {} was unable to find a {} which can handle '{}'{}", this, ConfijAnySource.class.getSimpleName(), path, addon);
        });
        try {
            confijSource.override(rootNode);
        }
        catch (ConfijSourceException e) {
            throw new ConfijSourceException("Failed reading source from path `{}` using {} (either fix the content of this source or write a new ServiceLoader implementing {}): {}", path, this, ConfijSource.class.getSimpleName(), e.getMessage(), e);
        }
    }

    @Generated
    public AnySourceImpl(@NonNull String pathTemplate) {
        if (pathTemplate == null) {
            throw new NullPointerException("pathTemplate is marked non-null but is null");
        }
        this.pathTemplate = pathTemplate;
    }

    @NonNull
    @Generated
    public String getPathTemplate() {
        return this.pathTemplate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnySourceImpl)) {
            return false;
        }
        AnySourceImpl other = (AnySourceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pathTemplate = this.getPathTemplate();
        String other$pathTemplate = other.getPathTemplate();
        return !(this$pathTemplate == null ? other$pathTemplate != null : !this$pathTemplate.equals(other$pathTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnySourceImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pathTemplate = this.getPathTemplate();
        result = result * 59 + ($pathTemplate == null ? 43 : $pathTemplate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnySourceImpl(pathTemplate=" + this.getPathTemplate() + ")";
    }
}

