/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.any.ConfijAnyResource;
import ch.kk7.confij.source.resource.ConfijResource;
import ch.kk7.confij.template.ValueResolver;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitResource
implements ConfijResource {
    protected static final String TEMP_DIR_PREFIX = "confij-";
    protected static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(GitResource.class);
    private static final String FETCH_REFSPEC = "+refs/*:refs/*";
    private final GitSettings gitSettings;

    public Stream<ConfijResource.ResourceContent> read(ValueResolver.StringResolver resolver) {
        GitSettings settings = this.gitSettings;
        if (this.gitSettings.getLocalDir() == null) {
            settings = settings.withLocalDir(GitResource.getFileForSeed(settings.getRemoteUrl()));
        }
        Git git = this.gitCloneOrFetch(settings);
        return Stream.of(this.readFile(git, settings));
    }

    public static File getFileForSeed(@NonNull String seed) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        String name = UUID.nameUUIDFromBytes(seed.getBytes()).toString().replace("-", "");
        return TEMP_DIR.resolve(TEMP_DIR_PREFIX + name + ".git").toFile();
    }

    protected Git gitCloneOrFetch(GitSettings settings) {
        Git git = null;
        try {
            git = Git.open((File)settings.getLocalDir());
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
        }
        catch (IOException e) {
            throw new ConfijSourceException("failed to check git repository with {}", new Object[]{settings, e});
        }
        try {
            if (git == null) {
                return this.gitClone(settings);
            }
            return this.gitFetch(git, settings);
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            throw new ConfijSourceException("failed to open and fetch git repository with {}", new Object[]{settings, e});
        }
    }

    protected Git gitFetch(Git git, GitSettings settings) throws GitAPIException {
        LOGGER.debug("git fetch: {}", new Object[]{settings});
        FetchResult fetchResult = ((FetchCommand)((FetchCommand)((FetchCommand)git.fetch().setRemote(settings.getRemoteUrl()).setRefSpecs(new String[]{FETCH_REFSPEC}).setRemoveDeletedRefs(true).setCheckFetchedObjects(true).setCredentialsProvider(settings.getCredentialsProvider())).setTimeout(settings.getTimeoutInSeconds())).setTransportConfigCallback(settings.getTransportConfigCallback())).call();
        LOGGER.info("git fetch result: {}", new Object[]{fetchResult.getTrackingRefUpdates()});
        return git;
    }

    protected Git gitClone(GitSettings settings) throws GitAPIException, IOException {
        Git git = this.gitInit(settings);
        git = this.gitFetch(git, settings);
        git.log().call();
        return git;
    }

    protected Git gitInit(GitSettings settings) throws GitAPIException, IOException {
        LOGGER.debug("initializing a new git repository: {}", new Object[]{settings});
        Git git = Git.init().setDirectory(settings.getLocalDir()).setBare(true).call();
        StoredConfig config = git.getRepository().getConfig();
        config.setString("remote", "origin", "url", settings.getRemoteUrl());
        config.setString("remote", "origin", "fetch", FETCH_REFSPEC);
        Optional.ofNullable(settings.getGitInitHook()).ifPresent(x -> x.accept(git));
        config.save();
        return git;
    }

    protected RevCommit getRevCommit(Git git, GitSettings settings) {
        ObjectId objectId;
        Repository repository = git.getRepository();
        try {
            objectId = repository.resolve(settings.getGitRevision());
        }
        catch (Exception e) {
            throw new ConfijSourceException("failed to git resove an objectId from rev {} ({})", new Object[]{settings.getGitRevision(), settings, e});
        }
        if (objectId == null) {
            throw new ConfijSourceException("unable to git resove revision {} ({})", new Object[]{settings.getGitRevision(), settings});
        }
        try {
            return repository.parseCommit((AnyObjectId)objectId);
        }
        catch (IOException e) {
            throw new ConfijSourceException("git failed to find commit for objectId {} ({})", new Object[]{objectId, settings, e});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConfijResource.ResourceContent readFile(Git git, GitSettings settings) {
        RevCommit revCommit = this.getRevCommit(git, settings);
        try (TreeWalk walk = TreeWalk.forPath((Repository)git.getRepository(), (String)settings.getConfigFile(), (RevTree)revCommit.getTree());){
            if (walk != null) {
                ObjectId objectId = walk.getObjectId(0);
                byte[] bytes = git.getRepository().open((AnyObjectId)objectId).getBytes();
                String content = new String(bytes, ConfijResource.Defaults.CHARSET_NAME);
                String filePathAndSha = settings.getConfigFile() + "#" + objectId.getName();
                ConfijResource.ResourceContent resourceContent = new ConfijResource.ResourceContent(content, filePathAndSha);
                return resourceContent;
            }
            throw new ConfijSourceException("File {} not found within git repo at commit {}", new Object[]{settings.getConfigFile(), revCommit});
        }
        catch (IOException e) {
            throw new ConfijSourceException("failed to read file {} within git repo at commit {}", new Object[]{settings.getConfigFile(), revCommit, e});
        }
    }

    @Generated
    public GitResource(GitSettings gitSettings) {
        this.gitSettings = gitSettings;
    }

    @Generated
    public GitSettings getGitSettings() {
        return this.gitSettings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitResource)) {
            return false;
        }
        GitResource other = (GitResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GitSettings this$gitSettings = this.getGitSettings();
        GitSettings other$gitSettings = other.getGitSettings();
        return !(this$gitSettings == null ? other$gitSettings != null : !((Object)this$gitSettings).equals(other$gitSettings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitSettings $gitSettings = this.getGitSettings();
        result = result * 59 + ($gitSettings == null ? 43 : ((Object)$gitSettings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitResource(gitSettings=" + this.getGitSettings() + ")";
    }

    public static class GitSettings {
        @NonNull
        private final String remoteUrl;
        @NonNull
        private final String configFile;
        @NonNull
        private final String gitRevision;
        private final File localDir;
        private final CredentialsProvider credentialsProvider;
        private final int timeoutInSeconds;
        private final TransportConfigCallback transportConfigCallback;
        private final Consumer<Git> gitInitHook;

        @Generated
        private static String $default$gitRevision() {
            return "HEAD";
        }

        @Generated
        private static int $default$timeoutInSeconds() {
            return 60;
        }

        @Generated
        GitSettings(@NonNull String remoteUrl, @NonNull String configFile, @NonNull String gitRevision, File localDir, CredentialsProvider credentialsProvider, int timeoutInSeconds, TransportConfigCallback transportConfigCallback, Consumer<Git> gitInitHook) {
            if (remoteUrl == null) {
                throw new NullPointerException("remoteUrl is marked non-null but is null");
            }
            if (configFile == null) {
                throw new NullPointerException("configFile is marked non-null but is null");
            }
            if (gitRevision == null) {
                throw new NullPointerException("gitRevision is marked non-null but is null");
            }
            this.remoteUrl = remoteUrl;
            this.configFile = configFile;
            this.gitRevision = gitRevision;
            this.localDir = localDir;
            this.credentialsProvider = credentialsProvider;
            this.timeoutInSeconds = timeoutInSeconds;
            this.transportConfigCallback = transportConfigCallback;
            this.gitInitHook = gitInitHook;
        }

        @Generated
        public static GitSettingsBuilder builder() {
            return new GitSettingsBuilder();
        }

        @NonNull
        @Generated
        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        @NonNull
        @Generated
        public String getConfigFile() {
            return this.configFile;
        }

        @NonNull
        @Generated
        public String getGitRevision() {
            return this.gitRevision;
        }

        @Generated
        public File getLocalDir() {
            return this.localDir;
        }

        @Generated
        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        @Generated
        public int getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Generated
        public TransportConfigCallback getTransportConfigCallback() {
            return this.transportConfigCallback;
        }

        @Generated
        public Consumer<Git> getGitInitHook() {
            return this.gitInitHook;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitSettings)) {
                return false;
            }
            GitSettings other = (GitSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimeoutInSeconds() != other.getTimeoutInSeconds()) {
                return false;
            }
            String this$remoteUrl = this.getRemoteUrl();
            String other$remoteUrl = other.getRemoteUrl();
            if (this$remoteUrl == null ? other$remoteUrl != null : !this$remoteUrl.equals(other$remoteUrl)) {
                return false;
            }
            String this$configFile = this.getConfigFile();
            String other$configFile = other.getConfigFile();
            if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
                return false;
            }
            String this$gitRevision = this.getGitRevision();
            String other$gitRevision = other.getGitRevision();
            if (this$gitRevision == null ? other$gitRevision != null : !this$gitRevision.equals(other$gitRevision)) {
                return false;
            }
            File this$localDir = this.getLocalDir();
            File other$localDir = other.getLocalDir();
            if (this$localDir == null ? other$localDir != null : !((Object)this$localDir).equals(other$localDir)) {
                return false;
            }
            CredentialsProvider this$credentialsProvider = this.getCredentialsProvider();
            CredentialsProvider other$credentialsProvider = other.getCredentialsProvider();
            if (this$credentialsProvider == null ? other$credentialsProvider != null : !this$credentialsProvider.equals(other$credentialsProvider)) {
                return false;
            }
            TransportConfigCallback this$transportConfigCallback = this.getTransportConfigCallback();
            TransportConfigCallback other$transportConfigCallback = other.getTransportConfigCallback();
            if (this$transportConfigCallback == null ? other$transportConfigCallback != null : !this$transportConfigCallback.equals(other$transportConfigCallback)) {
                return false;
            }
            Consumer<Git> this$gitInitHook = this.getGitInitHook();
            Consumer<Git> other$gitInitHook = other.getGitInitHook();
            return !(this$gitInitHook == null ? other$gitInitHook != null : !this$gitInitHook.equals(other$gitInitHook));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GitSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTimeoutInSeconds();
            String $remoteUrl = this.getRemoteUrl();
            result = result * 59 + ($remoteUrl == null ? 43 : $remoteUrl.hashCode());
            String $configFile = this.getConfigFile();
            result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
            String $gitRevision = this.getGitRevision();
            result = result * 59 + ($gitRevision == null ? 43 : $gitRevision.hashCode());
            File $localDir = this.getLocalDir();
            result = result * 59 + ($localDir == null ? 43 : ((Object)$localDir).hashCode());
            CredentialsProvider $credentialsProvider = this.getCredentialsProvider();
            result = result * 59 + ($credentialsProvider == null ? 43 : $credentialsProvider.hashCode());
            TransportConfigCallback $transportConfigCallback = this.getTransportConfigCallback();
            result = result * 59 + ($transportConfigCallback == null ? 43 : $transportConfigCallback.hashCode());
            Consumer<Git> $gitInitHook = this.getGitInitHook();
            result = result * 59 + ($gitInitHook == null ? 43 : $gitInitHook.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GitResource.GitSettings(remoteUrl=" + this.getRemoteUrl() + ", configFile=" + this.getConfigFile() + ", gitRevision=" + this.getGitRevision() + ", localDir=" + this.getLocalDir() + ", credentialsProvider=" + this.getCredentialsProvider() + ", timeoutInSeconds=" + this.getTimeoutInSeconds() + ", transportConfigCallback=" + this.getTransportConfigCallback() + ", gitInitHook=" + this.getGitInitHook() + ")";
        }

        @Generated
        public GitSettings withRemoteUrl(@NonNull String remoteUrl) {
            if (remoteUrl == null) {
                throw new NullPointerException("remoteUrl is marked non-null but is null");
            }
            return this.remoteUrl == remoteUrl ? this : new GitSettings(remoteUrl, this.configFile, this.gitRevision, this.localDir, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withConfigFile(@NonNull String configFile) {
            if (configFile == null) {
                throw new NullPointerException("configFile is marked non-null but is null");
            }
            return this.configFile == configFile ? this : new GitSettings(this.remoteUrl, configFile, this.gitRevision, this.localDir, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withGitRevision(@NonNull String gitRevision) {
            if (gitRevision == null) {
                throw new NullPointerException("gitRevision is marked non-null but is null");
            }
            return this.gitRevision == gitRevision ? this : new GitSettings(this.remoteUrl, this.configFile, gitRevision, this.localDir, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withLocalDir(File localDir) {
            return this.localDir == localDir ? this : new GitSettings(this.remoteUrl, this.configFile, this.gitRevision, localDir, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withCredentialsProvider(CredentialsProvider credentialsProvider) {
            return this.credentialsProvider == credentialsProvider ? this : new GitSettings(this.remoteUrl, this.configFile, this.gitRevision, this.localDir, credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withTimeoutInSeconds(int timeoutInSeconds) {
            return this.timeoutInSeconds == timeoutInSeconds ? this : new GitSettings(this.remoteUrl, this.configFile, this.gitRevision, this.localDir, this.credentialsProvider, timeoutInSeconds, this.transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
            return this.transportConfigCallback == transportConfigCallback ? this : new GitSettings(this.remoteUrl, this.configFile, this.gitRevision, this.localDir, this.credentialsProvider, this.timeoutInSeconds, transportConfigCallback, this.gitInitHook);
        }

        @Generated
        public GitSettings withGitInitHook(Consumer<Git> gitInitHook) {
            return this.gitInitHook == gitInitHook ? this : new GitSettings(this.remoteUrl, this.configFile, this.gitRevision, this.localDir, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback, gitInitHook);
        }

        public static class GitSettingsBuilder {
            @Generated
            private String remoteUrl;
            @Generated
            private String configFile;
            @Generated
            private boolean gitRevision$set;
            @Generated
            private String gitRevision$value;
            @Generated
            private File localDir;
            @Generated
            private CredentialsProvider credentialsProvider;
            @Generated
            private boolean timeoutInSeconds$set;
            @Generated
            private int timeoutInSeconds$value;
            @Generated
            private TransportConfigCallback transportConfigCallback;
            @Generated
            private Consumer<Git> gitInitHook;

            GitSettingsBuilder usernamePasswordCredential(String username, String password) {
                return this.credentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password));
            }

            @Generated
            GitSettingsBuilder() {
            }

            @Generated
            public GitSettingsBuilder remoteUrl(@NonNull String remoteUrl) {
                if (remoteUrl == null) {
                    throw new NullPointerException("remoteUrl is marked non-null but is null");
                }
                this.remoteUrl = remoteUrl;
                return this;
            }

            @Generated
            public GitSettingsBuilder configFile(@NonNull String configFile) {
                if (configFile == null) {
                    throw new NullPointerException("configFile is marked non-null but is null");
                }
                this.configFile = configFile;
                return this;
            }

            @Generated
            public GitSettingsBuilder gitRevision(@NonNull String gitRevision) {
                if (gitRevision == null) {
                    throw new NullPointerException("gitRevision is marked non-null but is null");
                }
                this.gitRevision$value = gitRevision;
                this.gitRevision$set = true;
                return this;
            }

            @Generated
            public GitSettingsBuilder localDir(File localDir) {
                this.localDir = localDir;
                return this;
            }

            @Generated
            public GitSettingsBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
                this.credentialsProvider = credentialsProvider;
                return this;
            }

            @Generated
            public GitSettingsBuilder timeoutInSeconds(int timeoutInSeconds) {
                this.timeoutInSeconds$value = timeoutInSeconds;
                this.timeoutInSeconds$set = true;
                return this;
            }

            @Generated
            public GitSettingsBuilder transportConfigCallback(TransportConfigCallback transportConfigCallback) {
                this.transportConfigCallback = transportConfigCallback;
                return this;
            }

            @Generated
            public GitSettingsBuilder gitInitHook(Consumer<Git> gitInitHook) {
                this.gitInitHook = gitInitHook;
                return this;
            }

            @Generated
            public GitSettings build() {
                String gitRevision$value = this.gitRevision$value;
                if (!this.gitRevision$set) {
                    gitRevision$value = GitSettings.$default$gitRevision();
                }
                int timeoutInSeconds$value = this.timeoutInSeconds$value;
                if (!this.timeoutInSeconds$set) {
                    timeoutInSeconds$value = GitSettings.$default$timeoutInSeconds();
                }
                return new GitSettings(this.remoteUrl, this.configFile, gitRevision$value, this.localDir, this.credentialsProvider, timeoutInSeconds$value, this.transportConfigCallback, this.gitInitHook);
            }

            @Generated
            public String toString() {
                return "GitResource.GitSettings.GitSettingsBuilder(remoteUrl=" + this.remoteUrl + ", configFile=" + this.configFile + ", gitRevision$value=" + this.gitRevision$value + ", localDir=" + this.localDir + ", credentialsProvider=" + this.credentialsProvider + ", timeoutInSeconds$value=" + this.timeoutInSeconds$value + ", transportConfigCallback=" + this.transportConfigCallback + ", gitInitHook=" + this.gitInitHook + ")";
            }
        }
    }

    @AutoService(value={ConfijAnyResource.class})
    public static class GitAnyResource
    implements ConfijAnyResource {
        private static final String SCHEME = "git";
        private static final Pattern URL_FILE_SPLITTER = Pattern.compile("^(?<url>.+(?:\\.git/?|[^:]/))/(?<file>.+)$");

        public Optional<GitResource> maybeHandle(String path) {
            if (Util.getScheme((String)path).filter(SCHEME::equals).isPresent()) {
                GitSettings settings = this.uriToGitSettings(path);
                return Optional.of(new GitResource(settings));
            }
            return Optional.empty();
        }

        protected GitSettings uriToGitSettings(String pathTemplate) {
            String urlAndFile = Util.getSchemeSpecificPart((String)pathTemplate);
            Matcher m = URL_FILE_SPLITTER.matcher(urlAndFile);
            if (!m.matches()) {
                throw new ConfijSourceException("expected the git source to have a format like 'git:https://example.com/repo.git/path/to/file.yaml' (repo ending in '.git') or 'git:/var/opt/dir//path/to/file.yaml' (repo separated from file by double slash). However the provided '{}' does not match: {}", new Object[]{urlAndFile, URL_FILE_SPLITTER.pattern()});
            }
            String remoteUrl = m.group("url");
            String configFile = m.group("file");
            return GitSettings.builder().gitRevision(Util.getFragment((String)pathTemplate).filter(Util.not(String::isEmpty)).orElse("HEAD")).remoteUrl(remoteUrl).configFile(configFile).credentialsProvider(this.getCredentialsProvider(remoteUrl)).build();
        }

        protected CredentialsProvider getCredentialsProvider(String remoteUrl) {
            URIish urIish;
            try {
                urIish = new URIish(remoteUrl);
            }
            catch (URISyntaxException e) {
                throw new ConfijSourceException("not URIish: " + remoteUrl, new Object[]{e});
            }
            if (urIish.getUser() != null) {
                return new UsernamePasswordCredentialsProvider(urIish.getUser(), Optional.ofNullable(urIish.getPass()).orElse(""));
            }
            return null;
        }

        @Generated
        public String toString() {
            return "GitResource.GitAnyResource()";
        }
    }
}

