/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.any.ConfijAnyFormat;
import ch.kk7.confij.source.format.ConfijFormat;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import com.google.auto.service.AutoService;
import com.typesafe.config.ConfigFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class HoconFormat
implements ConfijFormat {
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(HoconFormat.class);

    public void override(ConfijNode rootNode, String configAsStr) {
        Object simpleRoot = this.parse(configAsStr);
        ConfijNode newConfig = ConfijNode.newRootFor((NodeDefinition)rootNode.getConfig()).initializeFromMap(simpleRoot);
        rootNode.overrideWith(newConfig);
    }

    protected Object parse(String configAsStr) {
        Map unwrapped;
        try {
            unwrapped = ConfigFactory.parseString((String)configAsStr).resolve().root().unwrapped();
        }
        catch (Exception e) {
            LOGGER.debug("parsing HOCON failed for string:\n{}", new Object[]{configAsStr});
            throw new ConfijSourceException("invalid HOCON format", new Object[]{e});
        }
        return this.simplify(unwrapped);
    }

    protected Object simplify(Object hocon) {
        if (hocon == null) {
            return null;
        }
        if (hocon instanceof String) {
            return hocon;
        }
        if (hocon instanceof Number || hocon instanceof Boolean) {
            return String.valueOf(hocon);
        }
        if (hocon instanceof Map) {
            return this.simplifyMap((Map)hocon);
        }
        if (hocon instanceof List) {
            return this.simplifyList((List)hocon);
        }
        throw new IllegalStateException("encountered invalid type while simplyfying HOCON");
    }

    protected Map<String, Object> simplifyMap(Map<String, Object> hocon) {
        HashMap<String, Object> result = new HashMap<String, Object>(hocon.size());
        hocon.forEach((k, v) -> result.put((String)k, this.simplify(v)));
        return result;
    }

    protected Map<String, Object> simplifyList(List<Object> hocon) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(hocon.size());
        ListIterator<Object> iterator = hocon.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Object simpleValue = this.simplify(iterator.next());
            result.put(String.valueOf(index), simpleValue);
        }
        return result;
    }

    @Generated
    public HoconFormat() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof HoconFormat;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "HoconFormat()";
    }

    @AutoService(value={ConfijAnyFormat.class})
    public static class HoconAnyFormat
    implements ConfijAnyFormat {
        public Optional<ConfijFormat> maybeHandle(String pathTemplate) {
            if (Util.getSchemeSpecificPart((String)pathTemplate).matches("(?s).+\\.(json|hocon|conf)$")) {
                return Optional.of(new HoconFormat());
            }
            return Optional.empty();
        }

        @Generated
        public String toString() {
            return "HoconFormat.HoconAnyFormat()";
        }
    }
}

