/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.any.ConfijAnyFormat;
import ch.kk7.confij.source.format.ConfijFormat;
import ch.kk7.confij.source.format.ConfijSourceFormatException;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import com.google.auto.service.AutoService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseError;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public final class TomlFormat
implements ConfijFormat {
    public void override(ConfijNode rootNode, String content) {
        TomlParseResult result;
        try {
            result = Toml.parse((String)content);
            if (result.hasErrors()) {
                String errors = result.errors().stream().map(TomlParseError::toString).collect(Collectors.joining("\n"));
                throw ConfijSourceFormatException.invalidFormat((String)"TOML", (String)errors, (Object[])new Object[0]);
            }
        }
        catch (ConfijSourceFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfijSourceFormatException.invalidFormat((String)"TOML", (String)"cannot load from string", (Object[])new Object[]{e});
        }
        Map<String, Object> resultMap = this.transformTomlTable((TomlTable)result);
        ConfijNode newConfig = ConfijNode.newRootFor((NodeDefinition)rootNode.getConfig()).initializeFromMap(resultMap);
        rootNode.overrideWith(newConfig);
    }

    private Object transform(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof LocalDate || object instanceof LocalTime || object instanceof LocalDateTime || object instanceof OffsetDateTime) {
            return object.toString();
        }
        if (object instanceof TomlTable) {
            return this.transformTomlTable((TomlTable)object);
        }
        if (object instanceof TomlArray) {
            return this.transformTomlArray((TomlArray)object);
        }
        throw new IllegalArgumentException("This is a invalid type " + object.getClass() + " while parsing TOML.");
    }

    private Map<String, Object> transformTomlTable(TomlTable table) {
        Set keys = table.keySet();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(keys.size());
        keys.forEach(key -> {
            Object object = table.get(key);
            result.put((String)key, this.transform(object));
        });
        return result;
    }

    private Map<String, Object> transformTomlArray(TomlArray array) {
        int size = array.size();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object item = array.get(i);
            result.put(String.valueOf(i), this.transform(item));
        }
        return result;
    }

    @Generated
    public TomlFormat() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TomlFormat;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "TomlFormat()";
    }

    @AutoService(value={ConfijAnyFormat.class})
    public static class TomlAnyFormat
    implements ConfijAnyFormat {
        public Optional<ConfijFormat> maybeHandle(String pathTemplate) {
            if (Util.getSchemeSpecificPart((String)pathTemplate).matches("(?i).+\\.toml$")) {
                return Optional.of(new TomlFormat());
            }
            return Optional.empty();
        }

        @Generated
        public String toString() {
            return "TomlFormat.TomlAnyFormat()";
        }
    }
}

