/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.source.any.ConfijAnyFormat;
import ch.kk7.confij.source.format.ConfijFormat;
import ch.kk7.confij.source.format.ConfijSourceFormatException;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import com.google.auto.service.AutoService;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;

public final class YamlFormat
implements ConfijFormat {
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructorWithDateTime());

    public void override(ConfijNode rootNode, String content) {
        Iterable yamlIterable;
        try {
            yamlIterable = this.yaml.loadAll(content);
        }
        catch (Exception e) {
            throw ConfijSourceFormatException.invalidFormat((String)"YAML", (String)"cannot load from string", (Object[])new Object[]{e});
        }
        yamlIterable.forEach(root -> {
            Object simpleRoot = this.simplify(root);
            ConfijNode newConfig = ConfijNode.newRootFor((NodeDefinition)rootNode.getConfig()).initializeFromMap(simpleRoot);
            rootNode.overrideWith(newConfig);
        });
    }

    protected Object simplify(Object yaml) {
        if (yaml == null) {
            return null;
        }
        if (yaml instanceof Map) {
            return this.simplifyMap((Map)yaml);
        }
        if (yaml instanceof List) {
            return this.simplifyList((List)yaml);
        }
        if (yaml instanceof OffsetDateTime) {
            return ((OffsetDateTime)yaml).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return String.valueOf(yaml);
    }

    @NonNull
    protected Map<String, Object> simplifyMap(@NonNull Map<Object, Object> yaml) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(yaml.size());
        yaml.forEach((k, v) -> {
            String keyStr = String.valueOf(k);
            if (result.containsKey(keyStr)) {
                throw new IllegalArgumentException("by stringifying map keys we got a key conflict with: " + keyStr);
            }
            result.put(keyStr, this.simplify(v));
        });
        return result;
    }

    @NonNull
    protected Map<String, Object> simplifyList(@NonNull List<Object> yaml) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(yaml.size());
        ListIterator<Object> iterator = yaml.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Object simpleValue = this.simplify(iterator.next());
            result.put(String.valueOf(index), simpleValue);
        }
        return result;
    }

    @Generated
    public YamlFormat() {
    }

    @Generated
    public Yaml getYaml() {
        return this.yaml;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlFormat)) {
            return false;
        }
        YamlFormat other = (YamlFormat)o;
        Yaml this$yaml = this.getYaml();
        Yaml other$yaml = other.getYaml();
        return !(this$yaml == null ? other$yaml != null : !this$yaml.equals(other$yaml));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Yaml $yaml = this.getYaml();
        result = result * 59 + ($yaml == null ? 43 : $yaml.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "YamlFormat(yaml=" + this.getYaml() + ")";
    }

    static class SafeConstructorWithDateTime
    extends SafeConstructor {
        public SafeConstructorWithDateTime() {
            this.yamlConstructors.put(Tag.TIMESTAMP, new ConstructYamlOffsetDateTime());
        }

        @Generated
        public String toString() {
            return "YamlFormat.SafeConstructorWithDateTime()";
        }

        static class ConstructYamlOffsetDateTime
        extends SafeConstructor.ConstructYamlTimestamp {
            ConstructYamlOffsetDateTime() {
            }

            public OffsetDateTime construct(Node node) {
                Date yamlDate = (Date)super.construct(node);
                return yamlDate.toInstant().atZone(this.getCalendar().getTimeZone().toZoneId()).toOffsetDateTime();
            }
        }
    }

    @AutoService(value={ConfijAnyFormat.class})
    public static class YamlAnyFormat
    implements ConfijAnyFormat {
        public Optional<ConfijFormat> maybeHandle(String pathTemplate) {
            if (Util.getSchemeSpecificPart((String)pathTemplate).matches("(?i).+\\.ya?ml$")) {
                return Optional.of(new YamlFormat());
            }
            return Optional.empty();
        }

        @Generated
        public String toString() {
            return "YamlFormat.YamlAnyFormat()";
        }
    }
}

