/*
 * Decompiled with CFR 0.152.
 */
package ch.liip.aem.request;

import ch.liip.aem.request.utils.PageUtils;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.personalization.UserPropertiesUtil;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.jcr.Session;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestObjects {
    protected Logger logger;
    private SlingHttpServletRequest slingHttpServletRequest;
    private SlingHttpServletResponse slingHttpServletResponse;
    private SlingScriptHelper slingScriptHelper;
    private LanguageManager languageManager;
    private Resource resource;
    private ResourceResolver resourceResolver;
    private PageManager pageManager;
    private Page currentPage;
    private Page wrappingPage;
    private Page languageRootPage;
    private UserProperties userProperties;
    private Boolean isAnonymous;

    public RequestObjects(PageContext pageContext) {
        this(TagUtil.getRequest((PageContext)pageContext), (SlingHttpServletResponse)pageContext.getResponse());
    }

    public RequestObjects(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.slingHttpServletRequest = request;
        this.slingHttpServletResponse = response;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public SlingScriptHelper getScriptHelper() {
        if (this.slingScriptHelper == null) {
            SlingBindings bindings = (SlingBindings)this.slingHttpServletRequest.getAttribute(SlingBindings.class.getName());
            this.slingScriptHelper = bindings.getSling();
        }
        return this.slingScriptHelper;
    }

    public LanguageManager getLanguageManager() {
        if (this.languageManager == null) {
            this.languageManager = this.getService(LanguageManager.class);
        }
        return this.languageManager;
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getScriptHelper().getService(clazz);
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.slingHttpServletRequest.getResource();
        }
        return this.resource;
    }

    public Page getCurrentPage() {
        if (this.currentPage == null) {
            this.currentPage = PageUtils.getPage(this.getPageManager(), this.getResource(), false);
        }
        return this.currentPage;
    }

    public Page getWrappingPage() {
        if (this.wrappingPage == null) {
            this.wrappingPage = PageUtils.getPage(this.getPageManager(), this.getResource(), true);
        }
        return this.wrappingPage;
    }

    public PageManager getPageManager() {
        if (this.pageManager == null) {
            this.pageManager = (PageManager)this.getResourceResolver().adaptTo(PageManager.class);
        }
        return this.pageManager;
    }

    public ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null) {
            this.resourceResolver = this.slingHttpServletRequest.getResourceResolver();
        }
        return this.resourceResolver;
    }

    public Page getLanguageRootPage() {
        if (this.languageRootPage == null) {
            Page page = this.getWrappingPage();
            this.languageRootPage = PageUtils.getLanguageRootPage(this.getLanguageManager(), page);
        }
        return this.languageRootPage;
    }

    public Session getJcrSession() {
        return (Session)this.getResourceResolver().adaptTo(Session.class);
    }

    public UserProperties getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = (UserProperties)this.slingHttpServletRequest.adaptTo(UserProperties.class);
        }
        return this.userProperties;
    }

    public Boolean getIsAnonymous() {
        if (this.isAnonymous == null) {
            this.isAnonymous = UserPropertiesUtil.isAnonymous((SlingHttpServletRequest)this.getSlingHttpServletRequest());
        }
        return this.isAnonymous;
    }

    public SlingHttpServletRequest getSlingHttpServletRequest() {
        return this.slingHttpServletRequest;
    }

    public SlingHttpServletResponse getSlingHttpServletResponse() {
        return this.slingHttpServletResponse;
    }
}

