/*
 * Decompiled with CFR 0.152.
 */
package ch.liip.aem.taglib;

import ch.liip.aem.exceptions.TaglibExceptionException;
import ch.liip.aem.request.RequestObjects;
import ch.liip.aem.request.utils.Preconditions;
import ch.liip.aem.taglib.ComponentTagSupport;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.jsp.JspException;

public class IfHasPermissionTag
extends ComponentTagSupport {
    private String path;
    private String permissions;
    private String[] allowedPermissions = new String[]{"add_node", "read", "remove", "set_property"};
    private Set<String> allowedPermissionSet = new HashSet<String>(Arrays.asList(this.allowedPermissions));

    public int doStartTag() throws JspException {
        this.validatePermissionList();
        RequestObjects requestObjects = this.createRequestObjects();
        Session jcrSession = requestObjects.getJcrSession();
        try {
            return jcrSession.hasPermission(this.path, this.permissions) ? 1 : 0;
        }
        catch (RepositoryException e) {
            throw new TaglibExceptionException(e);
        }
    }

    private void validatePermissionList() {
        String[] permissionArray;
        for (String permission : permissionArray = this.permissions.split(",")) {
            Preconditions.checkFalse(permission.contains(" "), String.format("Malformed permission list : '%s'. Exemple of allowed format : 'read,add_node' ", this.permissions));
            if (this.allowedPermissionSet.contains(permission.trim())) continue;
            throw new TaglibExceptionException(String.format("Unknown permission provided to the tag : %s. Allowed permissions : %s", permission, Arrays.toString(this.allowedPermissions)));
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }
}

