/*
 * Decompiled with CFR 0.152.
 */
package ch.liip.aem.taglib;

import ch.liip.aem.exceptions.ComponentException;
import ch.liip.aem.request.RequestObjects;
import ch.liip.aem.request.utils.Preconditions;
import ch.liip.aem.taglib.ComponentTagSupport;
import ch.liip.aem.taglib.PageComparator;
import ch.liip.aem.utils.StrUtils;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;

public class PageChildrenTag
extends ComponentTagSupport {
    private String path;
    private String var;
    private Integer maxItems;
    private String orderBy;
    private Boolean reverse;
    private final String DATE_FORMAT = "dd/MM/yy";

    public int doEndTag() throws JspException {
        Page rootPage = null;
        RequestObjects requestObjects = this.createRequestObjects();
        if (this.reverse != null) {
            Preconditions.checkNotNull(this.orderBy, "The parameter 'reverse' is definable only if the paramter 'orderBy' is defined");
        }
        try {
            rootPage = this.determineRootPage(requestObjects);
        }
        catch (ComponentException e) {
            try {
                this.pageContext.getOut().print(e.getMessage());
            }
            catch (IOException e2) {
                this.logger.error("Error printing to page", (Throwable)e);
            }
            return super.doEndTag();
        }
        List<Page> items = new ArrayList<Page>();
        Iterator children = rootPage.listChildren((Filter)new PageFilter((ServletRequest)requestObjects.getSlingHttpServletRequest()));
        for (int count = 0; children.hasNext() && (null == this.maxItems || count < this.maxItems); ++count) {
            Page child = (Page)children.next();
            items.add(child);
        }
        if (null != this.orderBy) {
            items = this.orderBy(items);
        }
        this.pageContext.setAttribute(this.var, items, 1);
        return super.doEndTag();
    }

    private Page determineRootPage(RequestObjects requestObjects) throws ComponentException {
        String rootPagePath = StrUtils.isEmpty(this.path) ? requestObjects.getCurrentPage().getPath() : this.path;
        if (rootPagePath == null) {
            throw new ComponentException("Unable to find rootPagePath. [path = " + this.path + "]");
        }
        Page rootPage = requestObjects.getPageManager().getPage(rootPagePath);
        if (rootPage == null) {
            throw new ComponentException("Unable to find rootPage [path = " + rootPagePath + "]");
        }
        return rootPage;
    }

    private List<Page> orderBy(List<Page> items) {
        Collections.sort(items, new PageComparator(this.orderBy, this.reverse));
        return items;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }
}

