/*
 * Decompiled with CFR 0.152.
 */
package ch.liip.aem.request.utils;

import ch.liip.aem.request.utils.Preconditions;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUtils {
    public static final int ROOT_PAGE_DEPTH = 3;
    protected static final Logger logger = LoggerFactory.getLogger(PageUtils.class);

    public static Page getLanguageRootPage(LanguageManager languageManager, Page referencePage) {
        Page homepage = languageManager.getLanguageRoot(referencePage.getContentResource());
        if (homepage == null) {
            logger.error(String.format("warning, impossible to get the root page. Failing back to depth strategy (depth=%d)", 3));
            homepage = referencePage.getAbsoluteParent(3);
            if (homepage == null) {
                throw new IllegalStateException(String.format("Impossible to get the languageRoot with the depth strategy failback (depth=%d)", 3));
            }
        } else if (homepage.getDepth() != 3) {
            logger.error(String.format("warning, the the rootpage should be at depth (expected depth is %d ", 3));
        }
        return homepage;
    }

    public static boolean isPageEqualOrChildOf(Page pageToTest, Page parent) {
        if (pageToTest == null) {
            return false;
        }
        if (pageToTest.equals(parent)) {
            return true;
        }
        return PageUtils.isPageEqualOrChildOf(pageToTest.getParent(), parent);
    }

    public static Page getPage(PageManager pageManager, Resource resource, boolean findInHierarchy) {
        Preconditions.checkNotNull(resource, "Trying to get the page from a null resource");
        Page containingPage = pageManager.getContainingPage(resource);
        if (containingPage != null) {
            return containingPage;
        }
        if (findInHierarchy) {
            Resource parent = resource.getParent();
            Preconditions.checkNotNull(parent, String.format("The parent of '%s' doesn't exists", resource));
            return PageUtils.getPage(pageManager, parent, findInHierarchy);
        }
        return null;
    }
}

