/*
 * Decompiled with CFR 0.152.
 */
package ch.liip.aem.request.utils;

import ch.liip.aem.request.utils.Preconditions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static <T> T getResourceProperty(Resource resource, String property, Class<T> type) {
        ValueMap valueMap = ResourceUtil.getValueMap((Resource)resource);
        return (T)valueMap.get(property, type);
    }

    public static Resource getResourceChild(Resource resource, String key) {
        String keyTail;
        String childKey;
        if (key == null || key.isEmpty()) {
            return resource;
        }
        String currentKey = key.startsWith("./") ? key.substring(2) : key;
        int slashIndex = currentKey.indexOf(47);
        if (slashIndex == -1) {
            childKey = currentKey;
            keyTail = null;
        } else {
            childKey = currentKey.substring(0, slashIndex);
            keyTail = currentKey.substring(slashIndex + 1);
        }
        Resource resourceChild = ResourceUtils.getResourceChild(resource.getChild(childKey), keyTail);
        Preconditions.checkNotNull(resourceChild, String.format("Impossible to find path '%s' on resource '%s'", key, resource));
        return resourceChild;
    }
}

