/*
 * Decompiled with CFR 0.152.
 */
package ch.liip.aem.taglib;

import ch.liip.aem.taglib.ComponentTagSupport;
import java.util.List;
import javax.servlet.jsp.JspException;

public class PaginateTag
extends ComponentTagSupport {
    private String pageNumber;
    private Integer maxPerPage;
    private String var;
    private List items;
    public Integer DEFAULT_MAX_PER_PAGE = 5;

    public int doEndTag() throws JspException {
        int pageNumber;
        this.maxPerPage = null != this.maxPerPage ? this.maxPerPage : this.DEFAULT_MAX_PER_PAGE;
        try {
            pageNumber = Integer.parseInt(this.pageNumber);
        }
        catch (NumberFormatException nfe) {
            pageNumber = 1;
        }
        this.pageContext.setAttribute(this.var, (Object)this.buildPagination(pageNumber), 1);
        return super.doEndTag();
    }

    private List getCurrentPageItems(List items, int pageNumber) {
        int startIndex = pageNumber * this.maxPerPage - this.maxPerPage;
        Integer endIndex = startIndex + this.maxPerPage - 1;
        endIndex = Math.min(items.size(), endIndex);
        return items.subList(startIndex, endIndex);
    }

    private PaginationResult buildPagination(int pageNumber) {
        int numberOfPages = this.items.size() / this.maxPerPage + (this.items.size() % this.maxPerPage > 0 ? 1 : 0);
        List currentPageItems = this.getCurrentPageItems(this.items, pageNumber);
        return new PaginationResult(currentPageItems, numberOfPages, pageNumber);
    }

    public String getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getMaxPerPage() {
        return this.maxPerPage;
    }

    public void setMaxPerPage(Integer maxPerPage) {
        this.maxPerPage = maxPerPage;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String paginationVar) {
        this.var = paginationVar;
    }

    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public static final class PaginationResult {
        private List items;
        private int numberOfPages;
        private int currentPage;

        public PaginationResult(List items, int numberOfPages, int currentPage) {
            this.items = items;
            this.numberOfPages = numberOfPages;
            this.currentPage = currentPage;
        }

        public List getItems() {
            return this.items;
        }

        public void setItems(List items) {
            this.items = items;
        }

        public int getNumberOfPages() {
            return this.numberOfPages;
        }

        public void setNumberOfPages(int numberOfPages) {
            this.numberOfPages = numberOfPages;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
        }
    }
}

