/*
 * Decompiled with CFR 0.152.
 */
package ch.linkyard.mcp.server;

import cats.Traverse;
import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Async$;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.OptionIdOps$;
import ch.linkyard.mcp.jsonrpc2.Authentication;
import ch.linkyard.mcp.jsonrpc2.JsonRpc;
import ch.linkyard.mcp.protocol.Cancelled;
import ch.linkyard.mcp.protocol.Completion;
import ch.linkyard.mcp.protocol.Completion$;
import ch.linkyard.mcp.protocol.CompletionReference;
import ch.linkyard.mcp.protocol.Initialize;
import ch.linkyard.mcp.protocol.Initialized;
import ch.linkyard.mcp.protocol.Initialized$;
import ch.linkyard.mcp.protocol.Logging;
import ch.linkyard.mcp.protocol.LoggingLevel;
import ch.linkyard.mcp.protocol.Ping;
import ch.linkyard.mcp.protocol.Ping$;
import ch.linkyard.mcp.protocol.ProgressNotification;
import ch.linkyard.mcp.protocol.ProgressNotification$;
import ch.linkyard.mcp.protocol.ProgressToken;
import ch.linkyard.mcp.protocol.Prompts;
import ch.linkyard.mcp.protocol.Request;
import ch.linkyard.mcp.protocol.RequestId;
import ch.linkyard.mcp.protocol.Resources;
import ch.linkyard.mcp.protocol.Roots;
import ch.linkyard.mcp.protocol.Tool;
import ch.linkyard.mcp.protocol.base;
import ch.linkyard.mcp.server.CallContext;
import ch.linkyard.mcp.server.LowlevelMcpServer;
import ch.linkyard.mcp.server.McpError$;
import ch.linkyard.mcp.server.McpServer;
import ch.linkyard.mcp.server.McpServerBridge$;
import ch.linkyard.mcp.server.McpServerBridge$PhaseRunning$;
import ch.linkyard.mcp.server.McpServerClientRepr;
import ch.linkyard.mcp.server.McpServerClientRepr$;
import fs2.Compiler;
import fs2.Compiler$;
import io.circe.Json;
import io.circe.JsonObject;
import java.io.Serializable;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class McpServerBridge {
    public static <F> Resource<F, LowlevelMcpServer<F>> apply(Function1<Function1<Phase<F>, Object>, Phase<F>> function1, Async<F> async) {
        return McpServerBridge$.MODULE$.apply(function1, async);
    }

    public static class Bridge<F>
    implements LowlevelMcpServer<F> {
        private final Ref<F, Phase<F>> state;
        private final Async<F> evidence$1;

        public Bridge(Ref<F, Phase<F>> state, Async<F> evidence$1) {
            this.state = state;
            this.evidence$1 = evidence$1;
        }

        @Override
        public F handleRequest(Serializable request, RequestId requestId, Authentication auth) {
            return (F)cats.implicits$.MODULE$.toFlatMapOps(this.state.get(), this.evidence$1).flatMap(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$Bridge$$_$handleRequest$$anonfun$1(request, requestId, auth, arg_0));
        }

        @Override
        public F handleNotification(Serializable notification, Authentication auth) {
            return (F)cats.implicits$.MODULE$.toFlatMapOps(this.state.get(), this.evidence$1).flatMap(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$Bridge$$_$handleNotification$$anonfun$1(notification, auth, arg_0));
        }

        public F switchTo(Phase<F> newState) {
            return (F)cats.implicits$.MODULE$.toFlatMapOps(this.state.getAndSet(newState), this.evidence$1).flatMap(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$Bridge$$_$switchTo$$anonfun$1);
        }

        public F cleanup() {
            return (F)cats.implicits$.MODULE$.toFunctorOps(this.state.set(null), this.evidence$1).void();
        }
    }

    public static interface Phase<F>
    extends LowlevelMcpServer<F> {
        public F cleanup();
    }

    public static class PhaseInitial<F>
    implements Phase<F> {
        private final McpServer<F> server;
        private final LowlevelMcpServer.Communication<F> comms;
        private final Function1<Phase<F>, F> switchTo;
        private final Async<F> evidence$1;

        public PhaseInitial(McpServer<F> server, LowlevelMcpServer.Communication<F> comms, Function1<Phase<F>, Object> switchTo, Async<F> evidence$1) {
            this.server = server;
            this.comms = comms;
            this.switchTo = switchTo;
            this.evidence$1 = evidence$1;
        }

        @Override
        public F handleRequest(Serializable request, RequestId requestId, Authentication auth) {
            Serializable serializable = request;
            if (serializable instanceof Initialize) {
                Initialize init = (Initialize)serializable;
                return (F)cats.implicits$.MODULE$.toFlatMapOps(McpServerClientRepr$.MODULE$.apply(init, this.comms, auth, this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)client -> cats.implicits$.MODULE$.toFlatMapOps(this.server.initialize((McpServer.Client<F>)client).allocated(this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        McpServer.Session session = (McpServer.Session)tuple2._1();
                        Object cleanup = tuple2._2();
                        return cats.implicits$.MODULE$.toFlatMapOps(this.switchTo.apply(new PhaseInitializing<F>(session, client, cleanup, this.comms, this.switchTo, this.evidence$1)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return cats.implicits$.MODULE$.toFunctorOps(session.instructions(), this.evidence$1).map(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseInitial$$_$handleRequest$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(session, arg_0));
                        });
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            if (serializable instanceof Ping) {
                Ping ping = Ping$.MODULE$.unapply((Ping)serializable);
                JsonObject jsonObject = ping._1();
                Serializable serializable2 = (Serializable)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)Ping.Response$.MODULE$.apply(Ping.Response$.MODULE$.$lessinit$greater$default$1()));
                return (F)ApplicativeIdOps$.MODULE$.pure$extension((Object)serializable2, this.evidence$1);
            }
            Serializable other = serializable;
            return (F)cats.implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.MethodNotFound, new StringBuilder(48).append("Unexpected request during initialization phase: ").append(((Request)other).method().key()).toString(), McpError$.MODULE$.raise$default$3(), this.evidence$1), this.evidence$1).widen();
        }

        @Override
        public F handleNotification(Serializable notification, Authentication auth) {
            return (F)Async$.MODULE$.apply(this.evidence$1).unit();
        }

        @Override
        public F cleanup() {
            return (F)Async$.MODULE$.apply(this.evidence$1).unit();
        }
    }

    public static class PhaseInitializing<F>
    implements Phase<F> {
        private final McpServer.Session<F> session;
        private final McpServerClientRepr<F> client;
        private final F cleanup;
        private final LowlevelMcpServer.Communication<F> comms;
        private final Function1<Phase<F>, F> switchTo;
        private final Async<F> evidence$1;

        public PhaseInitializing(McpServer.Session<F> session, McpServerClientRepr<F> client, Object cleanup, LowlevelMcpServer.Communication<F> comms, Function1<Phase<F>, Object> switchTo, Async<F> evidence$1) {
            this.session = session;
            this.client = client;
            this.cleanup = cleanup;
            this.comms = comms;
            this.switchTo = switchTo;
            this.evidence$1 = evidence$1;
        }

        @Override
        public F cleanup() {
            return this.cleanup;
        }

        @Override
        public F handleRequest(Serializable request, RequestId requestId, Authentication auth) {
            Object object = cats.implicits$.MODULE$.catsSyntaxFlatMapOps(this.client.updateAuthentication(auth), this.evidence$1);
            return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.handleRequest$$anonfun$3(request), this.evidence$1);
        }

        @Override
        public F handleNotification(Serializable notification, Authentication auth) {
            Object object = cats.implicits$.MODULE$.catsSyntaxFlatMapOps(this.client.updateAuthentication(auth), this.evidence$1);
            return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.handleNotification$$anonfun$2(notification), this.evidence$1);
        }

        private final Object handleRequest$$anonfun$3(Serializable request$2) {
            Serializable serializable = request$2;
            if (serializable instanceof Initialize) {
                Initialize init = (Initialize)serializable;
                return cats.implicits$.MODULE$.toFunctorOps(this.session.instructions(), this.evidence$1).map((Function1 & Serializable)instructions -> Initialize.Response$.MODULE$.apply(this.session.serverInfo(), McpServerBridge$.MODULE$.ch$linkyard$mcp$server$McpServerBridge$$$capabilitiesFor(this.session), instructions, Initialize.Response$.MODULE$.$lessinit$greater$default$4(), Initialize.Response$.MODULE$.$lessinit$greater$default$5()));
            }
            if (serializable instanceof Ping) {
                Serializable serializable2 = (Serializable)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)Ping.Response$.MODULE$.apply(Ping.Response$.MODULE$.$lessinit$greater$default$1()));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)serializable2, this.evidence$1);
            }
            Serializable other = serializable;
            return cats.implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.InvalidRequest, new StringBuilder(48).append("Unexpected request during initialization phase: ").append(((Request)other).method().key()).toString(), McpError$.MODULE$.raise$default$3(), this.evidence$1), this.evidence$1).widen();
        }

        private final Object handleNotification$$anonfun$2(Serializable notification$2) {
            Serializable serializable = notification$2;
            if (serializable instanceof Initialized) {
                Initialized initialized = Initialized$.MODULE$.unapply((Initialized)serializable);
                JsonObject jsonObject = initialized._1();
                return cats.implicits$.MODULE$.toFlatMapOps(McpServerBridge$PhaseRunning$.MODULE$.apply(this.session, this.client, this.cleanup(), this.comms, this.evidence$1), this.evidence$1).flatMap(this.switchTo);
            }
            Serializable other = serializable;
            return Async$.MODULE$.apply(this.evidence$1).unit();
        }
    }

    public static class PhaseRunning<F>
    implements Phase<F> {
        private final McpServer.Session<F> session;
        public final McpServerClientRepr<F> ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client;
        private final F cleanup;
        public final LowlevelMcpServer.Communication<F> ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$comms;
        private final Ref<F, Map<String, F>> activeSubscriptions;
        public final Async<F> ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1;

        public static <F> Object apply(McpServer.Session<F> session, McpServerClientRepr<F> mcpServerClientRepr, Object object, LowlevelMcpServer.Communication<F> communication, Async<F> async) {
            return McpServerBridge$PhaseRunning$.MODULE$.apply(session, mcpServerClientRepr, object, communication, async);
        }

        public PhaseRunning(McpServer.Session<F> session, McpServerClientRepr<F> client, Object cleanup, LowlevelMcpServer.Communication<F> comms, Ref<F, Map<String, Object>> activeSubscriptions, Async<F> evidence$1) {
            this.session = session;
            this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client = client;
            this.cleanup = cleanup;
            this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$comms = comms;
            this.activeSubscriptions = activeSubscriptions;
            this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1 = evidence$1;
        }

        @Override
        public F cleanup() {
            return this.cleanup;
        }

        private F unsupported() {
            return (F)cats.implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.MethodNotFound, "Capability not supported", McpError$.MODULE$.raise$default$3(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).widen();
        }

        private CallContext<F> createCallContext(String name, JsonObject _meta, RequestId request) {
            return new CallContext<F>(_meta, request, name, this){
                private final JsonObject _meta$2;
                private final RequestId request$4;
                private final String name$2;
                private final JsonObject meta;
                private final /* synthetic */ PhaseRunning $outer;
                {
                    this._meta$2 = _meta$1;
                    this.request$4 = request$3;
                    this.name$2 = name$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.meta = _meta$1;
                }

                public Object reportProgress(double progress, Option total, Option message) {
                    Option option = base.package.Meta$.MODULE$.progressToken(this._meta$2);
                    if (option instanceof Some) {
                        ProgressToken progressToken = (ProgressToken)((Some)option).value();
                        return this.$outer.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$comms.notify((Serializable)ProgressNotification$.MODULE$.apply(progressToken, progress, total, message, base.package.Meta$.MODULE$.withRequestRelation(this.request$4)));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Async$.MODULE$.apply(this.$outer.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).unit();
                    }
                    throw new MatchError((Object)option);
                }

                public Option reportProgress$default$2() {
                    return None$.MODULE$;
                }

                public Option reportProgress$default$3() {
                    return None$.MODULE$;
                }

                public Object log(LoggingLevel level, String message) {
                    String string = (String)cats.implicits$.MODULE$.catsSyntaxOptionId((Object)this.name$2);
                    return this.$outer.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client.log(level, (Option<String>)OptionIdOps$.MODULE$.some$extension((Object)string), message);
                }

                public Object log(LoggingLevel level, Json data) {
                    String string = (String)cats.implicits$.MODULE$.catsSyntaxOptionId((Object)this.name$2);
                    return this.$outer.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client.log(level, (Option<String>)OptionIdOps$.MODULE$.some$extension((Object)string), data);
                }

                public JsonObject meta() {
                    return this.meta;
                }
            };
        }

        @Override
        public F handleRequest(Serializable request, RequestId requestId, Authentication auth) {
            Object object = cats.implicits$.MODULE$.catsSyntaxFlatMapOps(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client.updateAuthentication(auth), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
            return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.handleRequest$$anonfun$4(request, requestId), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
        }

        @Override
        public F handleNotification(Serializable notification, Authentication auth) {
            Object object = cats.implicits$.MODULE$.catsSyntaxFlatMapOps(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client.updateAuthentication(auth), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
            return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.handleNotification$$anonfun$3(notification), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
        }

        private final Object handleRequest$$anonfun$4(Serializable request$5, RequestId requestId$2) {
            Serializable serializable = request$5;
            if (serializable instanceof Tool.ListTools) {
                Tool.ListTools listTools = Tool.ListTools$.MODULE$.unapply((Tool.ListTools)serializable);
                Option option = listTools._1();
                JsonObject jsonObject = listTools._2();
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ToolProvider) {
                    McpServer.ToolProvider session2 = (McpServer.ToolProvider)session;
                    return cats.implicits$.MODULE$.toFunctorOps(cats.implicits$.MODULE$.toFunctorOps(session2.tools(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$1), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$2);
                }
                return this.unsupported();
            }
            if (serializable instanceof Tool.CallTool) {
                Tool.CallTool callTool = Tool.CallTool$.MODULE$.unapply((Tool.CallTool)serializable);
                String string = callTool._1();
                JsonObject jsonObject = callTool._2();
                JsonObject jsonObject2 = callTool._3();
                String name = string;
                JsonObject arguments = jsonObject;
                JsonObject _meta = jsonObject2;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ToolProvider) {
                    McpServer.ToolProvider session3 = (McpServer.ToolProvider)session;
                    return cats.implicits$.MODULE$.toFlatMapOps(cats.implicits$.MODULE$.toFlatMapOps(session3.tools(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)_$13 -> {
                        Either either = cats.implicits$.MODULE$.catsSyntaxEither(_$13.find(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$3$$anonfun$1(name, arg_0)).toRight(() -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$3$$anonfun$2(name)));
                        return EitherOps$.MODULE$.liftTo$extension(either, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
                    }), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)tool -> {
                        CallContext<F> context = this.createCallContext(new StringBuilder(5).append("tool/").append(tool.name()).toString(), _meta, requestId$2);
                        return cats.implicits$.MODULE$.toFunctorOps(tool.apply(arguments, context), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$4$$anonfun$1);
                    });
                }
                return this.unsupported();
            }
            if (serializable instanceof Prompts.ListPrompts) {
                Prompts.ListPrompts listPrompts = Prompts.ListPrompts$.MODULE$.unapply((Prompts.ListPrompts)serializable);
                Option option = listPrompts._1();
                JsonObject jsonObject = listPrompts._2();
                Option cursor = option;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.PromptProvider) {
                    McpServer.PromptProvider session4 = (McpServer.PromptProvider)session;
                    return cats.implicits$.MODULE$.toFunctorOps(cats.implicits$.MODULE$.toFunctorOps(session4.prompts(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$5), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$6);
                }
                return this.unsupported();
            }
            if (serializable instanceof Prompts.GetPrompt) {
                Prompts.GetPrompt getPrompt = Prompts.GetPrompt$.MODULE$.unapply((Prompts.GetPrompt)serializable);
                String string = getPrompt._1();
                Option option = getPrompt._2();
                JsonObject jsonObject = getPrompt._3();
                String name = string;
                Option arguments = option;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.PromptProvider) {
                    McpServer.PromptProvider session5 = (McpServer.PromptProvider)session;
                    return cats.implicits$.MODULE$.toFlatMapOps(cats.implicits$.MODULE$.toFlatMapOps(session5.prompts(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)_$18 -> {
                        Either either = cats.implicits$.MODULE$.catsSyntaxEither(_$18.find(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$7$$anonfun$1(name, arg_0)).toRight(() -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$7$$anonfun$2(name)));
                        return EitherOps$.MODULE$.liftTo$extension(either, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
                    }), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)prompt -> {
                        CallContext<F> context = this.createCallContext(new StringBuilder(7).append("prompt/").append(name).toString(), _meta, requestId$2);
                        return cats.implicits$.MODULE$.toFunctorOps(prompt.get((Map<String, String>)((Map)arguments.getOrElse(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$8$$anonfun$1)), context), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$8$$anonfun$2);
                    });
                }
                return this.unsupported();
            }
            if (serializable instanceof Resources.ListResources) {
                Resources.ListResources listResources = Resources.ListResources$.MODULE$.unapply((Resources.ListResources)serializable);
                Option option = listResources._1();
                JsonObject jsonObject = listResources._2();
                Option cursor = option;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ResourceProvider) {
                    McpServer.ResourceProvider session6 = (McpServer.ResourceProvider)session;
                    return cats.implicits$.MODULE$.toFunctorOps(session6.resources((Option<String>)cursor).take(Int$.MODULE$.int2long(session6.maxPageSize())).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1))).toList(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$9);
                }
                return this.unsupported();
            }
            if (serializable instanceof Resources.ListResourceTemplates) {
                Resources.ListResourceTemplates listResourceTemplates = Resources.ListResourceTemplates$.MODULE$.unapply((Resources.ListResourceTemplates)serializable);
                Option option = listResourceTemplates._1();
                JsonObject jsonObject = listResourceTemplates._2();
                Option cursor = option;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ResourceProvider) {
                    McpServer.ResourceProvider session7 = (McpServer.ResourceProvider)session;
                    return cats.implicits$.MODULE$.toFunctorOps(session7.resourceTemplates((Option<String>)cursor).take(Int$.MODULE$.int2long(session7.maxPageSize())).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1))).toList(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$10);
                }
                return this.unsupported();
            }
            if (serializable instanceof Resources.ReadResource) {
                Resources.ReadResource readResource = Resources.ReadResource$.MODULE$.unapply((Resources.ReadResource)serializable);
                String string = readResource._1();
                JsonObject jsonObject = readResource._2();
                String uri = string;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ResourceProvider) {
                    McpServer.ResourceProvider session8 = (McpServer.ResourceProvider)session;
                    CallContext<F> context = this.createCallContext(new StringBuilder(9).append("resource/").append(uri).toString(), _meta, requestId$2);
                    return cats.implicits$.MODULE$.toFunctorOps(session8.resource(uri, context), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).widen();
                }
                return this.unsupported();
            }
            if (serializable instanceof Resources.Subscribe) {
                Resources.Subscribe subscribe = Resources.Subscribe$.MODULE$.unapply((Resources.Subscribe)serializable);
                String string = subscribe._1();
                JsonObject jsonObject = subscribe._2();
                String uri = string;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ResourceSubscriptionProvider) {
                    McpServer.ResourceSubscriptionProvider session9 = (McpServer.ResourceSubscriptionProvider)session;
                    CallContext<F> context = this.createCallContext("resource/subription", _meta, requestId$2);
                    Object object = implicits$.MODULE$.genSpawnOps(session9.resourceSubscription(uri, context).evalMap((Function1 & Serializable)updated -> this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$comms.notify((Serializable)Resources.Updated$.MODULE$.apply(uri, updated.meta()))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1))).drain(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
                    return cats.implicits$.MODULE$.toFlatMapOps(GenSpawnOps$.MODULE$.start$extension(object, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)fibre -> {
                        Object unsubscribe = fibre.cancel();
                        return cats.implicits$.MODULE$.toFlatMapOps(this.activeSubscriptions.getAndUpdate(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$12$$anonfun$1(uri, unsubscribe, arg_0)), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)before -> cats.implicits$.MODULE$.toFunctorOps(cats.implicits$.MODULE$.toTraverseOps((Object)before.get((Object)uri), (Traverse)cats.implicits$.MODULE$.catsStdInstancesForOption()).traverse(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$12$$anonfun$2$$anonfun$1, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$12$$anonfun$2$$anonfun$2));
                    });
                }
                return this.unsupported();
            }
            if (serializable instanceof Resources.Unsubscribe) {
                Resources.Unsubscribe unsubscribe = Resources.Unsubscribe$.MODULE$.unapply((Resources.Unsubscribe)serializable);
                String string = unsubscribe._1();
                JsonObject jsonObject = unsubscribe._2();
                String uri = string;
                JsonObject _meta = jsonObject;
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.ResourceSubscriptionProvider) {
                    McpServer.ResourceSubscriptionProvider session10 = (McpServer.ResourceSubscriptionProvider)session;
                    return cats.implicits$.MODULE$.toFunctorOps(cats.implicits$.MODULE$.toFunctorOps(this.activeSubscriptions.modify(arg_0 -> McpServerBridge$.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$13(uri, arg_0)), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map((Function1 & Serializable)_$24 -> cats.implicits$.MODULE$.toTraverseOps(_$24, (Traverse)cats.implicits$.MODULE$.catsStdInstancesForOption()).traverse(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$14$$anonfun$1, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1)), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).as((Object)Resources.Unsubscribe$.Response$.MODULE$.apply(Resources.Unsubscribe$.Response$.MODULE$.$lessinit$greater$default$1()));
                }
                return this.unsupported();
            }
            if (serializable instanceof Completion.Complete) {
                Object object;
                Completion.Complete complete = Completion.Complete$.MODULE$.unapply((Completion.Complete)serializable);
                CompletionReference completionReference = complete._1();
                Completion.Complete.Argument argument = complete._2();
                Option option = complete._3();
                JsonObject jsonObject = complete._4();
                CompletionReference ref = completionReference;
                Completion.Complete.Argument argument2 = argument;
                Option context = option;
                JsonObject _meta = jsonObject;
                CompletionReference completionReference2 = ref;
                if (completionReference2 instanceof CompletionReference.PromptReference) {
                    CompletionReference.PromptReference promptReference = CompletionReference.PromptReference$.MODULE$.unapply((CompletionReference.PromptReference)completionReference2);
                    String string = promptReference._1();
                    Option option2 = promptReference._2();
                    String name = string;
                    McpServer.Session<F> session = this.session;
                    if (session instanceof McpServer.PromptProvider) {
                        McpServer.PromptProvider session11 = (McpServer.PromptProvider)session;
                        object = cats.implicits$.MODULE$.toFlatMapOps(session11.prompt(name), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)_$25 -> _$25.argumentCompletions(argument2.name(), argument2.value(), (Map<String, String>)((Map)context.flatMap(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$$anonfun$5$$anonfun$1).getOrElse(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$$anonfun$5$$anonfun$2)), this.createCallContext("completion/prompt", _meta, requestId$2)));
                    } else {
                        Completion completion = (Completion)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)Completion$.MODULE$.apply((List)package$.MODULE$.Nil(), Completion$.MODULE$.$lessinit$greater$default$2(), Completion$.MODULE$.$lessinit$greater$default$3()));
                        object = ApplicativeIdOps$.MODULE$.pure$extension((Object)completion, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
                    }
                } else if (completionReference2 instanceof CompletionReference.ResourceTemplateReference) {
                    String string;
                    CompletionReference.ResourceTemplateReference resourceTemplateReference = CompletionReference.ResourceTemplateReference$.MODULE$.unapply((CompletionReference.ResourceTemplateReference)completionReference2);
                    String uri = string = resourceTemplateReference._1();
                    McpServer.Session<F> session = this.session;
                    if (session instanceof McpServer.ResourceProvider) {
                        McpServer.ResourceProvider session12 = (McpServer.ResourceProvider)session;
                        object = cats.implicits$.MODULE$.toFlatMapOps(session12.resourceTemplate(uri), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).flatMap((Function1 & Serializable)_$27 -> _$27.completions(argument2.name(), argument2.value(), (Map<String, String>)((Map)context.flatMap(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$$anonfun$6$$anonfun$1).getOrElse(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$$anonfun$6$$anonfun$2)), this.createCallContext("completion/prompt", _meta, requestId$2)));
                    } else {
                        Completion completion = (Completion)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)Completion$.MODULE$.apply((List)package$.MODULE$.Nil(), Completion$.MODULE$.$lessinit$greater$default$2(), Completion$.MODULE$.$lessinit$greater$default$3()));
                        object = ApplicativeIdOps$.MODULE$.pure$extension((Object)completion, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
                    }
                } else {
                    throw new MatchError((Object)completionReference2);
                }
                Object completion = object;
                return cats.implicits$.MODULE$.toFunctorOps(completion, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).map(McpServerBridge$::ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$_$handleRequest$$anonfun$4$$anonfun$15);
            }
            if (serializable instanceof Logging.SetLevel) {
                Logging.SetLevel setLevel = Logging.SetLevel$.MODULE$.unapply((Logging.SetLevel)serializable);
                LoggingLevel loggingLevel = setLevel._1();
                JsonObject jsonObject = setLevel._2();
                LoggingLevel level = loggingLevel;
                return cats.implicits$.MODULE$.toFunctorOps(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$client.setLogLevel(level), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).as((Object)Logging.SetLevel$.Response$.MODULE$.apply(Logging.SetLevel$.Response$.MODULE$.$lessinit$greater$default$1()));
            }
            if (serializable instanceof Ping) {
                Ping ping = Ping$.MODULE$.unapply((Ping)serializable);
                JsonObject jsonObject = ping._1();
                Serializable serializable2 = (Serializable)cats.implicits$.MODULE$.catsSyntaxApplicativeId((Object)Ping.Response$.MODULE$.apply(Ping.Response$.MODULE$.$lessinit$greater$default$1()));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)serializable2, this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1);
            }
            if (serializable instanceof Initialize) {
                return cats.implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.InvalidRequest, "Unexpected initialize request during running phase", McpError$.MODULE$.raise$default$3(), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1), this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).widen();
            }
            throw new MatchError((Object)serializable);
        }

        private final Object handleNotification$$anonfun$3(Serializable notification$3) {
            Serializable serializable = notification$3;
            if (serializable instanceof Roots.ListChanged) {
                JsonObject jsonObject;
                Roots.ListChanged listChanged = Roots.ListChanged$.MODULE$.unapply((Roots.ListChanged)serializable);
                JsonObject _meta = jsonObject = listChanged._1();
                McpServer.Session<F> session = this.session;
                if (session instanceof McpServer.RootChangeAwareProvider) {
                    McpServer.RootChangeAwareProvider s = (McpServer.RootChangeAwareProvider)session;
                    return s.rootsChanged();
                }
                return Async$.MODULE$.apply(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).unit();
            }
            if (serializable instanceof ProgressNotification) {
                ProgressNotification progressNotification = ProgressNotification$.MODULE$.unapply((ProgressNotification)serializable);
                ProgressToken progressToken = progressNotification._1();
                double d = progressNotification._2();
                Option option = progressNotification._3();
                Option option2 = progressNotification._4();
                JsonObject jsonObject = progressNotification._5();
                ProgressToken progressToken2 = progressToken;
                double progress = d;
                Option total = option;
                Option message = option2;
                JsonObject _meta = jsonObject;
                return Async$.MODULE$.apply(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).unit();
            }
            if (serializable instanceof Cancelled) {
                return Async$.MODULE$.apply(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).unit();
            }
            if (serializable instanceof Initialized) {
                return Async$.MODULE$.apply(this.ch$linkyard$mcp$server$McpServerBridge$PhaseRunning$$evidence$1).unit();
            }
            throw new MatchError((Object)serializable);
        }
    }
}

