/*
 * Decompiled with CFR 0.152.
 */
package ch.linkyard.mcp.server;

import cats.effect.kernel.Async;
import cats.effect.kernel.Async$;
import cats.effect.kernel.Ref;
import cats.implicits$;
import cats.syntax.IfMOps$;
import ch.linkyard.mcp.jsonrpc2.JsonRpc;
import ch.linkyard.mcp.protocol.Elicitation;
import ch.linkyard.mcp.protocol.Initialize;
import ch.linkyard.mcp.protocol.Logging;
import ch.linkyard.mcp.protocol.LoggingLevel;
import ch.linkyard.mcp.protocol.Ping;
import ch.linkyard.mcp.protocol.Ping$;
import ch.linkyard.mcp.protocol.Roots;
import ch.linkyard.mcp.protocol.Sampling;
import ch.linkyard.mcp.protocol.base;
import ch.linkyard.mcp.server.LowlevelMcpServer;
import ch.linkyard.mcp.server.McpError$;
import ch.linkyard.mcp.server.McpServer;
import ch.linkyard.mcp.server.McpServerClientRepr$;
import ch.linkyard.mcp.server.error$package$;
import io.circe.Decoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.JsonObject;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;

public class McpServerClientRepr<F>
implements McpServer.Client<F> {
    private final Initialize client;
    private final LowlevelMcpServer.Communication<F> comms;
    private final Ref<F, LoggingLevel> logLevelRef;
    private final Async<F> evidence$1;
    private final Initialize.PartyInfo clientInfo;
    private final Initialize.ClientCapabilities capabilities;

    public static <F> Object apply(Initialize initialize, LowlevelMcpServer.Communication<F> communication, Async<F> async) {
        return McpServerClientRepr$.MODULE$.apply(initialize, communication, async);
    }

    public McpServerClientRepr(Initialize client, LowlevelMcpServer.Communication<F> comms, Ref<F, LoggingLevel> logLevelRef, Async<F> evidence$1) {
        this.client = client;
        this.comms = comms;
        this.logLevelRef = logLevelRef;
        this.evidence$1 = evidence$1;
        this.clientInfo = client.clientInfo();
        this.capabilities = client.capabilities();
    }

    @Override
    public Initialize.PartyInfo clientInfo() {
        return this.clientInfo;
    }

    @Override
    public Initialize.ClientCapabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public F ping() {
        return (F)implicits$.MODULE$.toFunctorOps(error$package$.MODULE$.liftToF(this.comms.request((Serializable)Ping$.MODULE$.apply(Ping$.MODULE$.$lessinit$greater$default$1()), (Decoder<Serializable>)Ping.Response$.MODULE$.given_Decoder_Response()), this.evidence$1), this.evidence$1).void();
    }

    public F setLogLevel(LoggingLevel level) {
        return (F)this.logLevelRef.set((Object)level);
    }

    @Override
    public F log(LoggingLevel level, Option<String> logger, String message) {
        String string = (String)package$.MODULE$.EncoderOps((Object)message);
        return this.log(level, logger, package.EncoderOps$.MODULE$.asJson$extension((Object)string, Encoder$.MODULE$.encodeString()));
    }

    @Override
    public F log(LoggingLevel level, Option<String> logger, Json data) {
        Object object = implicits$.MODULE$.catsSyntaxIfM(implicits$.MODULE$.toFunctorOps(this.logLevelRef.get(), this.evidence$1).map((Function1 & Serializable)_$2 -> _$2.$less$eq((Object)level)), this.evidence$1);
        return (F)IfMOps$.MODULE$.ifM$extension(object, () -> this.log$$anonfun$2(level, logger, data), this::log$$anonfun$3, this.evidence$1);
    }

    @Override
    public F sample(List<Sampling.Message> messages, int maxTokens, Option<Sampling.ModelPreferences> modelPreferences, Option<String> systemPrompt, Option<Object> temperature, Option<String> includeContext, Option<List<String>> stopSequences, Option<JsonObject> metadata, JsonObject _meta) {
        if (this.client.capabilities().sampling().isDefined()) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.comms.request((Serializable)Sampling.CreateMessage$.MODULE$.apply(messages, modelPreferences, systemPrompt, maxTokens, temperature, includeContext, stopSequences, metadata, _meta), (Decoder<Serializable>)Sampling.CreateMessage$.Response$.MODULE$.given_Decoder_Response()), this.evidence$1).flatMap((Function1 & Serializable)_$3 -> error$package$.MODULE$.liftTo(_$3, this.evidence$1));
        }
        return (F)implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.MethodNotFound, "Sampling is not supported by this MCP client", McpError$.MODULE$.raise$default$3(), this.evidence$1), this.evidence$1).widen();
    }

    @Override
    public Option<Sampling.ModelPreferences> sample$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Option<String> sample$default$4() {
        return None$.MODULE$;
    }

    @Override
    public Option<Object> sample$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Option<String> sample$default$6() {
        return None$.MODULE$;
    }

    @Override
    public Option<List<String>> sample$default$7() {
        return None$.MODULE$;
    }

    @Override
    public Option<JsonObject> sample$default$8() {
        return None$.MODULE$;
    }

    @Override
    public JsonObject sample$default$9() {
        return base.package.Meta$.MODULE$.empty();
    }

    @Override
    public F listRoots() {
        if (this.client.capabilities().roots().isDefined()) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.comms.request((Serializable)Roots.ListRoots$.MODULE$.apply(Roots.ListRoots$.MODULE$.$lessinit$greater$default$1()), (Decoder<Serializable>)Roots.ListRoots$.Response$.MODULE$.given_Decoder_Response()), this.evidence$1).flatMap((Function1 & Serializable)_$4 -> error$package$.MODULE$.liftTo(_$4, this.evidence$1));
        }
        return (F)implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.MethodNotFound, "Listing roots is not supported by this MCP client", McpError$.MODULE$.raise$default$3(), this.evidence$1), this.evidence$1).widen();
    }

    @Override
    public F elicit(String message, JsonObject requestedSchema, JsonObject _meta) {
        if (this.client.capabilities().elicitation().isDefined()) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.comms.request((Serializable)Elicitation.Create$.MODULE$.apply(message, requestedSchema, _meta), (Decoder<Serializable>)Elicitation.Create$.Response$.MODULE$.given_Decoder_Response()), this.evidence$1).flatMap((Function1 & Serializable)_$5 -> error$package$.MODULE$.liftTo(_$5, this.evidence$1));
        }
        return (F)implicits$.MODULE$.toFunctorOps(McpError$.MODULE$.raise(JsonRpc.ErrorCode$.MethodNotFound, "Elicitation is not supported by this MCP client", McpError$.MODULE$.raise$default$3(), this.evidence$1), this.evidence$1).widen();
    }

    @Override
    public JsonObject elicit$default$3() {
        return base.package.Meta$.MODULE$.empty();
    }

    private final Object log$$anonfun$2(LoggingLevel level$2, Option logger$1, Json data$1) {
        return this.comms.notify((Serializable)Logging.LoggingMessage$.MODULE$.apply(level$2, logger$1, data$1, Logging.LoggingMessage$.MODULE$.$lessinit$greater$default$4()));
    }

    private final Object log$$anonfun$3() {
        return Async$.MODULE$.apply(this.evidence$1).unit();
    }
}

