/*
 * Decompiled with CFR 0.152.
 */
package ch.linkyard.mcp.server;

import cats.Traverse;
import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.kernel.syntax.MonadCancelOps_$;
import cats.effect.std.Queue;
import ch.linkyard.mcp.jsonrpc2.Authentication;
import ch.linkyard.mcp.jsonrpc2.JsonRpc;
import ch.linkyard.mcp.jsonrpc2.JsonRpcServer;
import ch.linkyard.mcp.protocol.Cancelled$;
import ch.linkyard.mcp.protocol.Codec$;
import ch.linkyard.mcp.protocol.RequestId;
import ch.linkyard.mcp.server.LowlevelMcpServer$;
import ch.linkyard.mcp.server.LowlevelMcpServer$State$;
import ch.linkyard.mcp.server.McpError$;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.JsonObject;
import java.io.Serializable;
import scala.DummyImplicit$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public interface LowlevelMcpServer<F> {
    public static <F> Resource<F, JsonRpcServer<F>> start(Function1<Communication<F>, Resource<F, LowlevelMcpServer<F>>> function1, Function1<DecodingFailure, Object> function12, Async<F> async) {
        return LowlevelMcpServer$.MODULE$.start(function1, function12, async);
    }

    public F handleRequest(Serializable var1, RequestId var2, Authentication var3);

    public F handleNotification(Serializable var1, Authentication var2);

    public static class Comms<F>
    implements Communication<F> {
        private final Ref<F, State<F>> stateRef;
        private final Queue<F, JsonRpc.Message> out;
        private final Async<F> evidence$1;

        public Comms(Ref<F, State<F>> stateRef, Queue<F, JsonRpc.Message> out, Async<F> evidence$1) {
            this.stateRef = stateRef;
            this.out = out;
            this.evidence$1 = evidence$1;
        }

        private <F> Object newRequestId(Sync<F> evidence$1) {
            return cats.implicits$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(evidence$1).delay(LowlevelMcpServer$::ch$linkyard$mcp$server$LowlevelMcpServer$Comms$$_$newRequestId$$anonfun$1), evidence$1).map(LowlevelMcpServer$::ch$linkyard$mcp$server$LowlevelMcpServer$Comms$$_$newRequestId$$anonfun$2);
        }

        @Override
        public F request(Serializable request, Decoder<Serializable> x$2) {
            return (F)cats.implicits$.MODULE$.toFlatMapOps(this.newRequestId((Sync<F>)this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)id -> {
                JsonRpc.Id jsonRpcId = Codec$.MODULE$.toJsonRpc(id);
                return cats.implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)deferred -> {
                    Function1 & Serializable handler = (Function1 & Serializable)x$1 -> {
                        JsonRpc.Response response = x$1;
                        if (response instanceof JsonRpc.Response$.Success) {
                            JsonRpc.Response$.Success success = (JsonRpc.Response$.Success)response;
                            JsonRpc.Response$.Success success2 = JsonRpc.Response$.Success$.MODULE$.unapply(success);
                            JsonRpc.Id id = success2._1();
                            JsonObject jsonObject = success2._2();
                            JsonRpc.Id id2 = jsonRpcId;
                            JsonRpc.Id id3 = id;
                            if (!(id2 != null ? !id2.equals(id3) : id3 != null)) {
                                JsonObject response2 = jsonObject;
                                JsonRpc.Response$.Success m = success;
                                Either result = Codec$.MODULE$.fromJsonRpc((JsonRpc.Response)m, x$2).map(LowlevelMcpServer$::ch$linkyard$mcp$server$LowlevelMcpServer$Comms$$_$_$$anonfun$2).left().map(LowlevelMcpServer$::ch$linkyard$mcp$server$LowlevelMcpServer$Comms$$_$_$$anonfun$3);
                                return cats.implicits$.MODULE$.toFunctorOps(deferred.complete((Object)result), this.evidence$1).void();
                            }
                        }
                        if (response instanceof JsonRpc.Response$.Error) {
                            JsonRpc.Response$.Error error2 = JsonRpc.Response$.Error$.MODULE$.unapply((JsonRpc.Response$.Error)response);
                            JsonRpc.Id id = error2._1();
                            JsonRpc.ErrorCode errorCode = error2._2();
                            String string = error2._3();
                            Option option = error2._4();
                            JsonRpc.Id id4 = jsonRpcId;
                            JsonRpc.Id id5 = id;
                            if (!(id4 != null ? !id4.equals(id5) : id5 != null)) {
                                JsonRpc.ErrorCode errorCode2 = errorCode;
                                String errorMessage = string;
                                Option errorData = option;
                                return cats.implicits$.MODULE$.toFunctorOps(deferred.complete((Object)package$.MODULE$.Left().apply((Object)McpError$.MODULE$.apply(errorCode2, errorMessage, (Option<Json>)errorData))), this.evidence$1).void();
                            }
                        }
                        JsonRpc.Response other = response;
                        return Sync$.MODULE$.apply(this.evidence$1).unit();
                    };
                    return cats.implicits$.MODULE$.toFlatMapOps(this.stateRef.update(arg_0 -> LowlevelMcpServer$.ch$linkyard$mcp$server$LowlevelMcpServer$Comms$$_$request$$anonfun$1$$anonfun$1$$anonfun$1(id, handler, arg_0)), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return cats.implicits$.MODULE$.toFlatMapOps(this.out.offer((Object)Codec$.MODULE$.encodeServerRequest(id, request)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object = implicits$.MODULE$.monadCancelOps_(deferred.get());
                            return cats.implicits$.MODULE$.toFunctorOps(MonadCancelOps_$.MODULE$.onCancel$extension(object, this.out.offer((Object)Codec$.MODULE$.encodeServerNotification((Serializable)Cancelled$.MODULE$.apply(id, "Cancelled", Cancelled$.MODULE$.$lessinit$greater$default$3()))), this.evidence$1), this.evidence$1).map(LowlevelMcpServer$::ch$linkyard$mcp$server$LowlevelMcpServer$Comms$$_$request$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1);
                        });
                    });
                });
            });
        }

        @Override
        public F notify(Serializable notification) {
            return (F)this.out.offer((Object)Codec$.MODULE$.encodeServerNotification(notification));
        }
    }

    public static interface Communication<F> {
        public F request(Serializable var1, Decoder<Serializable> var2);

        public F notify(Serializable var1);
    }

    public static class State<F>
    implements Product,
    Serializable {
        private final Map<RequestId, Function1<JsonRpc.Response, F>> pendingRequests;
        private final Map<RequestId, Fiber<F, Throwable, BoxedUnit>> pendingProcessings;
        private final GenConcurrent<F, Throwable> evidence$1;

        public static <F> State<F> apply(Map<RequestId, Function1<JsonRpc.Response, Object>> map, Map<RequestId, Fiber<F, Throwable, BoxedUnit>> map2, GenConcurrent<F, Throwable> genConcurrent) {
            return LowlevelMcpServer$State$.MODULE$.apply(map, map2, genConcurrent);
        }

        public static <F> State<F> unapply(State<F> state) {
            return LowlevelMcpServer$State$.MODULE$.unapply(state);
        }

        public static <F> Map<RequestId, Function1<JsonRpc.Response, Nothing$>> $lessinit$greater$default$1() {
            return LowlevelMcpServer$State$.MODULE$.$lessinit$greater$default$1();
        }

        public static <F> Map<RequestId, Fiber<F, Throwable, BoxedUnit>> $lessinit$greater$default$2() {
            return LowlevelMcpServer$State$.MODULE$.$lessinit$greater$default$2();
        }

        public State(Map<RequestId, Function1<JsonRpc.Response, Object>> pendingRequests, Map<RequestId, Fiber<F, Throwable, BoxedUnit>> pendingProcessings, GenConcurrent<F, Throwable> evidence$1) {
            this.pendingRequests = pendingRequests;
            this.pendingProcessings = pendingProcessings;
            this.evidence$1 = evidence$1;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 382765188, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Map<RequestId, Function1<JsonRpc.Response, F>> map = this.pendingRequests();
            Map<RequestId, Function1<JsonRpc.Response, F>> map2 = state.pendingRequests();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Map<RequestId, Fiber<F, Throwable, BoxedUnit>> map3 = this.pendingProcessings();
            Map<RequestId, Fiber<F, Throwable, BoxedUnit>> map4 = state.pendingProcessings();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            if (1 == n2) {
                return "pendingProcessings";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<RequestId, Function1<JsonRpc.Response, F>> pendingRequests() {
            return this.pendingRequests;
        }

        public Map<RequestId, Fiber<F, Throwable, BoxedUnit>> pendingProcessings() {
            return this.pendingProcessings;
        }

        public State<F> registerRequest(RequestId requestId, Function1<JsonRpc.Response, F> handler) {
            return this.copy((Map<RequestId, Function1<JsonRpc.Response, Object>>)((Map)this.pendingRequests().updated((Object)requestId, handler)), this.copy$default$2(), this.evidence$1);
        }

        public F handleResponse(JsonRpc.Response response) {
            Option option = this.pendingRequests().get((Object)Codec$.MODULE$.fromJsonRpc(response.id()));
            if (option instanceof Some) {
                Function1 handler = (Function1)((Some)option).value();
                return (F)handler.apply((Object)response);
            }
            if (None$.MODULE$.equals(option)) {
                return (F)cats.effect.package$.MODULE$.Concurrent().apply(this.evidence$1, DummyImplicit$.MODULE$.dummyImplicit()).unit();
            }
            throw new MatchError((Object)option);
        }

        public State<F> registerResponseProcessing(RequestId id, Fiber<F, Throwable, BoxedUnit> fiber) {
            Map map = (Map)this.pendingProcessings().updated((Object)id, fiber);
            Map<RequestId, Function1<JsonRpc.Response, F>> map2 = this.copy$default$1();
            return this.copy(map2, map, this.evidence$1);
        }

        public State<F> responseProcessingCompleted(RequestId id) {
            Map map = (Map)this.pendingProcessings().removed((Object)id);
            Map<RequestId, Function1<JsonRpc.Response, F>> map2 = this.copy$default$1();
            return this.copy(map2, map, this.evidence$1);
        }

        public F cancelResponseProcessing(RequestId id) {
            return (F)cats.implicits$.MODULE$.toFunctorOps(cats.implicits$.MODULE$.toTraverseOps((Object)this.pendingProcessings().get((Object)id), (Traverse)cats.implicits$.MODULE$.catsStdInstancesForOption()).traverse(LowlevelMcpServer$::ch$linkyard$mcp$server$LowlevelMcpServer$State$$_$cancelResponseProcessing$$anonfun$1, this.evidence$1), this.evidence$1).void();
        }

        public <F> State<F> copy(Map<RequestId, Function1<JsonRpc.Response, Object>> pendingRequests, Map<RequestId, Fiber<F, Throwable, BoxedUnit>> pendingProcessings, GenConcurrent<F, Throwable> evidence$1) {
            return new State<F>(pendingRequests, pendingProcessings, evidence$1);
        }

        public <F> Map<RequestId, Function1<JsonRpc.Response, F>> copy$default$1() {
            return this.pendingRequests();
        }

        public <F> Map<RequestId, Fiber<F, Throwable, BoxedUnit>> copy$default$2() {
            return this.pendingProcessings();
        }

        public Map<RequestId, Function1<JsonRpc.Response, F>> _1() {
            return this.pendingRequests();
        }

        public Map<RequestId, Fiber<F, Throwable, BoxedUnit>> _2() {
            return this.pendingProcessings();
        }
    }
}

