/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.compiler;

import ch.liquidmind.inflection.BasicTypes;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.grammar.InflectionBaseListener;
import ch.liquidmind.inflection.grammar.InflectionParser;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class AbstractInflectionListener
extends InflectionBaseListener {
    public static final String JAVA_PACKAGE = "java";
    public static final String JAVA_LANG_PACKAGE = "java.lang";
    public static final String CH_LIQUIDMIND_INFLECTION_PACKAGE = "ch.liquidmind.inflection";
    public static final Set<String> BASIC_TYPE_VIEWS = new HashSet<String>();
    private boolean bootstrap;
    private File compilationUnit;
    private CommonTokenStream commonTokenStream;
    private String packageName;
    private Map<String, InflectionResourceCompiled> inflectionResourcesCompiled;

    public AbstractInflectionListener(File compilationUnit, CommonTokenStream commonTokenStream, String packageName, Map<String, InflectionResourceCompiled> inflectionResourcesCompiled, boolean bootstrap) {
        this.compilationUnit = compilationUnit;
        this.commonTokenStream = commonTokenStream;
        this.packageName = packageName;
        this.inflectionResourcesCompiled = inflectionResourcesCompiled;
        this.bootstrap = bootstrap;
    }

    protected String getPackageName(InflectionParser.APackageContext aPackageContext) {
        String packageName = "";
        for (int i = 0; i < aPackageContext.getChildCount(); ++i) {
            ParseTree token;
            ParseTree child = aPackageContext.getChild(i);
            if (child instanceof InflectionParser.IdentifierContext) {
                InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)child;
                token = identifierContext.getChild(0);
            } else {
                token = child;
            }
            packageName = packageName + token.toString();
        }
        return packageName;
    }

    protected String getIdentifierFQName(InflectionParser.IdentifierContext identifierContext) {
        String classViewSimpleName = identifierContext.getChild(0).toString();
        String classViewName = BASIC_TYPE_VIEWS.contains(classViewSimpleName) ? classViewSimpleName : (this.packageName == null ? classViewSimpleName : this.packageName + "." + classViewSimpleName);
        return classViewName;
    }

    protected void stopCompiling() {
        throw new RuntimeException("Cannot compile view file.");
    }

    public File getCompilationUnit() {
        return this.compilationUnit;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public CommonTokenStream getCommonTokenStream() {
        return this.commonTokenStream;
    }

    public void setCommonTokenStream(CommonTokenStream commonTokenStream) {
        this.commonTokenStream = commonTokenStream;
    }

    public Map<String, InflectionResourceCompiled> getInflectionResourcesCompiled() {
        return this.inflectionResourcesCompiled;
    }

    public boolean getBootstrap() {
        return this.bootstrap;
    }

    static {
        BASIC_TYPE_VIEWS.add(BasicTypes.byteView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.shortView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.intView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.longView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.floatView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.doubleView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.charView.getName());
        BASIC_TYPE_VIEWS.add(BasicTypes.booleanView.getName());
    }
}

