/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.compiler;

import ch.liquidmind.inflection.compiler.AbstractInflectionListener;
import ch.liquidmind.inflection.compiler.ClassViewCompiled;
import ch.liquidmind.inflection.compiler.ClassViewErrorListener;
import ch.liquidmind.inflection.compiler.HgroupCompiled;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.compiler.VmapCompiled;
import ch.liquidmind.inflection.grammar.InflectionParser;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;

public class CompilePass1Listener
extends AbstractInflectionListener {
    public CompilePass1Listener(File compilationUnit, CommonTokenStream commonTokenStream, String packageName, Map<String, InflectionResourceCompiled> inflectionResourcesCompiled, boolean bootstrap) {
        super(compilationUnit, commonTokenStream, packageName, inflectionResourcesCompiled, bootstrap);
    }

    @Override
    public void enterClassViewDeclaration(InflectionParser.ClassViewDeclarationContext classViewDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)classViewDeclarationContext.getChild(1);
        String classViewName = this.getIdentifierFQName(identifierContext);
        this.addInflectionResourcesCompiled(identifierContext, new ClassViewCompiled(classViewName));
    }

    @Override
    public void enterVmapDeclaration(InflectionParser.VmapDeclarationContext vmapDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)vmapDeclarationContext.getChild(1);
        String vmapName = this.getIdentifierFQName(identifierContext);
        this.addInflectionResourcesCompiled(identifierContext, new VmapCompiled(vmapName));
    }

    @Override
    public void enterHgroupDeclaration(InflectionParser.HgroupDeclarationContext hgroupDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)hgroupDeclarationContext.getChild(1);
        String hgroupName = this.getIdentifierFQName(identifierContext);
        this.addInflectionResourcesCompiled(identifierContext, new HgroupCompiled(hgroupName));
    }

    private void addInflectionResourcesCompiled(InflectionParser.IdentifierContext identifierContext, InflectionResourceCompiled inflectionResourceCompiled) {
        Set<String> classViewResourceNames = this.getInflectionResourcesCompiled().keySet();
        if (classViewResourceNames.contains(inflectionResourceCompiled.getName())) {
            ClassViewErrorListener.displayError(this.getCompilationUnit(), this.getCommonTokenStream(), identifierContext.start, identifierContext.stop, "Duplicate inflection resource: " + inflectionResourceCompiled.getName() + " already exists.");
            this.stopCompiling();
        }
        this.getInflectionResourcesCompiled().put(inflectionResourceCompiled.getName(), inflectionResourceCompiled);
    }
}

