/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.compiler;

import ch.liquidmind.inflection.ClassViewNotFoundException;
import ch.liquidmind.inflection.DelegatingInflectionResourceLoader;
import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.compiler.AbstractInflectionListener;
import ch.liquidmind.inflection.compiler.ClassViewCompiled;
import ch.liquidmind.inflection.compiler.ClassViewErrorListener;
import ch.liquidmind.inflection.compiler.HgroupCompiled;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.compiler.VmapCompiled;
import ch.liquidmind.inflection.grammar.InflectionParser;
import ch.liquidmind.inflection.model.Aggregation;
import ch.liquidmind.inflection.model.InflectionResource;
import ch.liquidmind.inflection.model.VMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class CompilePass2Listener
extends AbstractInflectionListener {
    public static final String OBJECT_VIEW = "ch.liquidmind.inflection.ObjectView";
    public static final String HGROUP = "ch.liquidmind.inflection.HGroup";
    public static final String PROPERTY = "property";
    public static final String FIELD = "field";
    public static final String DISCRETE = "discrete";
    public static final String COMPOSITE = "composite";
    public static final String DEFAULT_VISITOR = "__default_visitor";
    public static final String MEMBER_TYPE_DEFAULT = "property";
    public static final String AGGREGATION_DEFAULT = "composite";
    private static final Map<String, ClassViewCompiled.MemberViewCompiled.Type> MEMBER_TYPE_MAP = new HashMap<String, ClassViewCompiled.MemberViewCompiled.Type>();
    private static final Map<String, Aggregation> AGGREGATION_MAP = new HashMap<String, Aggregation>();
    private InflectionResourceLoader inflectionResourceLoader;
    private List<String> importedPackages;
    private Map<String, String> importedTypes;
    private ClassViewCompiled currentClassViewCompiled;
    private ClassViewCompiled.MemberViewCompiled currentMemberViewCompiled;
    private VmapCompiled currentVmapCompiled;
    private List<String> currentMappingInflectionViews;
    private List<String> currentMappedVisitors;
    private HgroupCompiled currentHgroupCompiled;

    public CompilePass2Listener(File compilationUnit, CommonTokenStream commonTokenStream, String packageName, Map<String, InflectionResourceCompiled> inflectionResourcesCompiled, InflectionResourceLoader inflectionResourceLoader, boolean bootstrap) {
        super(compilationUnit, commonTokenStream, packageName, inflectionResourcesCompiled, bootstrap);
        this.inflectionResourceLoader = inflectionResourceLoader;
        this.importedPackages = new ArrayList<String>();
        this.importedTypes = new HashMap<String, String>();
        this.currentMappingInflectionViews = new ArrayList<String>();
        this.currentMappedVisitors = new ArrayList<String>();
        this.addImportedPackage(null, packageName);
        this.addImportedPackage(null, "java.lang");
        if (!bootstrap || !packageName.equals("ch.liquidmind.inflection")) {
            this.addImportedPackage(null, "ch.liquidmind.inflection");
        }
    }

    protected void addImportedPackage(InflectionParser.APackageContext aPackageContext, String packageName) {
        if (this.importedPackages.contains(packageName)) {
            ClassViewErrorListener.displayWarning(this.getCompilationUnit(), this.getCommonTokenStream(), aPackageContext.start, aPackageContext.stop, "Package already imported: ignoring duplicate.");
        } else {
            this.importedPackages.add(packageName);
        }
    }

    @Override
    public void enterImportPackageSymbol(InflectionParser.ImportPackageSymbolContext importPackageSymbolContext) {
        InflectionParser.APackageContext aPackageContext = (InflectionParser.APackageContext)importPackageSymbolContext.getChild(0);
        String packageName = this.getPackageName(aPackageContext);
        this.addImportedPackage(aPackageContext, packageName);
    }

    @Override
    public void enterImportTypeSymbol(InflectionParser.ImportTypeSymbolContext importTypeSymbolContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)importTypeSymbolContext.getChild(0);
        String typeName = this.getFQTypeName(typeContext);
        if (!this.typeExists(typeName)) {
            ClassViewErrorListener.displayWarning(this.getCompilationUnit(), this.getCommonTokenStream(), typeContext.start, typeContext.stop, "Unknown symbol: ignoring import.");
        } else {
            this.addImportedType(typeContext, this.getSimpleTypeName(typeName), typeName);
        }
    }

    private String getSimpleTypeName(String typeName) {
        int lastIndex = typeName.lastIndexOf(".");
        String simpleTypeName = lastIndex == -1 ? typeName : typeName.substring(lastIndex + 1);
        return simpleTypeName;
    }

    private boolean typeExists(String typeName) {
        boolean typeExists = false;
        if (this.getInflectionResourcesCompiled().get(typeName) != null || this.inflectionResourceLoader.loadClassView(typeName) != null || this.inflectionResourceLoader.loadVmap(typeName) != null || this.loadClass(typeName) != null) {
            typeExists = true;
        }
        return typeExists;
    }

    private Class<?> loadClass(String className) {
        Class<?> theClass = null;
        try {
            theClass = this.inflectionResourceLoader.findClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return theClass;
    }

    private String getFQTypeName(InflectionParser.TypeContext typeContext) {
        String typeName;
        ParseTree firstChild = typeContext.getChild(0);
        if (firstChild instanceof InflectionParser.APackageContext) {
            typeName = this.getPackageName((InflectionParser.APackageContext)firstChild);
            typeName = typeName + typeContext.getChild(1).toString() + typeContext.getChild(2).getChild(0).getChild(0).toString();
        } else if (firstChild instanceof InflectionParser.SimpleTypeContext) {
            typeName = typeContext.getChild(0).getChild(0).getChild(0).toString();
        } else {
            throw new IllegalStateException("Unexpected type for firstChild: " + firstChild.getClass().getName());
        }
        return typeName;
    }

    private void addImportedType(InflectionParser.TypeContext typeContext, String simpleTypeName, String fqTypeName) {
        if (this.importedTypes.keySet().contains(simpleTypeName)) {
            ClassViewErrorListener.displayWarning(this.getCompilationUnit(), this.getCommonTokenStream(), typeContext.start, typeContext.stop, "Type already imported: ignoring duplicate.");
        } else {
            this.importedTypes.put(simpleTypeName, fqTypeName);
        }
    }

    @Override
    public void enterClassViewDeclaration(InflectionParser.ClassViewDeclarationContext classViewDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)classViewDeclarationContext.getChild(1);
        String classViewName = this.getIdentifierFQName(identifierContext);
        this.currentClassViewCompiled = (ClassViewCompiled)this.getInflectionResourcesCompiled().get(classViewName);
    }

    @Override
    public void enterViewofDeclaration(InflectionParser.ViewofDeclarationContext viewofDeclarationContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)viewofDeclarationContext.getChild(1).getChild(0);
        Class<?> javaClass = this.getClass(typeContext);
        this.currentClassViewCompiled.setJavaClassName(javaClass.getName());
    }

    @Override
    public void enterDefaultSuperDeclaration(InflectionParser.DefaultSuperDeclarationContext defaultSuperDeclarationContext) {
        if (!this.currentClassViewCompiled.getName().equals(OBJECT_VIEW)) {
            this.currentClassViewCompiled.setExtendedClassViewName(OBJECT_VIEW);
        }
    }

    @Override
    public void enterSuperDeclaration(InflectionParser.SuperDeclarationContext superDeclarationContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)superDeclarationContext.getChild(1).getChild(0);
        String extendedClassViewName = this.getInflectionResourceName(typeContext);
        this.currentClassViewCompiled.setExtendedClassViewName(extendedClassViewName);
    }

    @Override
    public void enterMemberViewDeclaration(InflectionParser.MemberViewDeclarationContext memberViewDeclarationContext) {
        this.currentMemberViewCompiled = new ClassViewCompiled.MemberViewCompiled(this.currentClassViewCompiled);
    }

    @Override
    public void exitMemberViewDeclaration(InflectionParser.MemberViewDeclarationContext memberViewDeclarationContext) {
        this.currentClassViewCompiled.getMemberViews().add(this.currentMemberViewCompiled);
    }

    @Override
    public void enterDefaultMemberTypeModifier(InflectionParser.DefaultMemberTypeModifierContext defaultMemberTypeModifierContext) {
        this.currentMemberViewCompiled.setType(MEMBER_TYPE_MAP.get("property"));
    }

    @Override
    public void enterMemberTypeModifier(InflectionParser.MemberTypeModifierContext memberTypeModifierContext) {
        this.currentMemberViewCompiled.setType(MEMBER_TYPE_MAP.get(memberTypeModifierContext.getChild(0).getText()));
    }

    @Override
    public void enterDefaultAggregationModifier(InflectionParser.DefaultAggregationModifierContext defaultAggregationModifierContext) {
        this.currentMemberViewCompiled.setAggregation(AGGREGATION_MAP.get("composite"));
    }

    @Override
    public void enterAggregationModifier(InflectionParser.AggregationModifierContext aggregationModifierContext) {
        this.currentMemberViewCompiled.setAggregation(AGGREGATION_MAP.get(aggregationModifierContext.getChild(0).getText()));
    }

    @Override
    public void enterMemberView(InflectionParser.MemberViewContext memberViewContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)memberViewContext.getChild(0).getChild(0);
        String classViewName = this.getInflectionResourceName(typeContext);
        this.currentMemberViewCompiled.setClassViewName(classViewName);
    }

    @Override
    public void enterMemberViewName(InflectionParser.MemberViewNameContext memberViewNameContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)memberViewNameContext.getChild(0);
        String memberViewName = identifierContext.getChild(0).getText();
        this.currentMemberViewCompiled.setName(memberViewName);
    }

    @Override
    public void enterVmapDeclaration(InflectionParser.VmapDeclarationContext vmapDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)vmapDeclarationContext.getChild(1);
        String vmapName = this.getIdentifierFQName(identifierContext);
        this.currentVmapCompiled = (VmapCompiled)this.getInflectionResourcesCompiled().get(vmapName);
    }

    @Override
    public void enterSuperVmapDeclaration(InflectionParser.SuperVmapDeclarationContext superVmapDeclarationContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)superVmapDeclarationContext.getChild(1).getChild(0);
        String extendedVMapName = this.getInflectionResourceName(typeContext);
        this.currentVmapCompiled.setExtendedVmapName(extendedVMapName);
    }

    @Override
    public void exitMappingDeclaration(InflectionParser.MappingDeclarationContext mappingDeclarationContext) {
        if (this.currentMappingInflectionViews.contains(DEFAULT_VISITOR)) {
            this.currentVmapCompiled.setDefaultVisitorClassName(this.currentMappedVisitors.get(0));
        } else {
            for (String mappingInflectionView : this.currentMappingInflectionViews) {
                for (String currentMappedVisitor : this.currentMappedVisitors) {
                    VmapCompiled.MappingCompiled mappingCompiled = new VmapCompiled.MappingCompiled(this.currentVmapCompiled);
                    mappingCompiled.setInflectionViewName(mappingInflectionView);
                    mappingCompiled.setVisitorClassName(currentMappedVisitor);
                    this.currentVmapCompiled.getClassViewToVisitorMappings().add(mappingCompiled);
                }
            }
        }
        this.currentMappingInflectionViews.clear();
        this.currentMappedVisitors.clear();
    }

    @Override
    public void enterDefaultMappingDeclaration(InflectionParser.DefaultMappingDeclarationContext defaultMappingDeclarationContext) {
        this.currentMappingInflectionViews.add(DEFAULT_VISITOR);
    }

    @Override
    public void enterMappingClassView(InflectionParser.MappingClassViewContext mappingClassViewContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)mappingClassViewContext.getChild(0).getChild(0);
        String mappingClassView = this.getInflectionResourceName(typeContext);
        this.currentMappingInflectionViews.add(mappingClassView);
    }

    @Override
    public void enterMappingMemberView(InflectionParser.MappingMemberViewContext mappingMemberViewContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)mappingMemberViewContext.getChild(0).getChild(0);
        String owningClassView = this.getInflectionResourceName(typeContext);
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)mappingMemberViewContext.getChild(2);
        String memberView = identifierContext.getText();
        this.currentMappingInflectionViews.add(owningClassView + "->" + memberView);
    }

    @Override
    public void enterMappedVisitor(InflectionParser.MappedVisitorContext mappedVisitorContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)mappedVisitorContext.getChild(0).getChild(0);
        Class<?> visitorClass = this.getClass(typeContext);
        this.currentMappedVisitors.add(visitorClass.getName());
    }

    @Override
    public void enterHgroupDeclaration(InflectionParser.HgroupDeclarationContext hgroupDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)hgroupDeclarationContext.getChild(1);
        String hgroupName = this.getIdentifierFQName(identifierContext);
        this.currentHgroupCompiled = (HgroupCompiled)this.getInflectionResourcesCompiled().get(hgroupName);
    }

    @Override
    public void enterSuperHgroupDeclaration(InflectionParser.SuperHgroupDeclarationContext superHgroupDeclarationContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)superHgroupDeclarationContext.getChild(1).getChild(0);
        String extendedHgroupName = this.getInflectionResourceName(typeContext);
        this.currentHgroupCompiled.setExtendedHgroupName(extendedHgroupName);
    }

    @Override
    public void enterNoSuperHgroupDeclaration(InflectionParser.NoSuperHgroupDeclarationContext ctx) {
        if (!this.currentHgroupCompiled.getName().equals(HGROUP)) {
            this.currentHgroupCompiled.setExtendedHgroupName(HGROUP);
        }
    }

    @Override
    public void enterGroupedClassView(InflectionParser.GroupedClassViewContext groupedClassViewContext) {
        InflectionParser.TypeContext typeContext = (InflectionParser.TypeContext)groupedClassViewContext.getChild(0).getChild(0);
        String groupedClassViewName = this.getInflectionResourceName(typeContext);
        this.currentHgroupCompiled.getClassViewNames().add(groupedClassViewName);
    }

    private String getInflectionResourceName(InflectionParser.TypeContext typeContext) {
        String iresName;
        Object iresCompiledOrLinked = this.getInflectionResourceCompiledOrLinked(typeContext);
        if (iresCompiledOrLinked instanceof InflectionResourceCompiled) {
            iresName = ((InflectionResourceCompiled)iresCompiledOrLinked).getName();
        } else if (iresCompiledOrLinked instanceof InflectionResource) {
            iresName = ((InflectionResource)iresCompiledOrLinked).getName();
        } else {
            throw new IllegalStateException("Unexpected type for iresCompiledOrLinked: " + iresCompiledOrLinked.getClass().getName());
        }
        return iresName;
    }

    protected Class<?> getClass(InflectionParser.TypeContext typeContext) {
        ResolverCallback callback = new ResolverCallback<Class<?>>(){

            @Override
            public Class<?> getType(String typeName) {
                Class type = (Class)DelegatingInflectionResourceLoader.BASIC_TYPE_MAP.get(typeName);
                if (type == null) {
                    type = CompilePass2Listener.this.loadClass(typeName);
                }
                return type;
            }
        };
        return (Class)this.resolveType(typeContext, callback);
    }

    protected Object getInflectionResourceCompiledOrLinked(InflectionParser.TypeContext typeContext) {
        ResolverCallback<Object> callback = new ResolverCallback<Object>(){

            @Override
            public Object getType(String typeName) {
                Object type = CompilePass2Listener.this.getInflectionResourcesCompiled().get(typeName);
                if (type == null) {
                    type = CompilePass2Listener.this.loadInflectionResource(typeName);
                }
                if (type == null) {
                    type = CompilePass2Listener.this.loadVmap(typeName);
                }
                return type;
            }
        };
        return this.resolveType(typeContext, callback);
    }

    private InflectionResource loadInflectionResource(String inflectionResourceName) {
        InflectionResource inflectionResource = null;
        try {
            inflectionResource = this.inflectionResourceLoader.loadInflectionResource(inflectionResourceName);
        }
        catch (ClassViewNotFoundException classViewNotFoundException) {
            // empty catch block
        }
        return inflectionResource;
    }

    private VMap loadVmap(String vmapName) {
        VMap vmap = null;
        try {
            vmap = this.inflectionResourceLoader.loadVmap(vmapName);
        }
        catch (ClassViewNotFoundException classViewNotFoundException) {
            // empty catch block
        }
        return vmap;
    }

    private <T> T resolveType(InflectionParser.TypeContext typeContext, ResolverCallback<T> callback) {
        Object resolvedType;
        if (typeContext.getChild(0) instanceof InflectionParser.APackageContext) {
            String fqTypeName = this.getFQTypeName(typeContext);
            resolvedType = callback.getType(fqTypeName);
        } else {
            String simpleTypeName = this.getFQTypeName(typeContext);
            resolvedType = callback.getType(simpleTypeName);
            if (resolvedType == null) {
                resolvedType = this.importedTypes.get(simpleTypeName);
            }
            if (resolvedType == null) {
                String importedPackage;
                Iterator<String> iterator = this.importedPackages.iterator();
                while (iterator.hasNext() && (resolvedType = callback.getType((importedPackage = iterator.next()) + "." + simpleTypeName)) == null) {
                }
            }
            if (resolvedType == null) {
                ClassViewErrorListener.displayError(this.getCompilationUnit(), this.getCommonTokenStream(), typeContext.start, typeContext.stop, "Cannot resolve symbol (did you forget an import?).");
                this.stopCompiling();
            }
        }
        return resolvedType;
    }

    static {
        MEMBER_TYPE_MAP.put("property", ClassViewCompiled.MemberViewCompiled.Type.Property);
        MEMBER_TYPE_MAP.put(FIELD, ClassViewCompiled.MemberViewCompiled.Type.Field);
        AGGREGATION_MAP.put(DISCRETE, Aggregation.None);
        AGGREGATION_MAP.put("composite", Aggregation.Composite);
    }

    private static interface ResolverCallback<T> {
        public T getType(String var1);
    }
}

