/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.demo;

import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.compiler.InflectionCompilerBootstrap;
import ch.liquidmind.inflection.demo.A;
import ch.liquidmind.inflection.demo.Address;
import ch.liquidmind.inflection.demo.Customer;
import ch.liquidmind.inflection.operation.basic.BasicOperations;
import ch.liquidmind.inflection.operation.extended.ExtendedOperations;
import ch.liquidmind.inflection.operation.extended.ValidationError;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Demo {
    public static void main(String[] args) {
        Demo.demo14();
    }

    private static void demo14() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        customer.setLastName(null);
        List<ValidationError> errors = ExtendedOperations.validate((Object)customer, "ch.liquidmind.inflection.demo.FullGroup", "ch.liquidmind.inflection.demo.FullGroupValidation");
        for (ValidationError error : errors) {
            System.out.println(error.getLocation() + ": " + error.getErrorMsg());
        }
    }

    private static void demo13() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        ExtendedOperations.toJson((Object)customer, "ch.liquidmind.inflection.demo.FullGroup", null);
    }

    private static void demo12() {
        Demo.compile();
        A a1 = new A();
        A a2 = new A();
        boolean isEqual = BasicOperations.equals(a1, a2, "ch.liquidmind.inflection.demo.ABGroup", null);
        System.out.println("equals=" + isEqual);
    }

    private static void demo11() {
        Demo.compile();
        Customer customer1 = Demo.createCustomer();
        Customer customer2 = Demo.createCustomer();
        boolean isEqual = BasicOperations.equals((Object)customer1, (Object)customer2, "ch.liquidmind.inflection.demo.FullGroup", null);
        System.out.println("isEqual=" + isEqual);
    }

    private static void demo10() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        int hashcode = BasicOperations.hashcode((Object)customer, "ch.liquidmind.inflection.demo.FullGroup", null);
        System.out.println("hashcode=" + hashcode);
    }

    private static void demo9() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        BasicOperations.toText((Object)customer, "ch.liquidmind.inflection.demo.FullGroup", null);
    }

    private static void demo8() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        BasicOperations.metaModelToText((Object)customer, "ch.liquidmind.inflection.demo.FullGroup", null);
    }

    private static <T> List<T> createList(T ... objects) {
        ArrayList<T> objectsAsList = new ArrayList<T>();
        for (T object : objects) {
            objectsAsList.add(object);
        }
        return objectsAsList;
    }

    private static <T> Set<T> createSet(T ... objects) {
        HashSet<T> objectsAsSet = new HashSet<T>();
        for (T object : objects) {
            objectsAsSet.add(object);
        }
        return objectsAsSet;
    }

    private static <T, V> Map<T, V> createMap(Object[][] keyValuePairs) {
        HashMap<Object, Object> objectsAsMap = new HashMap<Object, Object>();
        for (int i = 0; i < keyValuePairs.length; ++i) {
            Object key = keyValuePairs[i][0];
            Object value = keyValuePairs[i][1];
            objectsAsMap.put(key, value);
        }
        return objectsAsMap;
    }

    private static void compile() {
        InflectionResourceLoader loader = InflectionResourceLoader.getSystemInflectionResourceLoader();
        InflectionCompilerBootstrap.compile(new File[]{new File("./src/main/resources/ch/liquidmind/inflection/Inflection.inflect"), new File("./src/main/resources/ch/liquidmind/inflection/InflectionOperationBasic.inflect"), new File("./src/main/resources/ch/liquidmind/inflection/InflectionOperationExtended.inflect"), new File("./src/main/resources/ch/liquidmind/inflection/demo/Demo.inflect")}, new File("./target/views"), loader);
    }

    private static Customer createCustomer() {
        Address address1 = new Address("Karl Stauffer-Strasse 3", "Zurich", "8008", "Switzerland");
        Address address2 = new Address("Dufourstr. 117", "Zurich", "8008", "Switzerland");
        Customer customer = new Customer("John", "Brush", 42, Customer.Sex.MALE, address1, address2, address2);
        return customer;
    }
}

