/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.model.Aggregation;
import ch.liquidmind.inflection.model.DimensionView;
import ch.liquidmind.inflection.model.FieldView;
import ch.liquidmind.inflection.model.InflectionResource;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Multiplicity;
import ch.liquidmind.inflection.model.PropertyView;
import java.util.ArrayList;
import java.util.List;

public class ClassView<ObjectType>
extends InflectionView
implements InflectionResource {
    public static final String PROPERTY_VIEW = "property";
    public static final String FIELD_VIEW = "field";
    private InflectionResourceLoader inflectionResourceLoader;
    private Class<ObjectType> javaClass;
    private ClassView<?> extendedClassView;
    private List<MemberView> aggregateMemberViews;

    public ClassView(String name, InflectionResourceLoader inflectionResourceLoader) {
        this(name, null, inflectionResourceLoader);
    }

    public ClassView(String name, Class<?> javaClass, InflectionResourceLoader inflectionResourceLoader) {
        this(name, javaClass, null, inflectionResourceLoader);
    }

    public ClassView(String name, Class<?> javaClass, ClassView<?> extendedClassView, InflectionResourceLoader inflectionResourceLoader) {
        super(name);
        this.javaClass = javaClass;
        this.extendedClassView = extendedClassView;
        this.inflectionResourceLoader = inflectionResourceLoader;
    }

    public ClassView<?> forName(String className) {
        return ClassView.forName(className, this.inflectionResourceLoader);
    }

    public static ClassView<?> forName(String className, InflectionResourceLoader loader) {
        return loader.loadClassView(className);
    }

    public InflectionResourceLoader getInflectionResourceLoader() {
        return this.inflectionResourceLoader;
    }

    public String getSimpleName() {
        String simpleName = this.getName();
        int lastIndexOf = this.getName().lastIndexOf(".");
        if (lastIndexOf != -1) {
            simpleName = this.getName().substring(lastIndexOf + 1);
        }
        return simpleName;
    }

    public Class<ObjectType> getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public ClassView<?> getExtendedClassView() {
        return this.extendedClassView;
    }

    public void setExtendedClassView(ClassView<?> extendedClassView) {
        this.extendedClassView = extendedClassView;
    }

    public List<MemberView> getMemberViews() {
        if (this.aggregateMemberViews == null) {
            this.aggregateMemberViews = this.getAggregateMemberViews();
        }
        return this.aggregateMemberViews;
    }

    private List<MemberView> getAggregateMemberViews() {
        ArrayList<MemberView> aggregateMemberViews = new ArrayList<MemberView>();
        if (this.extendedClassView != null) {
            aggregateMemberViews.addAll(this.extendedClassView.getMemberViews());
        }
        ArrayList<MemberView> overridableMemberViews = new ArrayList<MemberView>();
        for (MemberView memberView : this.getDeclaredMemberViews()) {
            for (MemberView aggregateMemberView : aggregateMemberViews) {
                if (!aggregateMemberView.getName().equals(memberView.getName())) continue;
                overridableMemberViews.add(aggregateMemberView);
            }
        }
        aggregateMemberViews.removeAll(overridableMemberViews);
        aggregateMemberViews.addAll(this.getDeclaredMemberViews());
        return aggregateMemberViews;
    }

    public List<MemberView> getDeclaredMemberViews() {
        return this.getChildViews();
    }

    public MemberView getMemberView(String name) {
        MemberView foundView = this.getDeclaredMemberView(name);
        if (foundView == null && this.extendedClassView != null) {
            foundView = this.extendedClassView.getMemberView(name);
        }
        return foundView;
    }

    public MemberView getDeclaredMemberView(String name) {
        MemberView foundView = null;
        for (MemberView memberView : this.getDeclaredMemberViews()) {
            if (!memberView.getName().equals(name)) continue;
            foundView = memberView;
            break;
        }
        return foundView;
    }

    public String toString() {
        String classViewName = this.getName();
        String extendsClause = this.extendedClassView == null ? "" : "    extends " + this.extendedClassView.getName() + CARRIAGE_RETURN;
        Class<ObjectType> javaClass = this.getJavaClass();
        String viewofClause = "    of " + javaClass.getName() + CARRIAGE_RETURN;
        String classHeader = "view " + classViewName + CARRIAGE_RETURN;
        classHeader = classHeader + viewofClause;
        classHeader = classHeader + extendsClause;
        String classBody = "{" + CARRIAGE_RETURN;
        classBody = classBody + this.classViewBodyToString();
        classBody = classBody + "}" + CARRIAGE_RETURN;
        String fullString = classHeader + classBody;
        return fullString;
    }

    private String classViewBodyToString() {
        String classViewBody = "";
        for (MemberView memberView : this.getMemberViews()) {
            classViewBody = classViewBody + this.memberToString(memberView);
        }
        return classViewBody;
    }

    private String memberToString(MemberView memberView) {
        String member = "";
        String memberTypeClause = this.getMemberType(memberView) + " ";
        String typeAndName = memberView.getReferencedClassView().getName() + " " + memberView.getName();
        Aggregation aggregation = memberView.getAggregation();
        String aggregationClause = aggregation == null || aggregation.equals((Object)Aggregation.Composite) ? "composite " : "discrete ";
        String dimensions = this.dimensionsToString(memberView.getDimensionViews());
        member = member + "    " + memberTypeClause + aggregationClause + typeAndName + dimensions + ";" + CARRIAGE_RETURN;
        return member;
    }

    private String dimensionsToString(List<DimensionView> dimensionViews) {
        String dimensions = "";
        for (DimensionView dimensionView : dimensionViews) {
            dimensions = dimensions + this.dimensionToString(dimensionView);
        }
        return dimensions;
    }

    private String dimensionToString(DimensionView dimensionView) {
        String multiplicity = dimensionView.getMultiplicity().equals((Object)Multiplicity.One) ? "1" : "*";
        String isOrdered = dimensionView.isOrdered() ? "o" : "";
        String isMapped = dimensionView.isMapped() ? "m" : "";
        String dimension = "[" + multiplicity + isOrdered + isMapped + "]";
        return dimension;
    }

    private String getMemberType(MemberView memberView) {
        String type;
        if (memberView instanceof PropertyView) {
            type = PROPERTY_VIEW;
        } else if (memberView instanceof FieldView) {
            type = FIELD_VIEW;
        } else {
            throw new IllegalStateException("Unexpected type for memberView: " + memberView.getClass().getName());
        }
        return type;
    }
}

