/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.InflectionResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HGroup
implements InflectionResource {
    private String name;
    private HGroup extendedHGroup;
    private List<ClassView<?>> classViews = new ArrayList();

    public HGroup() {
        this(null);
    }

    public HGroup(String name) {
        this(name, null);
    }

    public HGroup(String name, HGroup extendedHGroup) {
        this.name = name;
        this.extendedHGroup = extendedHGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public HGroup getExtendedHGroup() {
        return this.extendedHGroup;
    }

    public void setExtendedHGroup(HGroup extendedHGroup) {
        this.extendedHGroup = extendedHGroup;
    }

    public List<ClassView<?>> getDeclaredClassViews() {
        return this.classViews;
    }

    public List<ClassView<?>> getClassViews() {
        ArrayList allClassViews = new ArrayList();
        if (this.extendedHGroup != null) {
            allClassViews.addAll(this.extendedHGroup.getClassViews());
        }
        allClassViews.removeAll(this.getDeclaredClassViews());
        allClassViews.addAll(this.getDeclaredClassViews());
        return allClassViews;
    }

    public ClassView<?> getClassView(Class<?> viewableClass) {
        HashMap classViewMap = new HashMap();
        for (ClassView<?> currentClassView : this.getClassViews()) {
            classViewMap.put(currentClassView.getJavaClass(), currentClassView);
        }
        ClassView foundClassView = null;
        for (Class<?> currentViewableClass = viewableClass; currentViewableClass != null && (foundClassView = (ClassView)classViewMap.get(currentViewableClass)) == null; currentViewableClass = currentViewableClass.getSuperclass()) {
        }
        return foundClassView;
    }

    public String toString() {
        String hgroupName = this.name;
        String extendsClause = this.extendedHGroup == null ? "" : "    extends " + this.extendedHGroup.name + CARRIAGE_RETURN;
        String hgroupHeader = "hgroup " + hgroupName + CARRIAGE_RETURN;
        hgroupHeader = hgroupHeader + extendsClause;
        String hgroupBody = "{" + CARRIAGE_RETURN;
        hgroupBody = hgroupBody + this.hgroupBodyToString();
        hgroupBody = hgroupBody + "}" + CARRIAGE_RETURN;
        String fullString = hgroupHeader + hgroupBody;
        return fullString;
    }

    private String hgroupBodyToString() {
        String hgroupBody = "";
        List<ClassView<?>> classViews = this.getClassViews();
        for (int i = 0; i < classViews.size(); ++i) {
            hgroupBody = hgroupBody + "    " + classViews.get(i).getName();
            if (i + 1 < classViews.size()) {
                hgroupBody = hgroupBody + ",";
            }
            hgroupBody = hgroupBody + CARRIAGE_RETURN;
        }
        return hgroupBody;
    }
}

