/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import __java.lang.reflect.__Method;
import ch.liquidmind.inflection.model.Aggregation;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.NoSuchPropertyException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropertyView
extends MemberView {
    public PropertyView() {
    }

    public PropertyView(String name, ClassView<?> owingClassView) {
        super(name, owingClassView);
    }

    public PropertyView(String name, ClassView<?> owingClassView, ClassView<?> referencedClassView, Aggregation aggregation) {
        super(name, owingClassView, referencedClassView, aggregation);
    }

    @Override
    public Type getRawMemberType() {
        Method method = this.getPropertyReadMethod(this.getOwningClassView().getJavaClass());
        return method.getGenericReturnType();
    }

    @Override
    public <T> T getMemberInstance(Object containingObject) {
        Method method = this.getPropertyReadMethod(containingObject.getClass());
        Object memberInstance = __Method.invoke((Method)method, (Object)containingObject, (Object[])new Object[0]);
        return (T)memberInstance;
    }

    private Method getPropertyReadMethod(Class<?> theClass) {
        Method foundMethod = null;
        String getterName = "get" + this.getName().toLowerCase();
        for (Method method : theClass.getMethods()) {
            if (!method.getName().toLowerCase().equals(getterName)) continue;
            foundMethod = method;
            break;
        }
        if (foundMethod == null) {
            throw new NoSuchPropertyException(theClass, this.getName());
        }
        return foundMethod;
    }
}

