/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import __java.lang.__Class;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.InflectionResource;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.VmapInstance;
import ch.liquidmind.inflection.operation.InflectionVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VMap
implements InflectionResource {
    private String name;
    private VMap extendedVMap;
    private Map<InflectionView, Class<InflectionVisitor<?>>> mappings = new HashMap();
    private Class<InflectionVisitor<?>> defaultVisitorClass;

    public VMap() {
        this(null);
    }

    public VMap(String name) {
        this(name, null, null);
    }

    public VMap(String name, VMap extendedVMap, Class<InflectionVisitor<?>> defaultVisitorClass) {
        this.name = name;
        this.extendedVMap = extendedVMap;
        this.defaultVisitorClass = defaultVisitorClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public VMap getExtendedVMap() {
        return this.extendedVMap;
    }

    public void setExtendedVMap(VMap extendedVMap) {
        this.extendedVMap = extendedVMap;
    }

    public void addViewToVisitorClassMapping(InflectionView view, Class<?> visitorClass) {
        this.mappings.put(view, visitorClass);
    }

    public Class<InflectionVisitor<?>> getDeclaredVisitorClass(InflectionView view) {
        return this.mappings.get(view);
    }

    public Class<InflectionVisitor<?>> getVisitorClass(InflectionView view) {
        Class<InflectionVisitor<?>> visitorClass = this.getDeclaredVisitorClass(view);
        if (visitorClass == null && this.extendedVMap != null) {
            visitorClass = this.extendedVMap.getVisitorClass(view);
        }
        return visitorClass;
    }

    public Set<InflectionView> getDeclaredViews() {
        return this.mappings.keySet();
    }

    public Set<InflectionView> getViews() {
        HashSet<InflectionView> aggregateViews = new HashSet<InflectionView>();
        if (this.extendedVMap != null) {
            aggregateViews.addAll(this.extendedVMap.getViews());
        }
        aggregateViews.addAll(this.getDeclaredViews());
        return aggregateViews;
    }

    public Class<InflectionVisitor<?>> getDefaultVisitorClass() {
        Class<InflectionVisitor<?>> resultingClass = this.defaultVisitorClass;
        if (resultingClass == null && this.extendedVMap != null) {
            resultingClass = this.extendedVMap.getDefaultVisitorClass();
        }
        return resultingClass;
    }

    public void setDefaultVisitorClass(Class<InflectionVisitor<?>> defaultVisitorClass) {
        this.defaultVisitorClass = defaultVisitorClass;
    }

    public VmapInstance newInstance() {
        VmapInstance configInstance = new VmapInstance(this);
        for (InflectionView view : this.getViews()) {
            Class<InflectionVisitor<?>> visitorClass = this.getVisitorClass(view);
            InflectionVisitor visitor = (InflectionVisitor)__Class.newInstance(visitorClass);
            configInstance.addViewToVisitorMapping(view, visitor);
        }
        InflectionVisitor visitor = (InflectionVisitor)__Class.newInstance(this.getDefaultVisitorClass());
        configInstance.setDefaultVisitor(visitor);
        return configInstance;
    }

    public String toString() {
        String vmapName = this.name;
        String extendsClause = this.extendedVMap == null ? "" : "    extends " + this.extendedVMap.name + CARRIAGE_RETURN;
        String vmapHeader = "vmap " + vmapName + CARRIAGE_RETURN;
        vmapHeader = vmapHeader + extendsClause;
        String vmapBody = "{" + CARRIAGE_RETURN;
        vmapBody = vmapBody + this.vmapBodyToString();
        vmapBody = vmapBody + "}" + CARRIAGE_RETURN;
        String fullString = vmapHeader + vmapBody;
        return fullString;
    }

    private String vmapBodyToString() {
        String vmapBody = "";
        for (InflectionView view : this.getViews()) {
            String viewName;
            if (view instanceof ClassView) {
                viewName = view.getName();
            } else if (view instanceof MemberView) {
                MemberView memberView = (MemberView)view;
                viewName = memberView.getOwningClassView().getName() + "->" + memberView.getName();
            } else {
                throw new IllegalStateException("Unexpected type for view: " + view.getClass().getName());
            }
            String visitorName = this.getVisitorClass(view).getName();
            vmapBody = vmapBody + "    " + viewName + " " + ":" + " " + visitorName + ";" + CARRIAGE_RETURN;
        }
        return vmapBody;
    }
}

