/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation;

import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.HGroup;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.VMap;
import ch.liquidmind.inflection.model.VmapInstance;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.InflectionVisitor;
import ch.liquidmind.inflection.operation.MemberViewFrame;
import ch.liquidmind.inflection.operation.VisitingTraverser;

public abstract class ConfigurableVisitingTraverser
extends VisitingTraverser {
    public static final String CONFIGURATION_SUFFIX = "Configuration";
    private VmapInstance configurationInstance;

    public ConfigurableVisitingTraverser(HGroup hGroup, VmapInstance configurationInstance) {
        super(hGroup, null);
        this.configurationInstance = configurationInstance;
    }

    @Override
    protected void traverse(ClassViewFrame frame) {
        MemberViewFrame lastMemberViewFrame = this.getLastMemberViewFrame();
        MemberView lastMemberView = lastMemberViewFrame == null ? null : lastMemberViewFrame.getMemberViewPair().getReferenceMemberView();
        this.setVisitor(lastMemberView, frame.getClassViewPair().getReferenceClassView());
        super.traverse(frame);
    }

    @Override
    protected void traverse(MemberViewFrame frame) {
        this.setDefaultVisitor();
        super.traverse(frame);
    }

    @Override
    protected void traverse(DimensionViewFrame frame) {
        this.setDefaultVisitor();
        super.traverse(frame);
    }

    private void setVisitor(MemberView memberView, ClassView<?> classView) {
        InflectionVisitor<VisitingTraverser> visitor = null;
        if (memberView != null) {
            visitor = this.configurationInstance.getVisitor(memberView);
        }
        if (visitor == null) {
            ClassView<?> determiningClassView = memberView == null ? classView : memberView.getReferencedClassView();
            visitor = this.getVisitor(determiningClassView);
        }
        if (visitor == null) {
            visitor = this.configurationInstance.getDefaultVisitor();
        }
        super.setVisitor(visitor);
    }

    private void setDefaultVisitor() {
        super.setVisitor(this.configurationInstance.getDefaultVisitor());
    }

    private InflectionVisitor<VisitingTraverser> getVisitor(ClassView<?> classView) {
        InflectionVisitor<VisitingTraverser> visitor = this.configurationInstance.getVisitor(classView);
        ClassView<?> superClassView = classView.getExtendedClassView();
        if (visitor == null && superClassView != null) {
            visitor = this.configurationInstance.getVisitor(superClassView);
        }
        return visitor;
    }

    protected static VmapInstance getConfiguration(String configurationName) {
        VMap vmap = InflectionResourceLoader.getContextInflectionResourceLoader().loadVmap(configurationName);
        return vmap.newInstance();
    }

    protected VmapInstance getVmapInstance() {
        return this.configurationInstance;
    }
}

