/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.basic;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.model.Aggregation;
import ch.liquidmind.inflection.model.DimensionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.ClassViewPair;
import ch.liquidmind.inflection.operation.DefaultPairingTraverser;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.DimensionViewPair;
import ch.liquidmind.inflection.operation.IdentifiableObjectPair;
import ch.liquidmind.inflection.operation.InflectionViewPair;
import ch.liquidmind.inflection.operation.MemberViewFrame;
import ch.liquidmind.inflection.operation.MemberViewPair;
import ch.liquidmind.inflection.operation.basic.EqualsAbstractVisitor;
import ch.liquidmind.inflection.operation.basic.EqualsTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EqualsDefaultVisitor
extends EqualsAbstractVisitor {
    @Override
    public void visit(ClassViewFrame frame) {
        IdentifiableObject<?, ?> rightObject;
        ClassViewPair pair = frame.getClassViewPair();
        IdentifiableObject<?, ?> leftObject = pair.getLeftObject();
        Boolean isEqual = !this.areBothNullOrNotNull(leftObject, rightObject = pair.getRightObject()) ? Boolean.valueOf(false) : (leftObject == null && rightObject == null ? Boolean.valueOf(true) : (this.getAggregation().equals((Object)Aggregation.Composite) ? this.compositeObjectIsEqual(frame) : this.discreteObjectIsEqual(frame)));
        this.returnEquality(pair, isEqual);
    }

    private Aggregation getAggregation() {
        MemberViewFrame frame = ((EqualsTraverser)this.getTraverser()).getLastMemberViewFrame();
        MemberViewPair pair = frame == null ? null : frame.getMemberViewPair();
        MemberView memberView = pair == null ? null : pair.getReferenceMemberView();
        Aggregation aggregation = memberView == null ? Aggregation.Composite : memberView.getAggregation();
        return aggregation;
    }

    private Boolean compositeObjectIsEqual(ClassViewFrame frame) {
        ClassViewPair pair = frame.getClassViewPair();
        Boolean isEqual = null;
        if (pair.getLeftObject().getObjectId().equals(pair.getRightObject().getObjectId())) {
            isEqual = true;
        } else if (!pair.getLeftClassView().equals(pair.getRightClassView())) {
            isEqual = false;
        } else if (pair.getLeftClassView().getMemberViews().size() != pair.getRightClassView().getMemberViews().size()) {
            isEqual = false;
        } else {
            ((EqualsTraverser)this.getTraverser()).continueTraversal();
            isEqual = ((EqualsTraverser)this.getTraverser()).getCurrentData().getUnequalPairs().size() > 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return isEqual;
    }

    private Boolean discreteObjectIsEqual(ClassViewFrame frame) {
        Object rightObjectId;
        ClassViewPair pair = frame.getClassViewPair();
        Object leftObjectId = pair.getLeftObject().getObjectId();
        Boolean isEqual = leftObjectId.equals(rightObjectId = pair.getRightObject().getObjectId()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return isEqual;
    }

    @Override
    public void visit(MemberViewFrame frame) {
        Boolean isEqual = null;
        MemberViewPair pair = frame.getMemberViewPair();
        ((EqualsTraverser)this.getTraverser()).continueTraversal();
        isEqual = ((EqualsTraverser)this.getTraverser()).getCurrentData().getEqualPairs().size() != 1 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.returnEquality(pair, isEqual);
    }

    @Override
    public void visit(DimensionViewFrame frame) {
        DimensionViewPair pair = frame.getDimensionViewPair();
        IdentifiableObject<?, ?> leftObject = pair.getLeftObject();
        IdentifiableObject<?, ?> rightObject = pair.getRightObject();
        Boolean isEqual = null;
        if (!this.areBothNullOrNotNull(leftObject, rightObject)) {
            isEqual = false;
        } else if (leftObject == null && rightObject == null) {
            isEqual = true;
        } else if (leftObject != null && this.getSize(leftObject.getObject()) != this.getSize(rightObject.getObject())) {
            isEqual = false;
        }
        if (isEqual == null) {
            ((EqualsTraverser)this.getTraverser()).continueTraversal();
            DimensionView referenceDimensionView = pair.getReferenceDimensionView();
            isEqual = referenceDimensionView.isOrdered() ? Boolean.valueOf(this.areOrderingDimensionViewsEqual(leftObject, rightObject)) : (referenceDimensionView.isMapped() ? Boolean.valueOf(this.areMappingDimensionViewsEqual(leftObject, rightObject)) : Boolean.valueOf(this.areUnqualifiedDimensionViewsEqual(leftObject, rightObject)));
        }
        this.returnEquality(pair, isEqual);
    }

    private boolean areOrderingDimensionViewsEqual(IdentifiableObject<?, ?> leftObject, IdentifiableObject<?, ?> rightObject) {
        Set<InflectionViewPair> equalPairs;
        IdentifiableObjectPair equalPair;
        List<?> leftOriginalList = DefaultPairingTraverser.getAsList(leftObject);
        List<?> rightOriginalList = DefaultPairingTraverser.getAsList(rightObject);
        ArrayList leftListOfEqualObjects = new ArrayList();
        ArrayList rightListOfEqualObjects = new ArrayList();
        for (int i = 0; i < leftOriginalList.size() && (equalPair = this.getIdentifiableObjectPair(equalPairs = ((EqualsTraverser)this.getTraverser()).getCurrentData().getEqualPairs(), i)) != null; ++i) {
            leftListOfEqualObjects.add(equalPair.getLeftObject().getObject());
            rightListOfEqualObjects.add(equalPair.getRightObject().getObject());
        }
        return leftOriginalList.equals(leftListOfEqualObjects) && rightOriginalList.equals(rightListOfEqualObjects);
    }

    private boolean areMappingDimensionViewsEqual(IdentifiableObject<?, ?> leftObject, IdentifiableObject<?, ?> rightObject) {
        Map leftOriginalMap = (Map)leftObject.getObject();
        Map rightOriginalMap = (Map)rightObject.getObject();
        HashMap leftMapOfEqualObjects = new HashMap();
        HashMap rightMapOfEqualObjects = new HashMap();
        for (Object key : leftOriginalMap.keySet()) {
            Set<InflectionViewPair> equalPairs = ((EqualsTraverser)this.getTraverser()).getCurrentData().getEqualPairs();
            IdentifiableObjectPair equalPair = this.getIdentifiableObjectPair(equalPairs, key);
            if (equalPair == null) break;
            leftMapOfEqualObjects.put(key, equalPair.getLeftObject().getObject());
            rightMapOfEqualObjects.put(key, equalPair.getRightObject().getObject());
        }
        return leftOriginalMap.equals(leftMapOfEqualObjects) && rightOriginalMap.equals(rightMapOfEqualObjects);
    }

    private boolean areUnqualifiedDimensionViewsEqual(IdentifiableObject<?, ?> leftObject, IdentifiableObject<?, ?> rightObject) {
        Set leftOriginalSet = (Set)leftObject.getObject();
        Set rightOriginalSet = (Set)rightObject.getObject();
        HashSet<Object> leftSetOfEqualObjects = new HashSet<Object>();
        HashSet<Object> rightSetOfEqualObjects = new HashSet<Object>();
        Set<InflectionViewPair> equalPairs = ((EqualsTraverser)this.getTraverser()).getCurrentData().getEqualPairs();
        for (IdentifiableObjectPair identifiableObjectPair : equalPairs) {
            Object leftRawObject = identifiableObjectPair.getLeftObject() == null ? null : (Object)identifiableObjectPair.getLeftObject().getObject();
            Object rightRawObject = identifiableObjectPair.getRightObject() == null ? null : (Object)identifiableObjectPair.getRightObject().getObject();
            leftSetOfEqualObjects.add(leftRawObject);
            rightSetOfEqualObjects.add(rightRawObject);
        }
        return leftOriginalSet.equals(leftSetOfEqualObjects) && rightOriginalSet.equals(rightSetOfEqualObjects);
    }

    private IdentifiableObjectPair getIdentifiableObjectPair(Set<IdentifiableObjectPair> pairs, Object index) {
        IdentifiableObjectPair foundPair = null;
        for (IdentifiableObjectPair pair : pairs) {
            if (!pair.getReferenceIndex().equals(index)) continue;
            foundPair = pair;
            break;
        }
        return foundPair;
    }

    private int getSize(Object collectionMapOrArray) {
        int size;
        if (collectionMapOrArray instanceof Collection) {
            size = ((Collection)collectionMapOrArray).size();
        } else if (collectionMapOrArray instanceof Map) {
            size = ((Map)collectionMapOrArray).size();
        } else if (collectionMapOrArray.getClass().isArray()) {
            size = ((Object[])collectionMapOrArray).length;
        } else {
            throw new IllegalStateException("Unexpected type for collectionMapOrArray: " + collectionMapOrArray.getClass().getName());
        }
        return size;
    }
}

