/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.basic;

import ch.liquidmind.inflection.model.HGroup;
import ch.liquidmind.inflection.model.VmapInstance;
import ch.liquidmind.inflection.operation.LeftGraphTraverser;
import java.util.ArrayList;
import java.util.List;

public class HashCodeTraverser
extends LeftGraphTraverser {
    public static final String DEFAULT_CONFIGURATION = HashCodeTraverser.class.getName() + "Configuration";
    public static final int HASHCODING_PRIME = 31;
    private int compositeHashCode;

    public HashCodeTraverser(HGroup hGroup) {
        this(hGroup, HashCodeTraverser.getConfiguration(DEFAULT_CONFIGURATION));
    }

    public HashCodeTraverser(HGroup hGroup, VmapInstance vmapInstance) {
        super(hGroup, vmapInstance);
    }

    @Override
    protected Object createUserData() {
        return new HashCodes();
    }

    public int getCompositeHashCode() {
        return this.compositeHashCode;
    }

    public void setCompositeHashCode(int compositeHashCode) {
        this.compositeHashCode = compositeHashCode;
    }

    public static class HashCodes {
        private List<Integer> hashCodes = new ArrayList<Integer>();

        public void addHashCode(int hashCode) {
            this.hashCodes.add(hashCode);
        }

        public int getOrderedSum() {
            int orderedSum = 0;
            for (int hashCode : this.hashCodes) {
                orderedSum += hashCode * 31;
            }
            return orderedSum;
        }

        public int getUnorderedSum() {
            int unorderedSum = 0;
            for (int hashCode : this.hashCodes) {
                unorderedSum += hashCode;
            }
            return unorderedSum;
        }
    }
}

