/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.basic;

import java.io.OutputStream;
import java.io.PrintWriter;

public class IndentingPrintWriter
extends PrintWriter {
    public static final int DEFAULT_INDENT_SIZE = 4;
    private int indentLevel;
    private String singleIndentation = "";
    private String currentIndentation;
    private boolean indentationRequired = true;

    public IndentingPrintWriter() {
        this(4);
    }

    public IndentingPrintWriter(OutputStream outputStream) {
        this(outputStream, 4);
    }

    public IndentingPrintWriter(int indentSize) {
        this(null, indentSize);
    }

    public IndentingPrintWriter(OutputStream outputStream, int indentSize) {
        super(outputStream);
        for (int j = 0; j < indentSize; ++j) {
            this.singleIndentation = this.singleIndentation + " ";
        }
        this.updateCurrentIndentation();
    }

    public void increaseIndent() {
        ++this.indentLevel;
        this.updateCurrentIndentation();
    }

    public void decreaseIndent() {
        --this.indentLevel;
        this.updateCurrentIndentation();
    }

    private void updateCurrentIndentation() {
        this.currentIndentation = "";
        for (int i = 0; i < this.indentLevel; ++i) {
            this.currentIndentation = this.currentIndentation + this.singleIndentation;
        }
    }

    @Override
    public void print(String msg) {
        if (this.indentationRequired) {
            this.indentationRequired = false;
            super.print(this.currentIndentation + msg);
        } else {
            super.print(msg);
        }
    }

    @Override
    public void println(String msg) {
        if (this.indentationRequired) {
            this.indentationRequired = false;
            super.println(this.currentIndentation + msg);
        } else {
            super.println(msg);
        }
        this.indentationRequired = true;
    }

    @Override
    public void println() {
        if (this.indentationRequired) {
            this.indentationRequired = false;
            super.println();
        } else {
            super.println();
        }
        this.indentationRequired = true;
    }
}

