/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.basic;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Multiplicity;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.MemberViewFrame;
import ch.liquidmind.inflection.operation.basic.ToTextAbstractVisitor;
import ch.liquidmind.inflection.operation.basic.ToTextTraverser;

public class ToTextDefaultVisitor
extends ToTextAbstractVisitor {
    @Override
    public void visit(ClassViewFrame frame) {
        IdentifiableObject<?, ?> iObject = frame.getClassViewPair().getLeftObject();
        Object objectId = iObject.getObjectId();
        MemberViewFrame lastMemberViewFrame = ((ToTextTraverser)this.getTraverser()).getLastMemberViewFrame();
        MemberView lastMemberView = lastMemberViewFrame == null ? null : lastMemberViewFrame.getMemberViewPair().getLeftMemberView();
        String memberViewName = this.getMemberViewName(lastMemberView);
        String string = memberViewName = memberViewName.isEmpty() ? "" : memberViewName + " ";
        if (frame.getVisitCount() == 0) {
            if (((ToTextTraverser)this.getTraverser()).getMultiplyTraversedObjects().contains(iObject)) {
                this.openBraces();
                this.println(memberViewName + "@id=" + objectId + "");
                ((ToTextTraverser)this.getTraverser()).continueTraversal();
                this.closeBraces();
            } else {
                if (!memberViewName.isEmpty()) {
                    this.println(memberViewName);
                }
                this.openBraces();
                ((ToTextTraverser)this.getTraverser()).continueTraversal();
                this.closeBraces();
            }
        } else {
            this.println(memberViewName + "@ref=" + objectId + "");
        }
    }

    @Override
    public void visit(MemberViewFrame frame) {
        MemberView memberView = frame.getMemberViewPair().getLeftMemberView();
        if (memberView.getDimensionViews().get(0).getMultiplicity().equals((Object)Multiplicity.Many)) {
            this.println(memberView.getName());
        }
        ((ToTextTraverser)this.getTraverser()).continueTraversal();
    }

    @Override
    public void visit(DimensionViewFrame frame) {
        if (frame.getDimensionViewPair().getLeftDimensionView().getMultiplicity().equals((Object)Multiplicity.Many)) {
            this.openBraces();
            ((ToTextTraverser)this.getTraverser()).continueTraversal();
            this.closeBraces();
        } else {
            ((ToTextTraverser)this.getTraverser()).continueTraversal();
        }
    }

    protected void openBraces() {
        this.println("{");
        this.increaseIndent();
    }

    protected void closeBraces() {
        this.decreaseIndent();
        this.println("}");
    }
}

