/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.extended;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Multiplicity;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.ClassViewPair;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.InflectionViewFrame;
import ch.liquidmind.inflection.operation.MemberViewFrame;
import ch.liquidmind.inflection.operation.extended.JsonAbstractVisitor;
import ch.liquidmind.inflection.operation.extended.JsonTraverser;

public class JsonDefaultVisitor
extends JsonAbstractVisitor {
    public static final String VERSION = "JSON for Inflection V1.0";

    @Override
    public void visit(ClassViewFrame frame) {
        ClassViewPair pair = frame.getClassViewPair();
        IdentifiableObject<?, ?> iObject = pair.getLeftObject();
        Object objectId = iObject.getObjectId();
        MemberViewFrame lastMemberViewFrame = ((JsonTraverser)this.getTraverser()).getLastMemberViewFrame();
        MemberView lastMemberView = lastMemberViewFrame == null ? null : lastMemberViewFrame.getMemberViewPair().getLeftMemberView();
        String memberViewName = this.getMemberViewName(lastMemberView);
        String string = memberViewName = memberViewName.isEmpty() ? "" : memberViewName + " ";
        if (frame.getVisitCount() == 0) {
            boolean isReferencable = ((JsonTraverser)this.getTraverser()).getMultiplyTraversedObjects().contains(iObject);
            if (!isReferencable && !memberViewName.isEmpty()) {
                this.println("\"" + memberViewName + "\" :");
            }
            this.openCurlyBraces();
            if (isReferencable) {
                this.println(memberViewName + "\"@id\" : " + objectId + ",");
            }
            if (lastMemberView == null) {
                this.println("\"@version\" : \"JSON for Inflection V1.0\",");
                this.println("\"@hgroup\" : \"" + ((JsonTraverser)this.getTraverser()).getHGroup().getName() + "\",");
            }
            this.print("\"@class\" : \"" + pair.getLeftObject().getObject().getClass().getName() + "\"");
            this.printCommaIfNecessaryAfterMetaData();
            ((JsonTraverser)this.getTraverser()).continueTraversal();
            this.closeCurlyBraces();
        } else {
            this.openCurlyBraces();
            this.println(memberViewName + "\"@ref\" : " + objectId);
            this.closeCurlyBraces();
        }
        this.printCommaIfNecessary();
    }

    @Override
    public void visit(MemberViewFrame frame) {
        MemberView memberView = frame.getMemberViewPair().getLeftMemberView();
        if (memberView.getDimensionViews().get(0).getMultiplicity().equals((Object)Multiplicity.Many)) {
            this.println("\"" + memberView.getName() + "\" :");
        }
        ((JsonTraverser)this.getTraverser()).continueTraversal();
        this.printCommaIfNecessary();
    }

    @Override
    public void visit(DimensionViewFrame frame) {
        if (frame.getDimensionViewPair().getLeftDimensionView().getMultiplicity().equals((Object)Multiplicity.Many)) {
            this.openBrackets();
            ((JsonTraverser)this.getTraverser()).continueTraversal();
            this.closeBrackets();
            this.printCommaIfNecessary();
        } else {
            ((JsonTraverser)this.getTraverser()).continueTraversal();
        }
    }

    protected void openCurlyBraces() {
        this.println("{");
        this.increaseIndent();
    }

    protected void closeCurlyBraces() {
        this.decreaseIndent();
        this.print("}");
    }

    protected void openBrackets() {
        this.println("[");
        this.increaseIndent();
    }

    protected void closeBrackets() {
        this.decreaseIndent();
        this.print("]");
    }

    private void printCommaIfNecessary() {
        Object frame = ((JsonTraverser)this.getTraverser()).getCurrentFrame();
        if (((InflectionViewFrame)frame).getPositionCurrent() < ((InflectionViewFrame)frame).getPositionMax() - 1) {
            this.println(",");
        } else {
            this.println();
        }
    }

    private void printCommaIfNecessaryAfterMetaData() {
        Object frame = ((JsonTraverser)this.getTraverser()).getCurrentFrame();
        if (frame instanceof ClassViewFrame) {
            ClassViewFrame classViewFrame = (ClassViewFrame)frame;
            if (classViewFrame.getClassViewPair().getLeftClassView().getMemberViews().size() > 0) {
                this.println(",");
            } else {
                this.println();
            }
        }
    }
}

