/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.extended;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.extended.ValidateAbstractVisitor;
import ch.liquidmind.inflection.operation.extended.ValidateTraverser;
import ch.liquidmind.inflection.operation.extended.ValidationError;

public class ValidateAlphaNumericVisitor
extends ValidateAbstractVisitor {
    private static final String ALPHA_NUMERIC_PATTERN = "^[a-zA-Z0-9]*$";

    @Override
    public void visit(ClassViewFrame frame) {
        String leftRawObjectAsString;
        Object leftRawObject;
        IdentifiableObject<?, ?> leftObject = frame.getClassViewPair().getLeftObject();
        if (leftObject != null && (leftRawObject = leftObject.getObject()) instanceof String && !(leftRawObjectAsString = (String)leftRawObject).matches(ALPHA_NUMERIC_PATTERN)) {
            ((ValidateTraverser)this.getTraverser()).getValidationErrors().add(new ValidationError(this.getLocation(), "Value must be alphanumeric ([a-zA-Z0-9])."));
        }
    }
}

