/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection;

import ch.liquidmind.inflection.ClassViewNotFoundException;
import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.model.ClassView;

public class BasicTypes {
    private static final String VIEW = "View";
    public static final ClassView<?> byteView = BasicTypes.getClassView(Byte.TYPE);
    public static final ClassView<?> shortView = BasicTypes.getClassView(Short.TYPE);
    public static final ClassView<?> intView = BasicTypes.getClassView(Integer.TYPE);
    public static final ClassView<?> longView = BasicTypes.getClassView(Long.TYPE);
    public static final ClassView<?> floatView = BasicTypes.getClassView(Float.TYPE);
    public static final ClassView<?> doubleView = BasicTypes.getClassView(Double.TYPE);
    public static final ClassView<?> charView = BasicTypes.getClassView(Character.TYPE);
    public static final ClassView<?> booleanView = BasicTypes.getClassView(Boolean.TYPE);

    private static ClassView<?> getClassView(Class<?> javaType) {
        return BasicTypes.getClassView(javaType.getSimpleName());
    }

    private static ClassView<?> getClassView(String name) {
        try {
            return InflectionResourceLoader.getSystemInflectionResourceLoader().loadClassView(name + VIEW);
        }
        catch (ClassViewNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

