/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection;

import ch.liquidmind.inflection.ClassViewNotFoundException;
import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.model.InflectionResource;
import java.io.InputStream;

public class DelegatingInflectionResourceLoader
extends InflectionResourceLoader {
    private ClassLoader delegateClassLoader;

    private DelegatingInflectionResourceLoader(Void unused) {
        super(unused);
        this.delegateClassLoader = ClassLoader.getSystemClassLoader();
    }

    protected DelegatingInflectionResourceLoader(InflectionResourceLoader parentInflectionResourceLoader, ClassLoader delegateClassLoader) {
        super(parentInflectionResourceLoader);
        this.delegateClassLoader = delegateClassLoader;
    }

    @Override
    public InflectionResource findInflectionResource(String name) {
        InflectionResourceCompiled resourceCompiled = this.getInflectionResourceCompiled(name);
        InflectionResource resource = this.defineInflectionResource(resourceCompiled);
        return resource;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.delegateClassLoader.loadClass(name);
    }

    private InflectionResourceCompiled getInflectionResourceCompiled(String name) {
        Object inflectionResourceCompiled;
        String resourceName = name.replace(".", "/") + ".ires";
        InputStream inputStream = this.delegateClassLoader.getResourceAsStream(resourceName);
        try {
            inflectionResourceCompiled = InflectionResourceCompiled.load(inputStream);
        }
        catch (Throwable t) {
            throw new ClassViewNotFoundException("Unable to load class view: " + name, t);
        }
        return inflectionResourceCompiled;
    }
}

