/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.ObjectIDProvider;
import ch.liquidmind.inflection.SequentialObjectIDProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IdentifiableObjectPool {
    public static final ObjectIDProvider<?> DEFAULT_OBJECT_ID_PROVIDER = new SequentialObjectIDProvider();
    private static ThreadLocal<IdentifiableObjectPool> identifiableObjectPool = new ThreadLocal();
    private Map<Integer, Set<IdentifiableObject<?, ?>>> hashcodeToIdentifiableObjectSetMap = new HashMap();
    private Map<Object, Object> objectIdToObjectMap = new HashMap<Object, Object>();
    private ObjectIDProvider<?> objectIdProvider = DEFAULT_OBJECT_ID_PROVIDER;

    private IdentifiableObjectPool() {
    }

    public static IdentifiableObjectPool getIdentifiableObjectPool() {
        if (identifiableObjectPool.get() == null) {
            identifiableObjectPool.set(new IdentifiableObjectPool());
        }
        return identifiableObjectPool.get();
    }

    public <ObjectIdType, ObjectType> IdentifiableObject<ObjectIdType, ObjectType> getIdentifiableObject(ObjectType object) {
        IdentifiableObject<ObjectIdType, ObjectType> identifiableObject = object == null ? null : this.getIdentifiableObjectInternal(object);
        return identifiableObject;
    }

    private <ObjectIdType, ObjectType> IdentifiableObject<ObjectIdType, ObjectType> getIdentifiableObjectInternal(ObjectType object) {
        IdentifiableObject<Object, ObjectType> identifiableObject = null;
        Set<IdentifiableObject<?, ?>> identifiableObjects = this.hashcodeToIdentifiableObjectSetMap.get(object.hashCode());
        if (identifiableObjects == null) {
            identifiableObjects = new HashSet();
            this.hashcodeToIdentifiableObjectSetMap.put(object.hashCode(), identifiableObjects);
        }
        if ((identifiableObject = this.getIdentifiableObject(identifiableObjects, object)) == null) {
            Object objectId = this.objectIdProvider.createObjectID();
            identifiableObject = new IdentifiableObject(objectId, object);
            identifiableObjects.add(identifiableObject);
            this.objectIdToObjectMap.put(identifiableObject.getObjectId(), identifiableObject.getObject());
        }
        return identifiableObject;
    }

    private <ObjectIdType, ObjectType> IdentifiableObject<ObjectIdType, ObjectType> getIdentifiableObject(Set<IdentifiableObject<?, ?>> identifiableObjects, Object object) {
        IdentifiableObject<?, ?> foundObject = null;
        for (IdentifiableObject<?, ?> identifiableObject : identifiableObjects) {
            if (identifiableObject.getObject() != object) continue;
            foundObject = identifiableObject;
            break;
        }
        return foundObject;
    }

    public <ObjectIdType, ObjectType> ObjectType getObject(ObjectIdType objectId) {
        return (ObjectType)this.objectIdToObjectMap.get(objectId);
    }

    public void clear() {
        this.hashcodeToIdentifiableObjectSetMap.clear();
        this.objectIdToObjectMap.clear();
    }

    public ObjectIDProvider<?> getObjectIdProvider() {
        return this.objectIdProvider;
    }

    public void setObjectIdProvider(ObjectIDProvider<?> objectIdProvider) {
        this.objectIdProvider = objectIdProvider;
    }
}

