/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection;

import __java.lang.__Class;
import __java.lang.reflect.__Constructor;
import ch.liquidmind.inflection.ClassViewFormatError;
import ch.liquidmind.inflection.ClassViewNotFoundException;
import ch.liquidmind.inflection.DelegatingInflectionResourceLoader;
import ch.liquidmind.inflection.compiler.ClassViewCompiled;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.compiler.TaxonomyCompiled;
import ch.liquidmind.inflection.compiler.VisitorsCompiled;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.FieldView;
import ch.liquidmind.inflection.model.InflectionResource;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.PropertyView;
import ch.liquidmind.inflection.model.Taxonomy;
import ch.liquidmind.inflection.model.Visitors;
import ch.liquidmind.inflection.operation.InflectionVisitor;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public abstract class InflectionResourceLoader {
    private static InflectionResourceLoader systemInflectionResourceLoader;
    private static ThreadLocal<InflectionResourceLoader> contextInflectionResourceLoader;
    public static final Map<String, Class<?>> BASIC_TYPE_MAP;
    public static final Map<String, ClassView<?>> BASIC_TYPE_VIEW_MAP;
    private InflectionResourceLoader parentInflectionResourceLoader;
    private Map<String, InflectionResource> inflectionResourceMap = new HashMap<String, InflectionResource>();

    private static void initBasicTypeViewMap(InflectionResourceLoader loader) {
        ClassView byteClassView = new ClassView(Byte.TYPE + "View", Byte.TYPE, loader);
        ClassView shortClassView = new ClassView(Short.TYPE + "View", Short.TYPE, loader);
        ClassView intClassView = new ClassView(Integer.TYPE + "View", Integer.TYPE, loader);
        ClassView longClassView = new ClassView(Long.TYPE + "View", Long.TYPE, loader);
        ClassView floatClassView = new ClassView(Float.TYPE + "View", Float.TYPE, loader);
        ClassView doubleClassView = new ClassView(Double.TYPE + "View", Double.TYPE, loader);
        ClassView charClassView = new ClassView(Character.TYPE + "View", Character.TYPE, loader);
        ClassView booleanClassView = new ClassView(Boolean.TYPE + "View", Boolean.TYPE, loader);
        BASIC_TYPE_VIEW_MAP.put(byteClassView.getName(), byteClassView);
        BASIC_TYPE_VIEW_MAP.put(shortClassView.getName(), shortClassView);
        BASIC_TYPE_VIEW_MAP.put(intClassView.getName(), intClassView);
        BASIC_TYPE_VIEW_MAP.put(longClassView.getName(), longClassView);
        BASIC_TYPE_VIEW_MAP.put(floatClassView.getName(), floatClassView);
        BASIC_TYPE_VIEW_MAP.put(doubleClassView.getName(), doubleClassView);
        BASIC_TYPE_VIEW_MAP.put(charClassView.getName(), charClassView);
        BASIC_TYPE_VIEW_MAP.put(booleanClassView.getName(), booleanClassView);
    }

    InflectionResourceLoader(Void unused) {
        InflectionResourceLoader.initBasicTypeViewMap(this);
    }

    protected InflectionResourceLoader() {
        this.parentInflectionResourceLoader = InflectionResourceLoader.getSystemInflectionResourceLoader();
    }

    public InflectionResourceLoader(InflectionResourceLoader parentInflectionResourceLoader) {
        if (parentInflectionResourceLoader == null) {
            throw new IllegalArgumentException("Parent InflectionResourceLoader cannot be null.");
        }
        this.parentInflectionResourceLoader = parentInflectionResourceLoader;
    }

    public static InflectionResourceLoader getSystemInflectionResourceLoader() {
        if (systemInflectionResourceLoader == null) {
            Constructor voidConstructor = __Class.getDeclaredConstructor(Void.class, (Class[])new Class[0]);
            voidConstructor.setAccessible(true);
            Void voidObject = (Void)__Constructor.newInstance((Constructor)voidConstructor, (Object[])new Object[0]);
            Constructor loaderConstructor = __Class.getDeclaredConstructor(DelegatingInflectionResourceLoader.class, (Class[])new Class[]{Void.class});
            loaderConstructor.setAccessible(true);
            systemInflectionResourceLoader = (InflectionResourceLoader)__Constructor.newInstance((Constructor)loaderConstructor, (Object[])new Object[]{voidObject});
        }
        return systemInflectionResourceLoader;
    }

    public static InflectionResourceLoader getContextInflectionResourceLoader() {
        if (contextInflectionResourceLoader.get() == null) {
            contextInflectionResourceLoader.set(InflectionResourceLoader.getSystemInflectionResourceLoader());
        }
        return contextInflectionResourceLoader.get();
    }

    public static void setContextInflectionResourceLoader(InflectionResourceLoader inflectionResourceLoader) {
        contextInflectionResourceLoader.set(inflectionResourceLoader);
    }

    public <ObjectType> ClassView<ObjectType> loadClassView(String name) {
        return (ClassView)this.loadInflectionResource(name);
    }

    public Visitors loadVisitors(String name) {
        return (Visitors)this.loadInflectionResource(name);
    }

    public Taxonomy loadTaxonomy(String name) {
        return (Taxonomy)this.loadInflectionResource(name);
    }

    public InflectionResource loadInflectionResource(String name) {
        InflectionResource resource = this.findLoadedInflectionResource(name);
        if (resource == null && this.parentInflectionResourceLoader != null) {
            try {
                resource = this.parentInflectionResourceLoader.loadInflectionResource(name);
            }
            catch (ClassViewNotFoundException classViewNotFoundException) {
                // empty catch block
            }
        }
        if (resource == null) {
            resource = BASIC_TYPE_VIEW_MAP.get(name);
        }
        if (resource == null) {
            resource = this.findInflectionResource(name);
        }
        return resource;
    }

    public InflectionResource findLoadedInflectionResource(String name) {
        return this.inflectionResourceMap.get(name);
    }

    public InflectionResource findInflectionResource(String name) {
        throw new ClassViewNotFoundException();
    }

    private Class<?> findClassWithExceptionHandling(String name) {
        try {
            Class<?> theClass = BASIC_TYPE_MAP.get(name);
            if (theClass == null) {
                theClass = this.findClass(name);
            }
            return theClass;
        }
        catch (ClassNotFoundException e) {
            throw new ClassViewFormatError("Cannot find class referenced by class view.", e);
        }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    public final void resolveInflectionResource(InflectionResource inflectionResource) {
        throw new UnsupportedOperationException();
    }

    public InflectionResource defineInflectionResource(InflectionResourceCompiled inflectionResourceCompiled) {
        InflectionResource resource;
        if (inflectionResourceCompiled instanceof ClassViewCompiled) {
            resource = this.defineClassView((ClassViewCompiled)inflectionResourceCompiled);
        } else if (inflectionResourceCompiled instanceof VisitorsCompiled) {
            resource = this.defineVisitors((VisitorsCompiled)inflectionResourceCompiled);
        } else if (inflectionResourceCompiled instanceof TaxonomyCompiled) {
            resource = this.defineTaxonomy((TaxonomyCompiled)inflectionResourceCompiled);
        } else {
            throw new IllegalStateException("Unexpected type for inflectionResourceCompiled: " + inflectionResourceCompiled.getClass().getName());
        }
        return resource;
    }

    private ClassView<?> defineClassView(ClassViewCompiled classViewCompiled) {
        ClassView classView = new ClassView(classViewCompiled.getName(), this);
        this.inflectionResourceMap.put(classView.getName(), classView);
        classView.setJavaClass(this.findClassWithExceptionHandling(classViewCompiled.getJavaClassName()));
        if (classViewCompiled.getExtendedClassViewName() != null) {
            classView.setExtendedClassView(this.loadClassView(classViewCompiled.getExtendedClassViewName()));
        }
        for (ClassViewCompiled.MemberViewCompiled memberViewCompiled : classViewCompiled.getMemberViews()) {
            MemberView memberView;
            if (memberViewCompiled.getType().equals((Object)ClassViewCompiled.MemberViewCompiled.Type.Property)) {
                memberView = new PropertyView(memberViewCompiled.getName(), classView, this.loadClassView(memberViewCompiled.getClassViewName()), memberViewCompiled.getAggregation());
            } else if (memberViewCompiled.getType().equals((Object)ClassViewCompiled.MemberViewCompiled.Type.Field)) {
                memberView = new FieldView(memberViewCompiled.getName(), classView, this.loadClassView(memberViewCompiled.getClassViewName()), memberViewCompiled.getAggregation());
            } else {
                throw new IllegalStateException("Unexpected value for memberViewCompiled.getType(): " + (Object)((Object)memberViewCompiled.getType()));
            }
            classView.getDeclaredMemberViews().add(memberView);
        }
        return classView;
    }

    private Visitors defineVisitors(VisitorsCompiled visitorsCompiled) {
        Visitors visitors = new Visitors(visitorsCompiled.getName());
        this.inflectionResourceMap.put(visitors.getName(), visitors);
        if (visitorsCompiled.getExtendedVisitorsName() != null) {
            visitors.setExtendedVisitors(this.loadVisitors(visitorsCompiled.getExtendedVisitorsName()));
        }
        for (VisitorsCompiled.MappingCompiled mappingCompiled : visitorsCompiled.getClassViewToVisitorMappings()) {
            InflectionView inflectionView;
            String inflectionViewName = mappingCompiled.getInflectionViewName();
            if (inflectionViewName.contains("->")) {
                String owningClassViewName = inflectionViewName.substring(0, inflectionViewName.indexOf("->"));
                String simpleMemberViewName = inflectionViewName.substring(inflectionViewName.indexOf("->") + 2);
                ClassView owningClassView = this.loadClassView(owningClassViewName);
                inflectionView = owningClassView.getMemberView(simpleMemberViewName);
            } else {
                inflectionView = this.loadClassView(inflectionViewName);
            }
            Class<?> visitorClass = this.findClassWithExceptionHandling(mappingCompiled.getVisitorClassName());
            visitors.addViewToVisitorClassMapping(inflectionView, visitorClass);
        }
        if (visitorsCompiled.getDefaultVisitorClassName() != null) {
            Class<InflectionVisitor<?>> defaultVisitorClass = this.findClassWithExceptionHandling(visitorsCompiled.getDefaultVisitorClassName());
            visitors.setDefaultVisitorClass(defaultVisitorClass);
        }
        return visitors;
    }

    private Taxonomy defineTaxonomy(TaxonomyCompiled taxonomyCompiled) {
        Taxonomy taxonomy = new Taxonomy(taxonomyCompiled.getName());
        this.inflectionResourceMap.put(taxonomy.getName(), taxonomy);
        if (taxonomyCompiled.getExtendedTaxonomyName() != null) {
            taxonomy.setExtendedTaxonomy(this.loadTaxonomy(taxonomyCompiled.getExtendedTaxonomyName()));
        }
        for (String classViewName : taxonomyCompiled.getClassViewNames()) {
            taxonomy.getDeclaredClassViews().add(this.loadClassView(classViewName));
        }
        return taxonomy;
    }

    static {
        contextInflectionResourceLoader = new ThreadLocal();
        BASIC_TYPE_MAP = new HashMap();
        BASIC_TYPE_VIEW_MAP = new HashMap();
        BASIC_TYPE_MAP.put(Byte.TYPE.getName(), Byte.TYPE);
        BASIC_TYPE_MAP.put(Short.TYPE.getName(), Short.TYPE);
        BASIC_TYPE_MAP.put(Integer.TYPE.getName(), Integer.TYPE);
        BASIC_TYPE_MAP.put(Long.TYPE.getName(), Long.TYPE);
        BASIC_TYPE_MAP.put(Float.TYPE.getName(), Float.TYPE);
        BASIC_TYPE_MAP.put(Double.TYPE.getName(), Double.TYPE);
        BASIC_TYPE_MAP.put(Boolean.TYPE.getName(), Boolean.TYPE);
        BASIC_TYPE_MAP.put(Character.TYPE.getName(), Character.TYPE);
    }
}

