/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.compiler;

import ch.liquidmind.inflection.compiler.AbstractInflectionListener;
import ch.liquidmind.inflection.compiler.ClassViewCompiled;
import ch.liquidmind.inflection.compiler.ClassViewErrorListener;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.compiler.TaxonomyCompiled;
import ch.liquidmind.inflection.compiler.VisitorsCompiled;
import ch.liquidmind.inflection.grammar.InflectionParser;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;

public class CompilePass1Listener
extends AbstractInflectionListener {
    public CompilePass1Listener(File compilationUnit, CommonTokenStream commonTokenStream, String packageName, Map<String, InflectionResourceCompiled> inflectionResourcesCompiled, boolean bootstrap) {
        super(compilationUnit, commonTokenStream, packageName, inflectionResourcesCompiled, bootstrap);
    }

    @Override
    public void enterClassViewDeclaration(InflectionParser.ClassViewDeclarationContext classViewDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)classViewDeclarationContext.getChild(1);
        String classViewName = this.getIdentifierFQName(identifierContext);
        this.addInflectionResourcesCompiled(identifierContext, new ClassViewCompiled(classViewName));
    }

    @Override
    public void enterVisitorsDeclaration(InflectionParser.VisitorsDeclarationContext visitorsDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)visitorsDeclarationContext.getChild(1);
        String visitorsName = this.getIdentifierFQName(identifierContext);
        this.addInflectionResourcesCompiled(identifierContext, new VisitorsCompiled(visitorsName));
    }

    @Override
    public void enterTaxonomyDeclaration(InflectionParser.TaxonomyDeclarationContext taxonomyDeclarationContext) {
        InflectionParser.IdentifierContext identifierContext = (InflectionParser.IdentifierContext)taxonomyDeclarationContext.getChild(1);
        String taxonomyName = this.getIdentifierFQName(identifierContext);
        this.addInflectionResourcesCompiled(identifierContext, new TaxonomyCompiled(taxonomyName));
    }

    private void addInflectionResourcesCompiled(InflectionParser.IdentifierContext identifierContext, InflectionResourceCompiled inflectionResourceCompiled) {
        Set<String> classViewResourceNames = this.getInflectionResourcesCompiled().keySet();
        if (classViewResourceNames.contains(inflectionResourceCompiled.getName())) {
            ClassViewErrorListener.displayError(this.getCompilationUnit(), this.getCommonTokenStream(), identifierContext.start, identifierContext.stop, "Duplicate inflection resource: " + inflectionResourceCompiled.getName() + " already exists.");
            this.stopCompiling();
        }
        this.getInflectionResourcesCompiled().put(inflectionResourceCompiled.getName(), inflectionResourceCompiled);
    }
}

