/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.compiler;

import __java.io.__Closeable;
import __java.io.__FileInputStream;
import __org.antlr.v4.runtime.__ANTLRInputStream;
import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.compiler.CompilePass1Listener;
import ch.liquidmind.inflection.compiler.CompilePass2Listener;
import ch.liquidmind.inflection.compiler.InflectionErrorListener;
import ch.liquidmind.inflection.compiler.InflectionResourceCompiled;
import ch.liquidmind.inflection.compiler.PackageListener;
import ch.liquidmind.inflection.grammar.InflectionLexer;
import ch.liquidmind.inflection.grammar.InflectionParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class InflectionCompiler {
    private static Map<String, InflectionResourceCompiled> inflectionResourcesCompiled;
    private static List<ParsedCompilationUnit> parsedCompilationUnits;

    public static void compile(File[] compilationUnits, File targetLocation) {
        InflectionCompiler.compile(compilationUnits, targetLocation, InflectionResourceLoader.getContextInflectionResourceLoader(), false);
    }

    public static void compile(File[] compilationUnits, File targetLocation, InflectionResourceLoader inflectionResourceLoader) {
        InflectionCompiler.compile(compilationUnits, targetLocation, inflectionResourceLoader, false);
    }

    static void compile(File[] compilationUnits, File targetLocation, InflectionResourceLoader inflectionResourceLoader, boolean bootstrap) {
        inflectionResourcesCompiled = new HashMap<String, InflectionResourceCompiled>();
        parsedCompilationUnits = new ArrayList<ParsedCompilationUnit>();
        InflectionCompiler.parse(compilationUnits, bootstrap);
        for (ParsedCompilationUnit parsedCompilationUnit : parsedCompilationUnits) {
            InflectionCompiler.compilePass1(parsedCompilationUnit, bootstrap);
        }
        for (ParsedCompilationUnit parsedCompilationUnit : parsedCompilationUnits) {
            InflectionCompiler.compilePass2(parsedCompilationUnit, inflectionResourceLoader, bootstrap);
        }
        for (InflectionResourceCompiled inflectionResourceCompiled : inflectionResourcesCompiled.values()) {
            InflectionResourceCompiled.save(targetLocation, inflectionResourceCompiled);
        }
    }

    private static void compilePass1(ParsedCompilationUnit parsedCompilationUnit, boolean bootstrap) {
        ParseTreeWalker walker = new ParseTreeWalker();
        CompilePass1Listener listener = new CompilePass1Listener(parsedCompilationUnit.getCompilationUnit(), parsedCompilationUnit.getTokens(), parsedCompilationUnit.getPackageName(), inflectionResourcesCompiled, bootstrap);
        walker.walk((ParseTreeListener)listener, parsedCompilationUnit.getTree());
    }

    private static void compilePass2(ParsedCompilationUnit parsedCompilationUnit, InflectionResourceLoader inflectionResourceLoader, boolean bootstrap) {
        ParseTreeWalker walker = new ParseTreeWalker();
        CompilePass2Listener listener = new CompilePass2Listener(parsedCompilationUnit.getCompilationUnit(), parsedCompilationUnit.getTokens(), parsedCompilationUnit.getPackageName(), inflectionResourcesCompiled, inflectionResourceLoader, bootstrap);
        walker.walk((ParseTreeListener)listener, parsedCompilationUnit.getTree());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parse(File[] compilationUnits, boolean bootstrap) {
        for (File compilationUnit : compilationUnits) {
            FileInputStream compilationUnitIs = __FileInputStream.__new((File)compilationUnit);
            ParsedCompilationUnit parsedCompilationUnit = new ParsedCompilationUnit();
            parsedCompilationUnits.add(parsedCompilationUnit);
            try {
                InflectionCompiler.parse(compilationUnit, compilationUnitIs, parsedCompilationUnit, bootstrap);
            }
            finally {
                __Closeable.close((Closeable)compilationUnitIs);
            }
        }
    }

    private static void parse(File compilationUnit, InputStream inputStream, ParsedCompilationUnit parsedCompilationUnit, boolean bootstrap) {
        ANTLRInputStream antlrInputStream = __ANTLRInputStream.__new((InputStream)inputStream);
        InflectionLexer lexer = new InflectionLexer((CharStream)antlrInputStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        InflectionParser parser = new InflectionParser((TokenStream)tokens);
        parser.removeErrorListeners();
        InflectionErrorListener errorListener = new InflectionErrorListener(compilationUnit);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        InflectionParser.CompilationUnitContext tree = parser.compilationUnit();
        if (errorListener.syntaxErrorOccured()) {
            throw new RuntimeException("Syntax error in input stream: cannot parse view definitions.");
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        PackageListener packageListener = new PackageListener(compilationUnit, tokens, bootstrap);
        walker.walk((ParseTreeListener)packageListener, (ParseTree)tree);
        parsedCompilationUnit.setCompilationUnit(compilationUnit);
        parsedCompilationUnit.setTokens(tokens);
        parsedCompilationUnit.setTree((ParseTree)tree);
        parsedCompilationUnit.setPackageName(packageListener.getPackageName());
    }

    private static class ParsedCompilationUnit {
        private File compilationUnit;
        private CommonTokenStream tokens;
        private ParseTree tree;
        private String packageName;

        private ParsedCompilationUnit() {
        }

        public File getCompilationUnit() {
            return this.compilationUnit;
        }

        public void setCompilationUnit(File compilationUnit) {
            this.compilationUnit = compilationUnit;
        }

        public CommonTokenStream getTokens() {
            return this.tokens;
        }

        public void setTokens(CommonTokenStream tokens) {
            this.tokens = tokens;
        }

        public ParseTree getTree() {
            return this.tree;
        }

        public void setTree(ParseTree tree) {
            this.tree = tree;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }
}

