/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.demo2;

import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.compiler.InflectionCompilerBootstrap;
import ch.liquidmind.inflection.demo2.Account;
import ch.liquidmind.inflection.demo2.AccountType;
import ch.liquidmind.inflection.demo2.Address;
import ch.liquidmind.inflection.demo2.Customer;
import ch.liquidmind.inflection.demo2.Customer2;
import ch.liquidmind.inflection.demo2.Gender;
import ch.liquidmind.inflection.operation.basic.BasicOperations;
import ch.liquidmind.inflection.operation.extended.ExtendedOperations;
import ch.liquidmind.inflection.operation.extended.ValidationError;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Demo {
    public static void main(String[] args) {
        Demo.demo8();
    }

    private static void demo8() {
        Demo.compile();
        Customer2 customer = Demo.createCustomer2();
        Customer2 customerSynched = (Customer2)ExtendedOperations.synchronize((Object)customer, null, "ch.liquidmind.inflection.demo2.FullTaxonomy2", "ch.liquidmind.inflection.operation.extended.SynchronizeTraverserVisitors");
        BasicOperations.toText((Object)customerSynched, "ch.liquidmind.inflection.demo2.FullTaxonomy3", "ch.liquidmind.inflection.demo2.DemoToTextMap");
    }

    private static void demo7() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        customer.setLastName(null);
        List<ValidationError> errors = ExtendedOperations.validate((Object)customer, "ch.liquidmind.inflection.demo2.FullTaxonomy", "ch.liquidmind.inflection.demo2.DemoValidation");
        for (ValidationError error : errors) {
            System.out.println(error.getLocation() + ": " + error.getErrorMsg());
        }
    }

    private static void demo6() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        BasicOperations.toText((Object)customer, "ch.liquidmind.inflection.demo2.FullTaxonomy", "ch.liquidmind.inflection.demo2.DemoToTextWithAddressVisitorMap");
    }

    private static void demo5() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        customer.getAddresses().get(0).setCountry("Iceland");
        int hashcode = BasicOperations.hashcode((Object)customer, "ch.liquidmind.inflection.demo2.FullTaxonomy", "ch.liquidmind.inflection.operation.basic.HashCodeTraverserVisitors");
        System.out.println("hashcode=" + hashcode);
    }

    private static void demo4() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        ExtendedOperations.toJson((Object)customer, "ch.liquidmind.inflection.demo2.FullTaxonomy", "ch.liquidmind.inflection.demo2.DemoToJsonMap");
    }

    private static void demo3() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        customer.getAddresses().add(customer.getAddresses().get(0));
        BasicOperations.toText((Object)customer, "ch.liquidmind.inflection.demo2.FullTaxonomy", "ch.liquidmind.inflection.demo2.DemoToTextMap");
    }

    private static void demo2() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        BasicOperations.toText((Object)customer, "ch.liquidmind.inflection.demo2.FullTaxonomy", "ch.liquidmind.inflection.demo2.DemoToTextMap");
    }

    private static void demo1() {
        Demo.compile();
        Customer customer = Demo.createCustomer();
        BasicOperations.toText((Object)customer, "ch.liquidmind.inflection.demo2.SimpleTaxonomy", "ch.liquidmind.inflection.demo2.DemoToTextMap");
    }

    private static void compile() {
        InflectionResourceLoader loader = InflectionResourceLoader.getSystemInflectionResourceLoader();
        InflectionCompilerBootstrap.compile(new File[]{new File("./src/main/resources/ch/liquidmind/inflection/Inflection.inflect"), new File("./src/main/resources/ch/liquidmind/inflection/InflectionOperationBasic.inflect"), new File("./src/main/resources/ch/liquidmind/inflection/InflectionOperationExtended.inflect"), new File("./src/main/resources/ch/liquidmind/inflection/demo/Demo2.inflect")}, new File("./target/views"), loader);
    }

    private static Customer createCustomer() {
        Address[] addresses = new Address[]{new Address("Karl Stauffer-Strasse 3", "Zurich", "8008", "Switzerland"), new Address("Dufourstr. 117", "Zurich", "8008", "Switzerland")};
        Account[] accounts = new Account[]{new Account("402593-40", "CH87 0483 5040 2593 4000 0", "CRESCHZZ80A", AccountType.Checking, "4835")};
        Customer customer = new Customer("John", "Brush", 42, Gender.Male, new ArrayList<Address>(Arrays.asList(addresses)), new ArrayList<Account>(Arrays.asList(accounts)));
        return customer;
    }

    private static Customer2 createCustomer2() {
        Address[] addresses = new Address[]{new Address("Karl Stauffer-Strasse 3", "Zurich", "8008", "Switzerland"), new Address("Dufourstr. 117", "Zurich", "8008", "Switzerland")};
        Account[] accounts = new Account[]{new Account("402593-40", "CH87 0483 5040 2593 4000 0", "CRESCHZZ80A", AccountType.Checking, "4835")};
        Customer2 customer = new Customer2("John", "Brush", 42, Gender.Male, new ArrayList<Address>(Arrays.asList(addresses)), new ArrayList<Account>(Arrays.asList(accounts)));
        return customer;
    }
}

