/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import ch.liquidmind.inflection.model.Aggregation;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.DimensionView;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.Multiplicity;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class MemberView
extends InflectionView {
    public static final Aggregation DEFAULT_AGGREGATION = Aggregation.Composite;
    private ClassView<?> referencedClassView;
    private Aggregation aggregation;

    public MemberView() {
    }

    public MemberView(String name, ClassView<?> owingClassView) {
        this(name, owingClassView, null, DEFAULT_AGGREGATION);
    }

    public MemberView(String name, ClassView<?> owingClassView, ClassView<?> referencedClassView, Aggregation aggregation) {
        super(name);
        this.referencedClassView = referencedClassView;
        this.setOwningClassView(owingClassView);
        MemberView.createDimensionViews(this.getDimensionViews(), this, true, this.getRawMemberType());
        this.aggregation = aggregation;
    }

    public static void createDimensionViews(List<DimensionView> dimensionViews, MemberView owningMemberView, boolean isStatic, Type type) {
        if (type instanceof Class) {
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, (Class)type);
        } else if (type instanceof ParameterizedType) {
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, (ParameterizedType)type);
        } else if (type instanceof GenericArrayType) {
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, (GenericArrayType)type);
        } else if (type instanceof TypeVariable) {
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, (TypeVariable)type);
        } else if (type instanceof WildcardType) {
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, (WildcardType)type);
        } else {
            throw new IllegalStateException("Unexpected type for type: " + type.getClass().getName());
        }
    }

    private static void createDimensionViews(List<DimensionView> dimensionViews, MemberView owningMemberView, boolean isStatic, Class<?> theClass) {
        if (Collection.class.isAssignableFrom(theClass) || Map.class.isAssignableFrom(theClass)) {
            boolean isOrdered = List.class.isAssignableFrom(theClass);
            boolean isMapped = Map.class.isAssignableFrom(theClass);
            dimensionViews.add(new DimensionView(isOrdered, isMapped, false, Multiplicity.Many, theClass, owningMemberView));
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, Object.class);
        } else if (theClass.isArray()) {
            MemberView.addDimensionView(dimensionViews, new DimensionView(true, false, isStatic, Multiplicity.Many, theClass, owningMemberView));
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, theClass.getComponentType());
        } else {
            MemberView.addDimensionView(dimensionViews, new DimensionView(false, false, isStatic, Multiplicity.One, theClass, owningMemberView));
        }
    }

    private static void createDimensionViews(List<DimensionView> dimensionViews, MemberView owningMemberView, boolean isStatic, ParameterizedType parameterizedType) {
        Class rawType = (Class)parameterizedType.getRawType();
        Type[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (Collection.class.isAssignableFrom(rawType) || Map.class.isAssignableFrom(rawType)) {
            Type type;
            boolean isMapped;
            boolean isOrdered = List.class.isAssignableFrom(rawType);
            if (Map.class.isAssignableFrom(rawType)) {
                isMapped = true;
                type = actualTypeArgs[1];
            } else {
                isMapped = false;
                type = actualTypeArgs[0];
            }
            MemberView.addDimensionView(dimensionViews, new DimensionView(isOrdered, isMapped, false, Multiplicity.Many, rawType, owningMemberView));
            MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, type);
        } else {
            MemberView.addDimensionView(dimensionViews, new DimensionView(false, false, false, Multiplicity.One, rawType, owningMemberView));
        }
    }

    private static void createDimensionViews(List<DimensionView> dimensionViews, MemberView owningMemberView, boolean isStatic, GenericArrayType genericArrayType) {
        MemberView.addDimensionView(dimensionViews, new DimensionView(true, false, isStatic, Multiplicity.Many, genericArrayType, owningMemberView));
        MemberView.createDimensionViews(dimensionViews, owningMemberView, isStatic, genericArrayType.getGenericComponentType());
    }

    private static void createDimensionViews(List<DimensionView> dimensionViews, MemberView owningMemberView, boolean isStatic, TypeVariable<?> typeVariable) {
        MemberView.addDimensionView(dimensionViews, new DimensionView(false, false, isStatic, Multiplicity.One, typeVariable, owningMemberView));
    }

    private static void createDimensionViews(List<DimensionView> dimensionViews, MemberView owningMemberView, boolean isStatic, WildcardType wildcardType) {
        MemberView.addDimensionView(dimensionViews, new DimensionView(false, false, isStatic, Multiplicity.One, wildcardType, owningMemberView));
    }

    private static void addDimensionView(List<DimensionView> dimensionViews, DimensionView dimensionView) {
        if (dimensionViews.size() > 0 && dimensionView.getMultiplicity().equals((Object)Multiplicity.One)) {
            return;
        }
        dimensionViews.add(dimensionView);
    }

    public abstract Type getRawMemberType();

    public abstract <T> T getMemberInstance(Object var1);

    public abstract void setMemberInstance(Object var1, Object var2);

    public ClassView<?> getOwningClassView() {
        return (ClassView)this.getParentView();
    }

    public void setOwningClassView(ClassView<?> owingClassView) {
        this.setParentView(owingClassView);
    }

    public List<DimensionView> getDimensionViews() {
        return this.getChildViews();
    }

    public DimensionView getInitialDimensionView() {
        return this.getDimensionViews().get(0);
    }

    public DimensionView getNextDimensionView(DimensionView dimensionView) {
        DimensionView nextDimensionView = null;
        int currentViewIndex = this.getDimensionViews().lastIndexOf(dimensionView);
        int nextViewIndex = currentViewIndex + 1;
        if (nextViewIndex <= this.getDimensionViews().size() - 1) {
            nextDimensionView = this.getDimensionViews().get(nextViewIndex);
        }
        return nextDimensionView;
    }

    public InflectionView getNextView(DimensionView dimensionView) {
        InflectionView nextView = this.getNextDimensionView(dimensionView);
        if (nextView == null) {
            nextView = this.referencedClassView;
        }
        return nextView;
    }

    public ClassView<?> getReferencedClassView() {
        return this.referencedClassView;
    }

    public void setReferencedClassView(ClassView<?> referencedClassView) {
        this.referencedClassView = referencedClassView;
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
    }
}

