/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import __java.lang.reflect.__Method;
import ch.liquidmind.inflection.model.Aggregation;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.NoSuchPropertyException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropertyView
extends MemberView {
    public PropertyView() {
    }

    public PropertyView(String name, ClassView<?> owingClassView) {
        super(name, owingClassView);
    }

    public PropertyView(String name, ClassView<?> owingClassView, ClassView<?> referencedClassView, Aggregation aggregation) {
        super(name, owingClassView, referencedClassView, aggregation);
    }

    @Override
    public Type getRawMemberType() {
        Method method = this.getPropertyReadMethod(this.getOwningClassView().getJavaClass());
        return method.getGenericReturnType();
    }

    @Override
    public <T> T getMemberInstance(Object containingObject) {
        Method method = this.getPropertyReadMethod(containingObject.getClass());
        Object memberInstance = __Method.invoke((Method)method, (Object)containingObject, (Object[])new Object[0]);
        return (T)memberInstance;
    }

    private Method getPropertyReadMethod(Class<?> theClass) {
        Method foundMethod = null;
        String getterName1 = "get" + this.getName().toLowerCase();
        String getterName2 = "is" + this.getName().toLowerCase();
        for (Method method : theClass.getMethods()) {
            String methodName = method.getName().toLowerCase();
            if (!methodName.equals(getterName1) && !methodName.equals(getterName2)) continue;
            foundMethod = method;
            break;
        }
        if (foundMethod == null) {
            throw new NoSuchPropertyException(theClass, this.getName());
        }
        return foundMethod;
    }

    private Method getPropertyWriteMethod(Class<?> theClass) {
        Method foundMethod = null;
        String setterName = "set" + this.getName().toLowerCase();
        for (Method method : theClass.getMethods()) {
            String methodName = method.getName().toLowerCase();
            if (!methodName.equals(setterName)) continue;
            foundMethod = method;
            break;
        }
        if (foundMethod == null) {
            throw new NoSuchPropertyException(theClass, this.getName());
        }
        return foundMethod;
    }

    @Override
    public void setMemberInstance(Object containingObject, Object value) {
        Method method = this.getPropertyWriteMethod(containingObject.getClass());
        __Method.invoke((Method)method, (Object)containingObject, (Object[])new Object[]{value});
    }
}

