/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.InflectionResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Taxonomy
implements InflectionResource {
    private String name;
    private Taxonomy extendedTaxonomy;
    private List<ClassView<?>> classViews = new ArrayList();

    public Taxonomy() {
        this(null);
    }

    public Taxonomy(String name) {
        this(name, null);
    }

    public Taxonomy(String name, Taxonomy extendedTaxonomy) {
        this.name = name;
        this.extendedTaxonomy = extendedTaxonomy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Taxonomy getExtendedTaxonomy() {
        return this.extendedTaxonomy;
    }

    public void setExtendedTaxonomy(Taxonomy extendedTaxonomy) {
        this.extendedTaxonomy = extendedTaxonomy;
    }

    public List<ClassView<?>> getDeclaredClassViews() {
        return this.classViews;
    }

    public List<ClassView<?>> getClassViews() {
        ArrayList allClassViews = new ArrayList();
        if (this.extendedTaxonomy != null) {
            allClassViews.addAll(this.extendedTaxonomy.getClassViews());
        }
        allClassViews.removeAll(this.getDeclaredClassViews());
        allClassViews.addAll(this.getDeclaredClassViews());
        return allClassViews;
    }

    public ClassView<?> getClassView(Class<?> viewableClass) {
        HashMap classViewMap = new HashMap();
        for (ClassView<?> currentClassView : this.getClassViews()) {
            classViewMap.put(currentClassView.getJavaClass(), currentClassView);
        }
        ClassView foundClassView = null;
        for (Class<?> currentViewableClass = viewableClass; currentViewableClass != null && (foundClassView = (ClassView)classViewMap.get(currentViewableClass)) == null; currentViewableClass = currentViewableClass.getSuperclass()) {
        }
        return foundClassView;
    }

    public String toString() {
        String taxonomyName = this.name;
        String extendsClause = this.extendedTaxonomy == null ? "" : "    extends " + this.extendedTaxonomy.name + CARRIAGE_RETURN;
        String taxonomyHeader = "taxonomy " + taxonomyName + CARRIAGE_RETURN;
        taxonomyHeader = taxonomyHeader + extendsClause;
        String taxonomyBody = "{" + CARRIAGE_RETURN;
        taxonomyBody = taxonomyBody + this.taxonomyBodyToString();
        taxonomyBody = taxonomyBody + "}" + CARRIAGE_RETURN;
        String fullString = taxonomyHeader + taxonomyBody;
        return fullString;
    }

    private String taxonomyBodyToString() {
        String taxonomyBody = "";
        List<ClassView<?>> classViews = this.getClassViews();
        for (int i = 0; i < classViews.size(); ++i) {
            taxonomyBody = taxonomyBody + "    " + classViews.get(i).getName();
            if (i + 1 < classViews.size()) {
                taxonomyBody = taxonomyBody + ",";
            }
            taxonomyBody = taxonomyBody + CARRIAGE_RETURN;
        }
        return taxonomyBody;
    }
}

