/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.model;

import __java.lang.__Class;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.InflectionResource;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.VisitorsInstance;
import ch.liquidmind.inflection.operation.InflectionVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Visitors
implements InflectionResource {
    private String name;
    private Visitors extendedVisitors;
    private Map<InflectionView, Class<InflectionVisitor<?>>> mappings = new HashMap();
    private Class<InflectionVisitor<?>> defaultVisitorClass;

    public Visitors() {
        this(null);
    }

    public Visitors(String name) {
        this(name, null, null);
    }

    public Visitors(String name, Visitors extendedVisitors, Class<InflectionVisitor<?>> defaultVisitorClass) {
        this.name = name;
        this.extendedVisitors = extendedVisitors;
        this.defaultVisitorClass = defaultVisitorClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Visitors getExtendedVisitors() {
        return this.extendedVisitors;
    }

    public void setExtendedVisitors(Visitors extendedVisitors) {
        this.extendedVisitors = extendedVisitors;
    }

    public void addViewToVisitorClassMapping(InflectionView view, Class<?> visitorClass) {
        this.mappings.put(view, visitorClass);
    }

    public Class<InflectionVisitor<?>> getDeclaredVisitorClass(InflectionView view) {
        return this.mappings.get(view);
    }

    public Class<InflectionVisitor<?>> getVisitorClass(InflectionView view) {
        Class<InflectionVisitor<?>> visitorClass = this.getDeclaredVisitorClass(view);
        if (visitorClass == null && this.extendedVisitors != null) {
            visitorClass = this.extendedVisitors.getVisitorClass(view);
        }
        return visitorClass;
    }

    public Set<InflectionView> getDeclaredViews() {
        return this.mappings.keySet();
    }

    public Set<InflectionView> getViews() {
        HashSet<InflectionView> aggregateViews = new HashSet<InflectionView>();
        if (this.extendedVisitors != null) {
            aggregateViews.addAll(this.extendedVisitors.getViews());
        }
        aggregateViews.addAll(this.getDeclaredViews());
        return aggregateViews;
    }

    public Class<InflectionVisitor<?>> getDefaultVisitorClass() {
        Class<InflectionVisitor<?>> resultingClass = this.defaultVisitorClass;
        if (resultingClass == null && this.extendedVisitors != null) {
            resultingClass = this.extendedVisitors.getDefaultVisitorClass();
        }
        return resultingClass;
    }

    public void setDefaultVisitorClass(Class<InflectionVisitor<?>> defaultVisitorClass) {
        this.defaultVisitorClass = defaultVisitorClass;
    }

    public VisitorsInstance newInstance() {
        VisitorsInstance configInstance = new VisitorsInstance(this);
        for (InflectionView view : this.getViews()) {
            Class<InflectionVisitor<?>> visitorClass = this.getVisitorClass(view);
            InflectionVisitor visitor = (InflectionVisitor)__Class.newInstance(visitorClass);
            configInstance.addViewToVisitorMapping(view, visitor);
        }
        InflectionVisitor visitor = (InflectionVisitor)__Class.newInstance(this.getDefaultVisitorClass());
        configInstance.setDefaultVisitor(visitor);
        return configInstance;
    }

    public String toString() {
        String visitorsName = this.name;
        String extendsClause = this.extendedVisitors == null ? "" : "    extends " + this.extendedVisitors.name + CARRIAGE_RETURN;
        String visitorsHeader = "visitors " + visitorsName + CARRIAGE_RETURN;
        visitorsHeader = visitorsHeader + extendsClause;
        String visitorsBody = "{" + CARRIAGE_RETURN;
        visitorsBody = visitorsBody + this.visitorsBodyToString();
        visitorsBody = visitorsBody + "}" + CARRIAGE_RETURN;
        String fullString = visitorsHeader + visitorsBody;
        return fullString;
    }

    private String visitorsBodyToString() {
        String visitorsBody = "";
        for (InflectionView view : this.getViews()) {
            String viewName;
            if (view instanceof ClassView) {
                viewName = view.getName();
            } else if (view instanceof MemberView) {
                MemberView memberView = (MemberView)view;
                viewName = memberView.getOwningClassView().getName() + "->" + memberView.getName();
            } else {
                throw new IllegalStateException("Unexpected type for view: " + view.getClass().getName());
            }
            String visitorName = this.getVisitorClass(view).getName();
            visitorsBody = visitorsBody + "    " + viewName + " " + ":" + " " + visitorName + ";" + CARRIAGE_RETURN;
        }
        return visitorsBody;
    }
}

