/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.IdentifiableObjectPool;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.DimensionView;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Multiplicity;
import ch.liquidmind.inflection.model.Taxonomy;
import ch.liquidmind.inflection.operation.CallStack;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.ClassViewPair;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.DimensionViewPair;
import ch.liquidmind.inflection.operation.IdentifiableObjectFrame;
import ch.liquidmind.inflection.operation.IdentifiableObjectPair;
import ch.liquidmind.inflection.operation.InflectionTraverser;
import ch.liquidmind.inflection.operation.InflectionViewFrame;
import ch.liquidmind.inflection.operation.InflectionViewPair;
import ch.liquidmind.inflection.operation.MemberViewFrame;
import ch.liquidmind.inflection.operation.MemberViewPair;
import ch.liquidmind.inflection.operation.VisitedObjectPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTraverser
implements InflectionTraverser {
    private Map<VisitedObjectPair, VisitedObjectPair> visitedObjectPairs = new HashMap<VisitedObjectPair, VisitedObjectPair>();
    private CallStack callStack = new CallStack();
    private Taxonomy taxonomy;
    private static Set<Class<?>> JAVA_BASIC_TYPES = new HashSet();

    public AbstractTraverser(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    public ClassViewPair createRootClassViewPair(Object leftRootObject, Object rightRootObject, Class<?> defaultRootClass) {
        ClassView<?> leftClassView = this.taxonomy.getClassView(AbstractTraverser.getRootClass(leftRootObject, defaultRootClass));
        ClassView<?> rightClassView = this.taxonomy.getClassView(AbstractTraverser.getRootClass(rightRootObject, defaultRootClass));
        IdentifiableObject leftObject = this.getIdentifiableObjectPool().getIdentifiableObject(leftRootObject);
        IdentifiableObject rightObject = this.getIdentifiableObjectPool().getIdentifiableObject(rightRootObject);
        ClassViewPair classViewPair = new ClassViewPair(leftClassView, rightClassView, (Integer)1, (Integer)1, (Integer)0, (Integer)0, null, null, leftObject, rightObject);
        return classViewPair;
    }

    private static Class<?> getRootClass(Object object, Class<?> defaultRootClass) {
        Class<?> rootClass = object != null ? object.getClass() : defaultRootClass;
        return rootClass;
    }

    @Override
    public void traverse(IdentifiableObjectPair identifiableObjectPair) {
        this.visitedObjectPairs.clear();
        this.traverse(identifiableObjectPair, 0, 1);
    }

    private void traverse(InflectionViewPair inflectionViewPair, int positionCurrent, int positionMax) {
        InflectionViewFrame frame = this.createFrame(inflectionViewPair, positionCurrent, positionMax);
        this.callStack.push(frame);
        if (inflectionViewPair instanceof ClassViewPair) {
            this.traverse((ClassViewFrame)frame);
        } else if (inflectionViewPair instanceof MemberViewPair) {
            this.traverse((MemberViewFrame)frame);
        } else if (inflectionViewPair instanceof DimensionViewPair) {
            this.traverse((DimensionViewFrame)frame);
        } else {
            throw new IllegalStateException("Unexpected type for inflectionViewPair: " + inflectionViewPair.getClass().getName());
        }
        this.callStack.pop();
    }

    protected abstract void traverse(ClassViewFrame var1);

    protected abstract void traverse(MemberViewFrame var1);

    protected abstract void traverse(DimensionViewFrame var1);

    @Override
    public void continueTraversal() {
        Object frame = this.getCurrentFrame();
        if (frame instanceof ClassViewFrame) {
            this.continueTraversal((ClassViewFrame)frame);
        } else if (frame instanceof MemberViewFrame) {
            this.continueTraversal((MemberViewFrame)frame);
        } else if (frame instanceof DimensionViewFrame) {
            this.continueTraversal((DimensionViewFrame)frame);
        } else {
            throw new IllegalStateException("Unexpected type for frame: " + frame.getClass().getName());
        }
    }

    private void continueTraversal(ClassViewFrame classViewFrame) {
        List<MemberViewPair> memberViewPairs = this.createMemberViewPairs(classViewFrame.getClassViewPair());
        int positionMax = memberViewPairs.size();
        for (int positionCurrent = 0; positionCurrent < positionMax; ++positionCurrent) {
            this.traverse(memberViewPairs.get(positionCurrent), positionCurrent, positionMax);
        }
    }

    private void continueTraversal(MemberViewFrame memberViewFrame) {
        DimensionViewPair firstDimensionViewPair = this.createInitialDimensionViewPair(memberViewFrame.getMemberViewPair());
        this.traverse(firstDimensionViewPair, 0, 1);
    }

    private void continueTraversal(DimensionViewFrame dimensionViewFrame) {
        List<IdentifiableObjectPair> identifiableObjectPairs = this.createIdentifiableObjectPairs(dimensionViewFrame.getDimensionViewPair());
        int positionMax = identifiableObjectPairs.size();
        for (int positionCurrent = 0; positionCurrent < positionMax; ++positionCurrent) {
            this.traverse(identifiableObjectPairs.get(positionCurrent), positionCurrent, positionMax);
        }
    }

    protected List<MemberViewPair> createMemberViewPairs(ClassViewPair classViewPair) {
        List<MemberView> leftMemberViews = this.getMemberViews(classViewPair.getLeftClassView());
        List<MemberView> rightMemberViews = this.getMemberViews(classViewPair.getRightClassView());
        List<MemberView> allMemberViews = this.union(leftMemberViews, rightMemberViews);
        ArrayList<MemberViewPair> memberViewPairs = new ArrayList<MemberViewPair>();
        for (MemberView memberView : allMemberViews) {
            boolean leftMemberViewExists = leftMemberViews.contains(memberView);
            boolean rightMemberViewExists = rightMemberViews.contains(memberView);
            MemberView leftMemberView = leftMemberViewExists ? memberView : null;
            MemberView rightMemberView = rightMemberViewExists ? memberView : null;
            Integer leftPositionMax = leftMemberViewExists ? Integer.valueOf(leftMemberViews.size()) : null;
            Integer rightPositionMax = rightMemberViewExists ? Integer.valueOf(rightMemberViews.size()) : null;
            Integer leftPositionCurrent = leftMemberViewExists ? Integer.valueOf(leftMemberViews.indexOf(memberView)) : null;
            Integer rightPositionCurrent = rightMemberViewExists ? Integer.valueOf(rightMemberViews.indexOf(memberView)) : null;
            memberViewPairs.add(new MemberViewPair(leftMemberView, rightMemberView, leftPositionMax, rightPositionMax, leftPositionCurrent, rightPositionCurrent));
        }
        return memberViewPairs;
    }

    private <T> List<T> union(List<T> list1, List<T> list2) {
        ArrayList<T> list2Difference = new ArrayList<T>(list2);
        list2Difference.removeAll(list1);
        ArrayList<T> union = new ArrayList<T>();
        union.addAll(list1);
        union.addAll(list2Difference);
        return union;
    }

    protected abstract DimensionViewPair createInitialDimensionViewPair(MemberViewPair var1);

    protected abstract List<IdentifiableObjectPair> createIdentifiableObjectPairs(DimensionViewPair var1);

    protected InflectionView getActualInflectionView(InflectionView staticInflectionView, Object object) {
        InflectionView actualInflectionView;
        if (staticInflectionView instanceof MemberView || staticInflectionView instanceof DimensionView || object == null) {
            actualInflectionView = staticInflectionView;
        } else if (staticInflectionView instanceof ClassView) {
            ClassView staticClassView = staticInflectionView;
            Class javaClass = staticClassView.getJavaClass();
            actualInflectionView = JAVA_BASIC_TYPES.contains(javaClass) ? staticInflectionView : (object instanceof List ? new DimensionView(true, false, true, Multiplicity.Many, object.getClass(), null) : (object instanceof Map ? new DimensionView(false, true, true, Multiplicity.Many, object.getClass(), null) : (object instanceof Set ? new DimensionView(false, false, true, Multiplicity.Many, object.getClass(), null) : (object.getClass().isArray() ? new DimensionView(true, false, true, Multiplicity.Many, object.getClass(), null) : this.getTaxonomy().getClassView(object.getClass())))));
        } else {
            throw new IllegalStateException("Unexpected type for staticInflectionView: " + staticInflectionView.getClass());
        }
        return actualInflectionView;
    }

    protected List<MemberView> getMemberViews(ClassView<?> classView) {
        return classView == null ? new ArrayList() : classView.getMemberViews();
    }

    protected Object createUserData() {
        return null;
    }

    private int getVisitCount(IdentifiableObjectPair identifiableObjectPair2) {
        VisitedObjectPair visitedPair = new VisitedObjectPair(identifiableObjectPair2);
        if (this.visitedObjectPairs.containsKey(visitedPair)) {
            visitedPair = this.visitedObjectPairs.get(visitedPair);
            visitedPair.incrementVisitCount();
        } else {
            this.visitedObjectPairs.put(visitedPair, visitedPair);
        }
        return visitedPair.getVisitCount();
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public <T extends InflectionViewFrame> T getFrame(int offsetFromCurrent) {
        return this.callStack.peek(offsetFromCurrent);
    }

    public <T extends InflectionViewFrame> T getCurrentFrame() {
        return this.getFrame(0);
    }

    public <T extends InflectionViewFrame> T getPreviousFrame() {
        return this.getFrame(1);
    }

    public MemberViewFrame getLastMemberViewFrame() {
        MemberViewFrame memberViewFrame = null;
        for (int i = 0; i < this.callStack.size(); ++i) {
            InflectionViewFrame frame = (InflectionViewFrame)this.callStack.get(this.callStack.size() - i - 1);
            if (!(frame instanceof MemberViewFrame)) continue;
            memberViewFrame = (MemberViewFrame)frame;
            break;
        }
        return memberViewFrame;
    }

    public <T extends InflectionViewFrame> T getLastFrameOfType(Class<T> frameType, int offset) {
        InflectionViewFrame foundFrame = null;
        for (int i = offset; i < this.callStack.size(); ++i) {
            InflectionViewFrame frame = (InflectionViewFrame)this.callStack.get(this.callStack.size() - i - 1);
            if (!frameType.isAssignableFrom(frame.getClass())) continue;
            foundFrame = frame;
            break;
        }
        return (T)foundFrame;
    }

    private InflectionViewFrame createFrame(InflectionViewPair inflectionViewPair, int positionCurrent, int positionMax) {
        InflectionViewFrame frame;
        if (inflectionViewPair instanceof IdentifiableObjectPair) {
            frame = this.createFrame((IdentifiableObjectPair)inflectionViewPair, positionCurrent, positionMax);
        } else if (inflectionViewPair instanceof MemberViewPair) {
            frame = this.createFrame((MemberViewPair)inflectionViewPair, positionCurrent, positionMax);
        } else {
            throw new IllegalStateException("Unexpected type for inflectionViewPair: " + inflectionViewPair.getClass().getName());
        }
        return frame;
    }

    private IdentifiableObjectFrame createFrame(IdentifiableObjectPair identifiableObjectPair, int positionCurrent, int positionMax) {
        IdentifiableObjectFrame frame;
        if (identifiableObjectPair instanceof ClassViewPair) {
            frame = this.createFrame((ClassViewPair)identifiableObjectPair, positionCurrent, positionMax);
        } else if (identifiableObjectPair instanceof DimensionViewPair) {
            frame = this.createFrame((DimensionViewPair)identifiableObjectPair, positionCurrent, positionMax);
        } else {
            throw new IllegalStateException("Unexpected type for identifiableObjectPair: " + identifiableObjectPair.getClass().getName());
        }
        return frame;
    }

    private ClassViewFrame createFrame(ClassViewPair classViewPair, int positionCurrent, int positionMax) {
        return new ClassViewFrame(classViewPair, positionCurrent, positionMax, this.createUserData(), this.getVisitCount(classViewPair));
    }

    private DimensionViewFrame createFrame(DimensionViewPair dimensionViewPair, int positionCurrent, int positionMax) {
        return new DimensionViewFrame(dimensionViewPair, positionCurrent, positionMax, this.createUserData(), this.getVisitCount(dimensionViewPair));
    }

    private MemberViewFrame createFrame(MemberViewPair memberViewPair, int positionCurrent, int positionMax) {
        return new MemberViewFrame(memberViewPair, positionCurrent, positionMax, this.createUserData());
    }

    protected IdentifiableObjectPool getIdentifiableObjectPool() {
        return IdentifiableObjectPool.getIdentifiableObjectPool();
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    static {
        JAVA_BASIC_TYPES.add(Byte.TYPE);
        JAVA_BASIC_TYPES.add(Short.TYPE);
        JAVA_BASIC_TYPES.add(Integer.TYPE);
        JAVA_BASIC_TYPES.add(Long.TYPE);
        JAVA_BASIC_TYPES.add(Float.TYPE);
        JAVA_BASIC_TYPES.add(Double.TYPE);
        JAVA_BASIC_TYPES.add(Character.TYPE);
        JAVA_BASIC_TYPES.add(Boolean.TYPE);
    }
}

