/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation;

import ch.liquidmind.inflection.InflectionResourceLoader;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Taxonomy;
import ch.liquidmind.inflection.model.Visitors;
import ch.liquidmind.inflection.model.VisitorsInstance;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.InflectionVisitor;
import ch.liquidmind.inflection.operation.MemberViewFrame;
import ch.liquidmind.inflection.operation.VisitingTraverser;

public abstract class ConfigurableVisitingTraverser
extends VisitingTraverser {
    public static final String VISITORS_SUFFIX = "Visitors";
    private VisitorsInstance visitorsInstance;

    public ConfigurableVisitingTraverser(Taxonomy taxonomy, VisitorsInstance visitorsInstance) {
        super(taxonomy, null);
        this.visitorsInstance = visitorsInstance;
    }

    @Override
    protected void traverse(ClassViewFrame frame) {
        MemberViewFrame lastMemberViewFrame = this.getLastMemberViewFrame();
        MemberView lastMemberView = lastMemberViewFrame == null ? null : lastMemberViewFrame.getMemberViewPair().getReferenceMemberView();
        this.setVisitor(lastMemberView, frame.getClassViewPair().getReferenceClassView());
        super.traverse(frame);
    }

    @Override
    protected void traverse(MemberViewFrame frame) {
        this.setDefaultVisitor();
        super.traverse(frame);
    }

    @Override
    protected void traverse(DimensionViewFrame frame) {
        this.setDefaultVisitor();
        super.traverse(frame);
    }

    private void setVisitor(MemberView memberView, ClassView<?> classView) {
        InflectionVisitor<VisitingTraverser> visitor = null;
        if (memberView != null) {
            visitor = this.visitorsInstance.getVisitor(memberView);
        }
        if (visitor == null) {
            ClassView<?> determiningClassView = memberView == null ? classView : memberView.getReferencedClassView();
            visitor = this.getVisitor(determiningClassView);
        }
        if (visitor == null) {
            visitor = this.visitorsInstance.getDefaultVisitor();
        }
        super.setVisitor(visitor);
    }

    private void setDefaultVisitor() {
        super.setVisitor(this.visitorsInstance.getDefaultVisitor());
    }

    private InflectionVisitor<VisitingTraverser> getVisitor(ClassView<?> classView) {
        InflectionVisitor<VisitingTraverser> visitor = this.visitorsInstance.getVisitor(classView);
        ClassView<?> superClassView = classView.getExtendedClassView();
        if (visitor == null && superClassView != null) {
            visitor = this.visitorsInstance.getVisitor(superClassView);
        }
        return visitor;
    }

    protected static VisitorsInstance getVisitors(String visitorsName) {
        Visitors visitors = InflectionResourceLoader.getContextInflectionResourceLoader().loadVisitors(visitorsName);
        return visitors.newInstance();
    }

    protected VisitorsInstance getVisitorsInstance() {
        return this.visitorsInstance;
    }
}

