/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation;

import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.model.ClassView;
import ch.liquidmind.inflection.model.DimensionView;
import ch.liquidmind.inflection.model.InflectionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Multiplicity;
import ch.liquidmind.inflection.model.Taxonomy;
import ch.liquidmind.inflection.model.VisitorsInstance;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.ClassViewPair;
import ch.liquidmind.inflection.operation.ConfigurableVisitingTraverser;
import ch.liquidmind.inflection.operation.DimensionViewPair;
import ch.liquidmind.inflection.operation.IdentifiableObjectPair;
import ch.liquidmind.inflection.operation.MemberViewPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DefaultPairingTraverser
extends ConfigurableVisitingTraverser {
    public DefaultPairingTraverser(Taxonomy taxonomy, VisitorsInstance visitorsInstance) {
        super(taxonomy, visitorsInstance);
    }

    @Override
    protected DimensionViewPair createInitialDimensionViewPair(MemberViewPair memberViewPair) {
        ClassViewFrame classViewFrame = (ClassViewFrame)this.getFrame(1);
        ClassViewPair classViewPair = classViewFrame.getClassViewPair();
        MemberView leftMemberView = memberViewPair.getLeftMemberView();
        MemberView rightMemberView = memberViewPair.getRightMemberView();
        DimensionView leftDimensionView = leftMemberView == null ? null : leftMemberView.getInitialDimensionView();
        DimensionView rightDimensionView = rightMemberView == null ? null : rightMemberView.getInitialDimensionView();
        IdentifiableObject<?, ?> leftMemberViewObject = this.getMemberViewObject(classViewPair.getLeftObject(), leftMemberView);
        IdentifiableObject<?, ?> rightMemberViewObject = this.getMemberViewObject(classViewPair.getRightObject(), rightMemberView);
        DimensionViewPair dimensionViewPair = new DimensionViewPair(leftDimensionView, rightDimensionView, (Integer)1, (Integer)1, (Integer)0, (Integer)0, null, null, leftMemberViewObject, rightMemberViewObject);
        return dimensionViewPair;
    }

    private IdentifiableObject<?, ?> getMemberViewObject(IdentifiableObject<?, ?> classViewObject, MemberView memberView) {
        IdentifiableObject memberViewObject;
        Object objectRaw;
        Object parentObjectRaw = classViewObject == null ? null : classViewObject.getObject();
        Object e = objectRaw = parentObjectRaw == null ? null : (Object)memberView.getMemberInstance(parentObjectRaw);
        if (memberView == null) {
            memberViewObject = null;
        } else if (memberView.getInitialDimensionView().getMultiplicity().equals((Object)Multiplicity.One)) {
            HashSet<Object> toOneSet = new HashSet<Object>();
            toOneSet.add(objectRaw);
            memberViewObject = this.getIdentifiableObjectPool().getIdentifiableObject(toOneSet);
        } else {
            memberViewObject = this.getIdentifiableObjectPool().getIdentifiableObject(objectRaw);
        }
        return memberViewObject;
    }

    @Override
    protected List<IdentifiableObjectPair> createIdentifiableObjectPairs(DimensionViewPair dimensionViewPair) {
        DimensionView dimensionView = dimensionViewPair.getReferenceDimensionView();
        List<IdentifiableObjectPair> identifiableObjectPairs = dimensionView == null ? new ArrayList<IdentifiableObjectPair>() : (dimensionView.isOrdered() ? this.createIdentifiableObjectPairsFromOrderedDimension(dimensionViewPair) : (dimensionView.isMapped() ? this.createIdentifiableObjectPairsFromMappedDimension(dimensionViewPair) : this.createIdentifiableObjectPairsFromUnorderedDimension(dimensionViewPair)));
        return identifiableObjectPairs;
    }

    protected List<IdentifiableObjectPair> createIdentifiableObjectPairsFromOrderedDimension(DimensionViewPair dimensionViewPair) {
        int rightSize;
        List<?> leftParentAsList = DefaultPairingTraverser.getAsList(dimensionViewPair.getLeftObject());
        List<?> rightParentAsList = DefaultPairingTraverser.getAsList(dimensionViewPair.getRightObject());
        int leftSize = leftParentAsList.size();
        int maxSize = leftSize > (rightSize = rightParentAsList.size()) ? leftSize : rightSize;
        ArrayList<IdentifiableObjectPair> identifiableObjectPairs = new ArrayList<IdentifiableObjectPair>();
        for (int i = 0; i < maxSize; ++i) {
            InflectionView leftStaticView = this.getNextStaticView(this.getLastMemberViewFrame().getMemberViewPair().getLeftMemberView(), dimensionViewPair.getLeftDimensionView());
            InflectionView rightStaticView = this.getNextStaticView(this.getLastMemberViewFrame().getMemberViewPair().getRightMemberView(), dimensionViewPair.getRightDimensionView());
            PairInfo leftPairInfo = this.getOrderedPairInfo(leftStaticView, i, leftSize, leftParentAsList);
            PairInfo rightPairInfo = this.getOrderedPairInfo(rightStaticView, i, rightSize, rightParentAsList);
            identifiableObjectPairs.add(this.createIdentifiableObjectPair(leftPairInfo.inflectionView, rightPairInfo.inflectionView, leftPairInfo.positionMax, leftPairInfo.positionCurrent, rightPairInfo.positionMax, rightPairInfo.positionCurrent, leftPairInfo.index, rightPairInfo.index, leftPairInfo.object, rightPairInfo.object));
        }
        return identifiableObjectPairs;
    }

    protected InflectionView getNextStaticView(MemberView memberView, DimensionView dimensionView) {
        return memberView == null ? null : memberView.getNextView(dimensionView);
    }

    public static List<?> getAsList(IdentifiableObject<?, ?> identifiableObject) {
        List<Object> resultList;
        if (identifiableObject == null) {
            resultList = new ArrayList();
        } else {
            Object arrayOrList = identifiableObject.getObject();
            if (arrayOrList instanceof List) {
                resultList = (List)arrayOrList;
            } else if (arrayOrList.getClass().isArray()) {
                resultList = Arrays.asList((Object[])arrayOrList);
            } else {
                throw new IllegalStateException("Invalid type for arrayOrList: " + arrayOrList.getClass().getName());
            }
        }
        return resultList;
    }

    private PairInfo getOrderedPairInfo(InflectionView staticInflectionView, int i, int size, List<?> parentAsList) {
        PairInfo pairInfo = new PairInfo();
        if (i < size) {
            Object object = parentAsList.get(i);
            pairInfo.inflectionView = this.getActualInflectionView(staticInflectionView, object);
            pairInfo.positionCurrent = i;
            pairInfo.positionMax = size;
            pairInfo.index = i;
            pairInfo.object = this.getIdentifiableObjectPool().getIdentifiableObject(object);
        }
        return pairInfo;
    }

    protected List<IdentifiableObjectPair> createIdentifiableObjectPairsFromMappedDimension(DimensionViewPair dimensionViewPair) {
        IdentifiableObject<?, ?> leftObject = dimensionViewPair.getLeftObject();
        IdentifiableObject<?, ?> rightObject = dimensionViewPair.getRightObject();
        Map leftParentAsMap = leftObject == null ? new HashMap() : (Map)leftObject.getObject();
        Map rightParentAsMap = rightObject == null ? new HashMap() : (Map)rightObject.getObject();
        HashSet keySet = new HashSet();
        keySet.addAll(leftParentAsMap.keySet());
        keySet.addAll(rightParentAsMap.keySet());
        ArrayList keyList = new ArrayList(keySet);
        int leftSize = leftParentAsMap.size();
        int rightSize = rightParentAsMap.size();
        int maxSize = keyList.size();
        ArrayList<IdentifiableObjectPair> identifiableObjectPairs = new ArrayList<IdentifiableObjectPair>();
        for (int i = 0; i < maxSize; ++i) {
            Object key = keyList.get(i);
            InflectionView leftStaticView = this.getNextStaticView(this.getLastMemberViewFrame().getMemberViewPair().getLeftMemberView(), dimensionViewPair.getLeftDimensionView());
            InflectionView rightStaticView = this.getNextStaticView(this.getLastMemberViewFrame().getMemberViewPair().getRightMemberView(), dimensionViewPair.getRightDimensionView());
            PairInfo leftPairInfo = this.getMappedPairInfo(leftStaticView, key, i, leftSize, leftParentAsMap);
            PairInfo rightPairInfo = this.getMappedPairInfo(rightStaticView, key, i, rightSize, rightParentAsMap);
            identifiableObjectPairs.add(this.createIdentifiableObjectPair(leftPairInfo.inflectionView, rightPairInfo.inflectionView, leftPairInfo.positionMax, leftPairInfo.positionCurrent, rightPairInfo.positionMax, rightPairInfo.positionCurrent, leftPairInfo.index, rightPairInfo.index, leftPairInfo.object, rightPairInfo.object));
        }
        return identifiableObjectPairs;
    }

    private PairInfo getMappedPairInfo(InflectionView staticInflectionView, Object key, int i, int size, Map<?, ?> parentAsMap) {
        PairInfo pairInfo = new PairInfo();
        if (parentAsMap.keySet().contains(key)) {
            Object object = parentAsMap.get(key);
            pairInfo.inflectionView = this.getActualInflectionView(staticInflectionView, object);
            pairInfo.positionCurrent = i;
            pairInfo.positionMax = size;
            pairInfo.index = key;
            pairInfo.object = this.getIdentifiableObjectPool().getIdentifiableObject(object);
        }
        return pairInfo;
    }

    protected IdentifiableObjectPair createIdentifiableObjectPair(InflectionView leftInflectionView, InflectionView rightInflectionView, Integer leftPositionMax, Integer leftPositionCurrent, Integer rightPositionMax, Integer rightPositionCurrent, Object leftIndex, Object rightIndex, IdentifiableObject<?, ?> leftObject, IdentifiableObject<?, ?> rightObject) {
        IdentifiableObjectPair identifiableObjectPair;
        InflectionView referenceInflectionView;
        InflectionView inflectionView = referenceInflectionView = leftInflectionView == null ? rightInflectionView : leftInflectionView;
        if (referenceInflectionView instanceof ClassView) {
            identifiableObjectPair = new ClassViewPair((ClassView)leftInflectionView, (ClassView)rightInflectionView, leftPositionMax, leftPositionCurrent, rightPositionMax, rightPositionCurrent, leftIndex, rightIndex, leftObject, rightObject);
        } else if (referenceInflectionView instanceof DimensionView) {
            identifiableObjectPair = new DimensionViewPair((DimensionView)leftInflectionView, (DimensionView)rightInflectionView, leftPositionMax, leftPositionCurrent, rightPositionMax, rightPositionCurrent, leftIndex, rightIndex, leftObject, rightObject);
        } else {
            throw new IllegalStateException("Invalid type for inflectionView: " + referenceInflectionView.getClass().getName());
        }
        return identifiableObjectPair;
    }

    protected List<IdentifiableObjectPair> createIdentifiableObjectPairsFromUnorderedDimension(DimensionViewPair dimensionViewPair) {
        IdentifiableObject<?, ?> leftObject = dimensionViewPair.getLeftObject();
        IdentifiableObject<?, ?> rightObject = dimensionViewPair.getRightObject();
        Set leftParentAsSet = leftObject == null ? new HashSet() : (Set)leftObject.getObject();
        Set rightParentAsSet = rightObject == null ? new HashSet() : (Set)rightObject.getObject();
        int leftSize = leftParentAsSet.size();
        int rightSize = rightParentAsSet.size();
        int maxSize = leftSize * rightSize;
        Iterator leftIter = leftParentAsSet.iterator();
        ArrayList<IdentifiableObjectPair> identifiableObjectPairs = new ArrayList<IdentifiableObjectPair>();
        for (int i = 0; i < leftSize; ++i) {
            Object leftRawObject = leftIter.next();
            IdentifiableObject leftChildObject = this.getIdentifiableObjectPool().getIdentifiableObject(leftRawObject);
            InflectionView leftStaticView = this.getNextStaticView(this.getLastMemberViewFrame().getMemberViewPair().getLeftMemberView(), dimensionViewPair.getLeftDimensionView());
            InflectionView leftInflectionView = this.getActualInflectionView(leftStaticView, leftRawObject);
            Iterator rightIter = rightParentAsSet.iterator();
            for (int j = 0; j < rightSize; ++j) {
                Object rightRawObject = rightIter.next();
                IdentifiableObject rightChildObject = this.getIdentifiableObjectPool().getIdentifiableObject(rightRawObject);
                InflectionView rightStaticView = this.getNextStaticView(this.getLastMemberViewFrame().getMemberViewPair().getRightMemberView(), dimensionViewPair.getRightDimensionView());
                InflectionView rightInflectionView = this.getActualInflectionView(rightStaticView, rightRawObject);
                int positionCurrent = i * rightSize + j;
                identifiableObjectPairs.add(this.createIdentifiableObjectPair(leftInflectionView, rightInflectionView, maxSize, positionCurrent, maxSize, positionCurrent, null, null, leftChildObject, rightChildObject));
            }
        }
        return identifiableObjectPairs;
    }

    private static class PairInfo {
        public InflectionView inflectionView = null;
        public Integer positionCurrent = null;
        public Integer positionMax = null;
        public Object index = null;
        public IdentifiableObject<?, ?> object = null;

        private PairInfo() {
        }
    }
}

