/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.basic;

import ch.liquidmind.inflection.model.Taxonomy;
import ch.liquidmind.inflection.model.VisitorsInstance;
import ch.liquidmind.inflection.operation.LeftGraphTraverser;
import java.util.ArrayList;
import java.util.List;

public class HashCodeTraverser
extends LeftGraphTraverser {
    public static final String DEFAULT_VISITORS = HashCodeTraverser.class.getName() + "Visitors";
    public static final int HASHCODING_PRIME = 31;
    private int compositeHashCode;

    public HashCodeTraverser(Taxonomy taxonomy) {
        this(taxonomy, HashCodeTraverser.getVisitors(DEFAULT_VISITORS));
    }

    public HashCodeTraverser(Taxonomy taxonomy, VisitorsInstance visitorsInstance) {
        super(taxonomy, visitorsInstance);
    }

    @Override
    protected Object createUserData() {
        return new HashCodes();
    }

    public int getCompositeHashCode() {
        return this.compositeHashCode;
    }

    public void setCompositeHashCode(int compositeHashCode) {
        this.compositeHashCode = compositeHashCode;
    }

    public static class HashCodes {
        private List<Integer> hashCodes = new ArrayList<Integer>();

        public void addHashCode(int hashCode) {
            this.hashCodes.add(hashCode);
        }

        public int getOrderedSum() {
            int orderedSum = 0;
            for (int hashCode : this.hashCodes) {
                orderedSum += hashCode * 31;
            }
            return orderedSum;
        }

        public int getUnorderedSum() {
            int unorderedSum = 0;
            for (int hashCode : this.hashCodes) {
                unorderedSum += hashCode;
            }
            return unorderedSum;
        }
    }
}

