/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.extended;

import ch.liquidmind.inflection.model.Taxonomy;
import ch.liquidmind.inflection.model.Visitors;
import ch.liquidmind.inflection.operation.ClassViewPair;
import ch.liquidmind.inflection.operation.Operations;
import ch.liquidmind.inflection.operation.extended.JsonTraverser;
import ch.liquidmind.inflection.operation.extended.SynchronizeTraverser;
import ch.liquidmind.inflection.operation.extended.ValidateTraverser;
import ch.liquidmind.inflection.operation.extended.ValidationError;
import java.io.OutputStream;
import java.util.List;

public class ExtendedOperations
extends Operations {
    public static void toJson(Object object, String taxonomy, String visitors) {
        ExtendedOperations.toJson(object, ExtendedOperations.getTaxonomy(taxonomy), ExtendedOperations.getVisitors(visitors));
    }

    public static void toJson(Object object, Taxonomy taxonomy, Visitors visitors) {
        ExtendedOperations.toJson(object, DEFAULT_DEFAULT_ROOT_CLASS, DEFAULT_OUTPUT_STREAM, taxonomy, visitors);
    }

    public static void toJson(Object rootObject, Class<?> defaultRootClass, OutputStream outputStream, Taxonomy taxonomy, Visitors visitors) {
        JsonTraverser traverser = new JsonTraverser(taxonomy, visitors.newInstance());
        traverser.setOutputStream(outputStream);
        ClassViewPair pair = traverser.createRootClassViewPair(rootObject, null, defaultRootClass);
        traverser.traverse(pair);
    }

    public static List<ValidationError> validate(Object object, String taxonomy, String visitors) {
        return ExtendedOperations.validate(object, ExtendedOperations.getTaxonomy(taxonomy), ExtendedOperations.getVisitors(visitors));
    }

    public static List<ValidationError> validate(Object object, Taxonomy taxonomy, Visitors visitors) {
        return ExtendedOperations.validate(object, DEFAULT_DEFAULT_ROOT_CLASS, DEFAULT_OUTPUT_STREAM, taxonomy, visitors);
    }

    public static List<ValidationError> validate(Object rootObject, Class<?> defaultRootClass, OutputStream outputStream, Taxonomy taxonomy, Visitors visitors) {
        ValidateTraverser traverser = new ValidateTraverser(taxonomy, visitors.newInstance());
        ClassViewPair pair = traverser.createRootClassViewPair(rootObject, null, defaultRootClass);
        traverser.traverse(pair);
        return traverser.getValidationErrors();
    }

    public static <T> T synchronize(Object leftRootObject, Object rightRootObject, String taxonomy, String visitors) {
        return ExtendedOperations.synchronize(leftRootObject, rightRootObject, ExtendedOperations.getTaxonomy(taxonomy), ExtendedOperations.getVisitors(visitors));
    }

    public static <T> T synchronize(Object leftRootObject, Object rightRootObject, Taxonomy taxonomy, Visitors visitors) {
        return ExtendedOperations.synchronize(leftRootObject, rightRootObject, DEFAULT_DEFAULT_ROOT_CLASS, taxonomy, visitors);
    }

    public static <T> T synchronize(Object leftRootObject, Object rightRootObject, Class<?> defaultRootClass, Taxonomy taxonomy, Visitors visitors) {
        SynchronizeTraverser traverser = new SynchronizeTraverser(taxonomy, visitors.newInstance());
        ClassViewPair pair = traverser.createRootClassViewPair(leftRootObject, rightRootObject, defaultRootClass);
        traverser.traverse(pair);
        return (T)pair.getRightObject().getObject();
    }
}

