/*
 * Decompiled with CFR 0.152.
 */
package ch.liquidmind.inflection.operation.extended;

import __java.lang.__Class;
import ch.liquidmind.inflection.IdentifiableObject;
import ch.liquidmind.inflection.IdentifiableObjectPool;
import ch.liquidmind.inflection.model.DimensionView;
import ch.liquidmind.inflection.model.MemberView;
import ch.liquidmind.inflection.model.Multiplicity;
import ch.liquidmind.inflection.operation.AbstractVisitor;
import ch.liquidmind.inflection.operation.ClassViewFrame;
import ch.liquidmind.inflection.operation.ClassViewPair;
import ch.liquidmind.inflection.operation.DimensionViewFrame;
import ch.liquidmind.inflection.operation.DimensionViewPair;
import ch.liquidmind.inflection.operation.IdentifiableObjectFrame;
import ch.liquidmind.inflection.operation.extended.SynchronizeTraverser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SynchronizeAbstractVisitor
extends AbstractVisitor<SynchronizeTraverser> {
    @Override
    public void visit(ClassViewFrame frame) {
        Object rightObject;
        ClassViewPair classViewPair = frame.getClassViewPair();
        IdentifiableObject<?, ?> leftIdentifiableObject = classViewPair.getLeftObject();
        Object leftObject = leftIdentifiableObject == null ? null : leftIdentifiableObject.getObject();
        IdentifiableObject<?, ?> rightIdentifiableObject = classViewPair.getRightObject();
        Object v0 = rightObject = rightIdentifiableObject == null ? null : rightIdentifiableObject.getObject();
        if (leftObject != null) {
            Object rightObjectSynchronized = this.synchronizeRightObject(classViewPair.getLeftClassView().getJavaClass(), leftObject, rightObject);
            IdentifiableObject rightIdentifiableObjectSynchronized = IdentifiableObjectPool.getIdentifiableObjectPool().getIdentifiableObject(rightObjectSynchronized);
            classViewPair.setRightClassView(classViewPair.getLeftClassView());
            classViewPair.setRightPositionCurrent(classViewPair.getRightPositionCurrent());
            classViewPair.setRightPositionMax(classViewPair.getRightPositionMax());
            classViewPair.setRightObject(rightIdentifiableObjectSynchronized);
            classViewPair.setRightIndex(classViewPair.getLeftIndex());
        }
        this.setJavaReference();
        ((SynchronizeTraverser)this.getTraverser()).continueTraversal();
    }

    @Override
    public void visit(DimensionViewFrame frame) {
        Object rightObject;
        DimensionViewPair dimensionViewPair = frame.getDimensionViewPair();
        Class leftType = (Class)dimensionViewPair.getLeftDimensionView().getDimensionType();
        IdentifiableObject<?, ?> leftIdentifiableObject = dimensionViewPair.getLeftObject();
        Object leftObject = leftIdentifiableObject == null ? null : (Object)leftIdentifiableObject.getObject();
        IdentifiableObject<?, ?> rightIdentifiableObject = dimensionViewPair.getRightObject();
        Object v0 = rightObject = rightIdentifiableObject == null ? null : rightIdentifiableObject.getObject();
        if (leftObject != null && rightObject == null) {
            if (!Collection.class.isAssignableFrom(leftObject.getClass())) {
                throw new IllegalStateException("Unexpected type for leftType: " + leftType.getName());
            }
            Object rightObjectSynchronized = __Class.newInstance((Class)leftType);
            IdentifiableObject rightIdentifiableObjectSynchronized = IdentifiableObjectPool.getIdentifiableObjectPool().getIdentifiableObject(rightObjectSynchronized);
            dimensionViewPair.setRightDimensionView(dimensionViewPair.getLeftDimensionView());
            dimensionViewPair.setRightIndex(dimensionViewPair.getLeftIndex());
            dimensionViewPair.setRightObject(rightIdentifiableObjectSynchronized);
            dimensionViewPair.setRightPositionCurrent(dimensionViewPair.getLeftPositionCurrent());
            dimensionViewPair.setRightPositionMax(dimensionViewPair.getLeftPositionMax());
        }
        this.setJavaReference();
        ((SynchronizeTraverser)this.getTraverser()).continueTraversal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setJavaReference() {
        Object previousFrame = ((SynchronizeTraverser)this.getTraverser()).getPreviousFrame();
        if (previousFrame == null || !(previousFrame instanceof DimensionViewFrame)) {
            return;
        }
        IdentifiableObjectFrame currentFrame = (IdentifiableObjectFrame)((SynchronizeTraverser)this.getTraverser()).getCurrentFrame();
        DimensionViewFrame dimensionViewFrame = (DimensionViewFrame)previousFrame;
        DimensionView rightDimensionView = dimensionViewFrame.getDimensionViewPair().getRightDimensionView();
        Object rightObject = currentFrame.getIdentifiableObjectPair().getRightObject().getObject();
        if (rightDimensionView.getMultiplicity().equals((Object)Multiplicity.One)) {
            ClassViewFrame classViewFrame = this.getLastClassViewFrame();
            Object rightContainingObject = classViewFrame.getIdentifiableObjectPair().getRightObject().getObject();
            MemberView rightMemberView = (MemberView)rightDimensionView.getParentView();
            rightMemberView.setMemberInstance(rightContainingObject, rightObject);
            return;
        } else {
            if (!rightDimensionView.getMultiplicity().equals((Object)Multiplicity.Many)) throw new IllegalStateException("Unexpected value for rightDimensionView.getMultiplicity(): " + (Object)((Object)rightDimensionView.getMultiplicity()));
            Class dimensionType = (Class)rightDimensionView.getDimensionType();
            if (List.class.isAssignableFrom(dimensionType)) {
                List listDimension = (List)dimensionViewFrame.getDimensionViewPair().getRightObject().getObject();
                int rightIndex = (Integer)currentFrame.getIdentifiableObjectPair().getRightIndex();
                this.ensureCapacity(listDimension, rightIndex + 1);
                listDimension.set(rightIndex, rightObject);
                return;
            } else {
                if (Set.class.isAssignableFrom(dimensionType)) {
                    throw new UnsupportedOperationException();
                }
                if (Map.class.isAssignableFrom(dimensionType)) {
                    throw new UnsupportedOperationException();
                }
                if (!dimensionType.isArray()) throw new IllegalStateException("Unexpected type for dimensionType: " + dimensionType.getName());
                throw new UnsupportedOperationException();
            }
        }
    }

    private void ensureCapacity(List<?> list, int newSize) {
        if (list.size() >= newSize) {
            return;
        }
        int difference = newSize - list.size();
        for (int i = 0; i < difference; ++i) {
            list.add(null);
        }
    }

    private ClassViewFrame getLastClassViewFrame() {
        int offset = 0;
        if (((SynchronizeTraverser)this.getTraverser()).getCurrentFrame() instanceof ClassViewFrame) {
            offset = 1;
        }
        ClassViewFrame classViewFrame = ((SynchronizeTraverser)this.getTraverser()).getLastFrameOfType(ClassViewFrame.class, offset);
        return classViewFrame;
    }

    protected abstract Object synchronizeRightObject(Class<?> var1, Object var2, Object var3);
}

